/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.JavaLangSubstitutions;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.Target_java_lang_AssertionStatusDirectives;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import com.oracle.svm.core.jdk.Target_java_lang_NamedPackage;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

@TargetClass(value=ClassLoader.class)
@Substitute
public final class Target_java_lang_ClassLoader {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=ArrayList.class)
    private ArrayList<URL> path;
    @Substitute
    private Target_java_lang_ClassLoader parent;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=HashMap.class)
    private HashMap<String, ?> lmap;
    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private final ConcurrentHashMap<String, Target_java_lang_NamedPackage> packages = new ConcurrentHashMap();

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native URL[] getLookupCacheURLs(ClassLoader var0);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native int[] getLookupCacheForClassLoader(ClassLoader var0, String var1);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native boolean knownToNotExist0(ClassLoader var0, String var1);

    @Substitute
    public Target_java_lang_ClassLoader() {
        this.parent = null;
    }

    @Substitute
    public Target_java_lang_ClassLoader getParent() {
        return this.parent;
    }

    @Substitute
    public Target_java_lang_ClassLoader(Target_java_lang_ClassLoader parent) {
        this.parent = parent;
    }

    @Substitute
    private InputStream getResourceAsStream(String name) {
        return Target_java_lang_ClassLoader.getSystemResourceAsStream(name);
    }

    @Substitute
    private static InputStream getSystemResourceAsStream(String name) {
        List<byte[]> arr = Resources.get(name);
        return arr == null ? null : new ByteArrayInputStream(arr.get(0));
    }

    @Substitute
    private URL getResource(String name) {
        return Target_java_lang_ClassLoader.getSystemResource(name);
    }

    @Substitute
    private static URL getSystemResource(String name) {
        List<byte[]> arr = Resources.get(name);
        return arr == null ? null : Resources.createURL(name, arr.get(0));
    }

    @Substitute
    private Enumeration<URL> getResources(String name) {
        return Target_java_lang_ClassLoader.getSystemResources(name);
    }

    @Substitute
    private static Enumeration<URL> getSystemResources(String name) {
        List<byte[]> arr = Resources.get(name);
        if (arr == null) {
            return Collections.emptyEnumeration();
        }
        ArrayList<URL> res = new ArrayList<URL>(arr.size());
        for (byte[] data : arr) {
            res.add(Resources.createURL(name, data));
        }
        return Collections.enumeration(res);
    }

    @Substitute
    public static ClassLoader getSystemClassLoader() {
        return SubstrateUtil.cast(JavaLangSubstitutions.ClassLoaderSupport.getInstance().systemClassLoader, ClassLoader.class);
    }

    @Substitute
    static void loadLibrary(Class<?> fromClass, String name, boolean isAbsolute) {
        NativeLibrarySupport.singleton().loadLibrary(name, isAbsolute);
    }

    @Substitute
    private Class<?> loadClass(String name) throws ClassNotFoundException {
        return ClassForNameSupport.forName(name, false);
    }

    @Substitute
    static void checkClassLoaderPermission(ClassLoader cl, Class<?> caller) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public static ClassLoader getPlatformClassLoader() {
        return SubstrateUtil.cast(JavaLangSubstitutions.ClassLoaderSupport.getInstance().platformClassLoader, ClassLoader.class);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    Class<?> loadClass(Target_java_lang_Module module, String name) {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.loadClass(Target_java_lang_Module, String)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    ConcurrentHashMap<?, ?> createOrGetClassLoaderValueMap() {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.createOrGetClassLoaderValueMap()");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private boolean trySetObjectField(String name, Object obj) {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.trySetObjectField(String name, Object obj)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    protected URL findResource(String moduleName, String name) throws IOException {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.findResource(String, String)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    static ClassLoader getBuiltinPlatformClassLoader() {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.getBuiltinPlatformClassLoader()");
    }

    @Substitute
    Object getClassLoadingLock(String className) {
        throw VMError.unsupportedFeature("Target_java_lang_ClassLoader.getClassLoadingLock(String)");
    }

    @Substitute
    private Class<?> findLoadedClass0(String name) {
        throw VMError.unsupportedFeature("Target_java_lang_ClassLoader.findLoadedClass0(String)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    protected Class<?> findClass(String moduleName, String name) {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.findClass(String moduleName, String name)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public Package getDefinedPackage(String name) {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.getDefinedPackage(String name)");
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK11OrLater.class})
    public native Package definePackage(Class<?> var1);

    @KeepOriginal
    @TargetElement(onlyWith={JDK11OrLater.class})
    public native Package definePackage(String var1, Target_java_lang_Module var2);

    @KeepOriginal
    @TargetElement(onlyWith={JDK11OrLater.class})
    private native Package toPackage(String var1, Target_java_lang_NamedPackage var2, Target_java_lang_Module var3);

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public Target_java_lang_Module getUnnamedModule() {
        return DynamicHub.singleModuleReference.get();
    }

    @Substitute
    private void setDefaultAssertionStatus(boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void setPackageAssertionStatus(String packageName, boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void setClassAssertionStatus(String className, boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void clearAssertionStatus() {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Delete
    private static native void registerNatives();

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native Class<?> defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native Class<?> defineClass1(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native Class<?> defineClass2(String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native void resolveClass0(Class<?> var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static native Class<?> defineClass1(ClassLoader var0, String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static native Class<?> defineClass2(ClassLoader var0, String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    private native Class<?> findBootstrapClass(String var1);

    @Delete
    private static native String findBuiltinLib(String var0);

    @Delete
    private static native Target_java_lang_AssertionStatusDirectives retrieveDirectives();
}

