/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.validator;

import com.sun.faces.util.RequestStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.validator.Validator;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.ValidatorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentValidators {
    private static final String COMPONENT_VALIDATORS = "javax.faces.component.ComponentValidators";
    private LinkedList<ValidatorInfo> validatorStack = new LinkedList();

    public static ComponentValidators getValidators(FacesContext context, boolean createIfNull) {
        Map<Object, Object> attrs = context.getAttributes();
        ComponentValidators componentValidators = (ComponentValidators)attrs.get(COMPONENT_VALIDATORS);
        if (componentValidators == null && createIfNull) {
            componentValidators = new ComponentValidators();
            attrs.put(COMPONENT_VALIDATORS, componentValidators);
        }
        return componentValidators;
    }

    public static void addDefaultValidatorsToComponent(FacesContext ctx, EditableValueHolder editableValueHolder) {
        if (!ctx.isPostback() || ctx.getCurrentPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            Set<String> keySet = ctx.getApplication().getDefaultValidatorInfo().keySet();
            ArrayList<String> validatorIds = new ArrayList<String>(keySet.size());
            Set disabledValidatorIds = (Set)RequestStateManager.remove(ctx, "com.sun.faces.DISABLED_VALIDATORS");
            for (String key : keySet) {
                if (disabledValidatorIds != null && disabledValidatorIds.contains(key)) continue;
                validatorIds.add(key);
            }
            ComponentValidators.addValidatorsToComponent(ctx, validatorIds, editableValueHolder, null);
        }
    }

    public void addValidators(FacesContext ctx, EditableValueHolder editableValueHolder) {
        if (this.validatorStack == null || this.validatorStack.isEmpty()) {
            ComponentValidators.addDefaultValidatorsToComponent(ctx, editableValueHolder);
            return;
        }
        Application application = ctx.getApplication();
        Map<String, String> defaultValidatorInfo = application.getDefaultValidatorInfo();
        Set<String> keySet = defaultValidatorInfo.keySet();
        ArrayList<String> validatorIds = new ArrayList<String>(keySet.size());
        for (String key : keySet) {
            validatorIds.add(key);
        }
        Set disabledIds = (Set)RequestStateManager.remove(ctx, "com.sun.faces.DISABLED_VALIDATORS");
        int count = this.validatorStack.size();
        for (int i = count - 1; i >= 0; --i) {
            ValidatorInfo info = this.validatorStack.get(i);
            if (!info.isEnabled() || disabledIds != null && disabledIds.contains(info.getValidatorId())) {
                if (!validatorIds.contains(info.getValidatorId())) continue;
                validatorIds.remove(info.getValidatorId());
                continue;
            }
            if (validatorIds.contains(info.getValidatorId())) continue;
            validatorIds.add(info.getValidatorId());
        }
        ComponentValidators.addValidatorsToComponent(ctx, validatorIds, editableValueHolder, this.validatorStack == null || this.validatorStack.isEmpty() ? null : this.validatorStack);
    }

    public void pushValidatorInfo(ValidatorInfo info) {
        this.validatorStack.add(info);
    }

    public void popValidatorInfo() {
        if (this.validatorStack.size() > 0) {
            this.validatorStack.removeLast();
        }
    }

    private static void addValidatorsToComponent(FacesContext ctx, Collection<String> validatorIds, EditableValueHolder editableValueHolder, LinkedList<ValidatorInfo> validatorStack) {
        if (validatorIds == null || validatorIds.isEmpty()) {
            return;
        }
        Application application = ctx.getApplication();
        Map<String, String> defaultValidatorInfo = application.getDefaultValidatorInfo();
        Validator[] validators = editableValueHolder.getValidators();
        block0: for (Map.Entry<String, String> defaultValidator : defaultValidatorInfo.entrySet()) {
            for (Validator validator : validators) {
                if (!defaultValidator.getValue().equals(validator.getClass().getName())) continue;
                validatorIds.remove(defaultValidator.getKey());
                continue block0;
            }
        }
        for (String id : validatorIds) {
            Validator v = application.createValidator(id);
            if (validatorStack != null) {
                for (int i = validatorStack.size() - 1; i >= 0; --i) {
                    ValidatorInfo info = validatorStack.get(i);
                    if (!id.equals(info.getValidatorId())) continue;
                    info.applyAttributes(v);
                    break;
                }
            }
            editableValueHolder.addValidator(v);
        }
    }

    public static class ValidatorInfo {
        private String validatorId;
        private boolean enabled;
        private ValidatorHandler owner;
        private FaceletContext ctx;

        public ValidatorInfo(FaceletContext ctx, ValidatorHandler owner) {
            this.owner = owner;
            this.ctx = ctx;
            this.validatorId = owner.getValidatorId(ctx);
            this.enabled = !owner.isDisabled(ctx);
        }

        public String getValidatorId() {
            return this.validatorId;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void applyAttributes(Validator v) {
            this.owner.setAttributes(this.ctx, v);
        }
    }
}

