/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.maven;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.InterpolatorFilterReader;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;
import org.fusesource.hawtjni.generator.HawtJNI;
import org.fusesource.hawtjni.generator.ProgressMonitor;
import org.fusesource.hawtjni.maven.CLI;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter
    private File nativeSourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/hawtjni/native-src")
    private File generatedNativeSourceDirectory;
    @Parameter(defaultValue="${project.artifactId}")
    private String name;
    @Parameter(defaultValue="")
    private String copyright;
    @Parameter
    private List<String> packages = new ArrayList<String>();
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/hawtjni/native-package")
    private File packageDirectory;
    @Parameter(defaultValue="${basedir}/src/main/native-package")
    private File customPackageDirectory;
    @Parameter(defaultValue="UTF-8")
    private String encoding;
    @Parameter(defaultValue="${skip-autogen}")
    private boolean skipAutogen;
    @Parameter(defaultValue="${force-autogen}")
    private boolean forceAutogen;
    @Parameter(defaultValue="${hawtjni-verbose}")
    private boolean verbose;
    @Parameter
    private List<String> autogenArgs;
    @Parameter(defaultValue="true")
    private boolean callbacks;
    @Parameter(defaultValue="detect")
    private String windowsBuildTool;
    @Parameter
    private String windowsProjectName;
    @Parameter(defaultValue="false")
    private boolean windowsCustomProps;
    @Parameter(defaultValue="4.0")
    private String windowsToolsVersion;
    @Parameter
    private String windowsTargetPlatformVersion;
    @Parameter
    private String windowsPlatformToolset;
    private File targetSrcDir;
    private CLI cli = new CLI();

    public void execute() throws MojoExecutionException {
        this.cli.verbose = this.verbose;
        this.cli.log = this.getLog();
        if (this.nativeSourceDirectory == null) {
            this.generateNativeSourceFiles();
        } else {
            this.copyNativeSourceFiles();
        }
        this.generateBuildSystem();
    }

    private void copyNativeSourceFiles() throws MojoExecutionException {
        try {
            FileUtils.copyDirectory((File)this.nativeSourceDirectory, (File)this.generatedNativeSourceDirectory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Copy of Native source failed: " + e, e);
        }
    }

    private void generateNativeSourceFiles() throws MojoExecutionException {
        HawtJNI generator = new HawtJNI();
        generator.setClasspaths(this.getClasspath());
        generator.setName(this.name);
        generator.setCopyright(this.copyright);
        generator.setNativeOutput(this.generatedNativeSourceDirectory);
        generator.setPackages(this.packages);
        generator.setCallbacks(this.callbacks);
        generator.setProgress(new ProgressMonitor(){

            public void step() {
            }

            public void setTotal(int total) {
            }

            public void setMessage(String message) {
                GenerateMojo.this.getLog().info((CharSequence)message);
            }
        });
        try {
            generator.generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Native source code generation failed: " + e, e);
        }
    }

    private void generateBuildSystem() throws MojoExecutionException {
        try {
            this.packageDirectory.mkdirs();
            new File(this.packageDirectory, "m4").mkdirs();
            this.targetSrcDir = new File(this.packageDirectory, "src");
            this.targetSrcDir.mkdirs();
            if (this.customPackageDirectory != null && this.customPackageDirectory.isDirectory()) {
                FileUtils.copyDirectoryStructureIfModified((File)this.customPackageDirectory, (File)this.packageDirectory);
            }
            if (this.generatedNativeSourceDirectory != null && this.generatedNativeSourceDirectory.isDirectory()) {
                FileUtils.copyDirectoryStructureIfModified((File)this.generatedNativeSourceDirectory, (File)this.targetSrcDir);
            }
            this.copyTemplateResource("readme.md", false);
            this.copyTemplateResource("configure.ac", true);
            this.copyTemplateResource("Makefile.am", true);
            this.copyTemplateResource("m4/custom.m4", false);
            this.copyTemplateResource("m4/jni.m4", false);
            this.copyTemplateResource("m4/osx-universal.m4", false);
            String tool = this.windowsBuildTool.toLowerCase().trim();
            if ("detect".equals(tool)) {
                this.copyTemplateResource("vs2008.vcproj", (this.windowsProjectName != null ? this.windowsProjectName : "vs2008") + ".vcproj", true);
                this.copyTemplateResource("vs2010.vcxproj", (this.windowsProjectName != null ? this.windowsProjectName : "vs2010") + ".vcxproj", true);
                if (this.windowsCustomProps) {
                    this.copyTemplateResource("vs2010.custom.props", (this.windowsProjectName != null ? this.windowsProjectName : "vs2010") + ".custom.props", true);
                }
            } else if ("msbuild".equals(tool)) {
                this.copyTemplateResource("vs2010.vcxproj", (this.windowsProjectName != null ? this.windowsProjectName : "vs2010") + ".vcxproj", true);
                if (this.windowsCustomProps) {
                    this.copyTemplateResource("vs2010.custom.props", (this.windowsProjectName != null ? this.windowsProjectName : "vs2010") + ".custom.props", true);
                }
            } else if ("vcbuild".equals(tool)) {
                this.copyTemplateResource("vs2008.vcproj", (this.windowsProjectName != null ? this.windowsProjectName : "vs2008") + ".vcproj", true);
            } else if (!"none".equals(tool)) {
                throw new MojoExecutionException("Invalid setting for windowsBuildTool: " + this.windowsBuildTool);
            }
            File autogen = new File(this.packageDirectory, "autogen.sh");
            File configure = new File(this.packageDirectory, "configure");
            if (!autogen.exists()) {
                this.copyTemplateResource("autogen.sh", false);
                this.cli.setExecutable(autogen);
            }
            if (!this.skipAutogen && (!configure.exists() && !CLI.IS_WINDOWS || this.forceAutogen)) {
                try {
                    this.cli.system(this.packageDirectory, new String[]{"./autogen.sh"}, this.autogenArgs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Native build system generation failed: " + e, e);
        }
    }

    private ArrayList<String> getClasspath() throws MojoExecutionException {
        ArrayList<String> artifacts = new ArrayList<String>();
        try {
            artifacts.add(this.classesDirectory.getCanonicalPath());
            for (Artifact artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                this.getLog().debug((CharSequence)("Including: " + file));
                artifacts.add(file.getCanonicalPath());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not determine project classath.", (Exception)e);
        }
        return artifacts;
    }

    private void copyTemplateResource(String file, boolean filter) throws MojoExecutionException {
        this.copyTemplateResource(file, file, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTemplateResource(String file, String output, boolean filter) throws MojoExecutionException {
        try {
            File target = FileUtils.resolveFile((File)this.packageDirectory, (String)output);
            if (target.isFile() && target.canRead()) {
                return;
            }
            URL source = ((Object)((Object)this)).getClass().getClassLoader().getResource("project-template/" + file);
            File tmp = FileUtils.createTempFile((String)"tmp", (String)"txt", (File)new File(this.project.getBuild().getDirectory()));
            try {
                FileUtils.copyURLToFile((URL)source, (File)tmp);
                FileUtils.copyFile((File)tmp, (File)target, (String)this.encoding, (FileUtils.FilterWrapper[])this.filters(filter), (boolean)true);
            }
            finally {
                tmp.delete();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not extract template resource: " + file, (Exception)e);
        }
    }

    private FileUtils.FilterWrapper[] filters(boolean filter) throws IOException {
        if (!filter) {
            return new FileUtils.FilterWrapper[0];
        }
        String startExp = "@";
        String endExp = "@";
        String escapeString = "\\";
        final HashMap<String, String> values = new HashMap<String, String>();
        values.put("PROJECT_NAME", this.name);
        values.put("PROJECT_NAME_UNDER_SCORE", this.name.replaceAll("\\W", "_"));
        values.put("VERSION", this.project.getVersion());
        ArrayList cpp_files = new ArrayList();
        cpp_files.addAll(FileUtils.getFileNames((File)this.targetSrcDir, (String)"**/*.cpp", null, (boolean)false));
        cpp_files.addAll(FileUtils.getFileNames((File)this.targetSrcDir, (String)"**/*.cxx", null, (boolean)false));
        ArrayList files = new ArrayList();
        files.addAll(cpp_files);
        files.addAll(FileUtils.getFileNames((File)this.targetSrcDir, (String)"**/*.c", null, (boolean)false));
        files.addAll(FileUtils.getFileNames((File)this.targetSrcDir, (String)"**/*.m", null, (boolean)false));
        String sources = "";
        String xml_sources = "";
        String vs10_sources = "";
        boolean first = true;
        for (String f : files) {
            if (!first) {
                sources = sources + "\\\n";
            } else {
                values.put("FIRST_SOURCE_FILE", "src/" + f.replace('\\', '/'));
                first = false;
            }
            sources = sources + "  src/" + f;
            xml_sources = xml_sources + "      <File RelativePath=\".\\src\\" + f.replace('/', '\\') + "\" />\n";
            vs10_sources = vs10_sources + "    <ClCompile Include=\".\\src\\" + f.replace('/', '\\') + "\" />\n";
        }
        if (cpp_files.isEmpty()) {
            values.put("AC_PROG_CHECKS", "AC_PROG_CC");
        } else {
            values.put("AC_PROG_CHECKS", "AC_PROG_CXX");
        }
        values.put("PROJECT_SOURCES", sources);
        values.put("PROJECT_XML_SOURCES", xml_sources);
        values.put("PROJECT_VS10_SOURCES", vs10_sources);
        values.put("CUSTOM_PROPS", this.windowsCustomProps ? "<Import Project=\"" + (this.windowsProjectName != null ? this.windowsProjectName : "vs2010") + ".custom.props\" />" : "");
        values.put("TOOLS_VERSION", this.windowsToolsVersion);
        values.put("TARGET_PLATFORM_VERSION", this.windowsTargetPlatformVersion != null ? "<WindowsTargetPlatformVersion>" + this.windowsTargetPlatformVersion + "</WindowsTargetPlatformVersion>" : "");
        values.put("PLATFORM_TOOLSET", this.windowsPlatformToolset != null ? "<PlatformToolset>" + this.windowsPlatformToolset + "</PlatformToolset>" : "");
        FileUtils.FilterWrapper wrapper = new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                StringSearchInterpolator propertiesInterpolator = new StringSearchInterpolator("@", "@");
                propertiesInterpolator.addValueSource((ValueSource)new MapBasedValueSource(values));
                propertiesInterpolator.setEscapeString("\\");
                InterpolatorFilterReader interpolatorFilterReader = new InterpolatorFilterReader(reader, (Interpolator)propertiesInterpolator, "@", "@");
                interpolatorFilterReader.setInterpolateWithPrefixPattern(false);
                return interpolatorFilterReader;
            }
        };
        return new FileUtils.FilterWrapper[]{wrapper};
    }
}

