/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.maven;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CLI {
    public static final boolean IS_WINDOWS = CLI.isWindows();
    public boolean verbose;
    public Log log;

    private static boolean isWindows() {
        String name = System.getProperty("os.name").toLowerCase().trim();
        return name.startsWith("win");
    }

    public void setExecutable(File path) {
        if (IS_WINDOWS) {
            return;
        }
        try {
            if (!path.canExecute()) {
                path.setExecutable(true);
            }
        }
        catch (NoSuchMethodError e1) {
            try {
                this.system(path.getParentFile(), new String[]{"chmod", "a+x", path.getCanonicalPath()});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int system(File wd, String[] command) throws CommandLineException {
        return this.system(wd, command, null);
    }

    public int system(File wd, String[] command, List<String> args) throws CommandLineException {
        String nl;
        int rc;
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(wd);
        for (String c : command) {
            cli.createArg().setValue(c);
        }
        if (args != null) {
            for (String arg : args) {
                cli.createArg().setValue(arg);
            }
        }
        this.log.info((CharSequence)("executing: " + cli));
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                CLI.this.log.info((CharSequence)line);
            }
        };
        if (!this.verbose) {
            consumer = new CommandLineUtils.StringStreamConsumer();
        }
        if ((rc = CommandLineUtils.executeCommandLine((Commandline)cli, null, (StreamConsumer)consumer, (StreamConsumer)consumer)) != 0) {
            String output;
            if (!this.verbose && (output = ((CommandLineUtils.StringStreamConsumer)consumer).getOutput()).length() > 0) {
                String[] lines;
                nl = System.getProperty("line.separator");
                for (String line : lines = output.split(Pattern.quote(nl))) {
                    this.log.info((CharSequence)line);
                }
            }
            this.log.info((CharSequence)("rc: " + rc));
        } else {
            String output;
            if (!this.verbose && (output = ((CommandLineUtils.StringStreamConsumer)consumer).getOutput()).length() > 0) {
                String[] lines;
                nl = System.getProperty("line.separator");
                for (String line : lines = output.split(Pattern.quote(nl))) {
                    this.log.debug((CharSequence)line);
                }
            }
            this.log.debug((CharSequence)("rc: " + rc));
        }
        return rc;
    }
}

