/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.fusesource.hawtjni.maven.CLI;
import org.fusesource.hawtjni.runtime.Library;

@Mojo(name="build", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES)
public class BuildMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List remoteArtifactRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    private ArchiverManager archiverManager;
    @Parameter(defaultValue="${project.artifactId}")
    private String name;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/hawtjni/native-package")
    private File packageDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/hawtjni/lib")
    private File libDirectory;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDirectory;
    @Parameter(defaultValue="${skip-autogen}")
    private boolean skipAutogen;
    @Parameter(defaultValue="${force-autogen}")
    private boolean forceAutogen;
    @Parameter
    private List<String> autogenArgs;
    @Parameter(defaultValue="${skip-configure}")
    private boolean skipConfigure;
    @Parameter(defaultValue="${force-configure}")
    private boolean forceConfigure;
    @Parameter(defaultValue="${hawtjni-verbose}")
    private boolean verbose;
    @Parameter
    private List<String> configureArgs;
    @Parameter
    private String platform;
    @Parameter(defaultValue="native-src")
    private String sourceClassifier;
    @Parameter(defaultValue="true")
    private boolean downloadSourcePackage = true;
    @Parameter
    private Dependency nativeSrcDependency;
    @Parameter(defaultValue="${native-src-url}")
    private String nativeSrcUrl;
    @Parameter(defaultValue="detect")
    private String windowsBuildTool;
    @Parameter
    private String windowsProjectName;
    private final CLI cli = new CLI();

    public void execute() throws MojoExecutionException {
        this.cli.verbose = this.verbose;
        this.cli.log = this.getLog();
        try {
            File buildDir = new File(this.buildDirectory, "native-build");
            buildDir.mkdirs();
            if (CLI.IS_WINDOWS) {
                this.vsBasedBuild(buildDir);
            } else {
                this.configureBasedBuild(buildDir);
            }
            this.getLog().info((CharSequence)("Adding test resource root: " + this.libDirectory.getAbsolutePath()));
            Resource testResource = new Resource();
            testResource.setDirectory(this.libDirectory.getAbsolutePath());
            this.project.addTestResource(testResource);
        }
        catch (Exception e) {
            throw new MojoExecutionException("build failed: " + e, e);
        }
    }

    private void vsBasedBuild(File buildDir) throws CommandLineException, MojoExecutionException, IOException {
        int rc;
        String platform;
        FileUtils.copyDirectoryStructureIfModified((File)this.packageDirectory, (File)buildDir);
        Library library = new Library(this.name);
        String libPlatform = this.platform != null ? this.platform : Library.getPlatform();
        String configuration = "release";
        if ("windows32".equals(libPlatform)) {
            platform = "Win32";
        } else if ("windows64".equals(libPlatform)) {
            platform = "x64";
        } else {
            throw new MojoExecutionException("Unsupported platform: " + libPlatform);
        }
        boolean useMSBuild = false;
        String tool = this.windowsBuildTool.toLowerCase().trim();
        if ("detect".equals(tool)) {
            String toolset = System.getenv("PlatformToolset");
            if ("Windows7.1SDK".equals(toolset)) {
                useMSBuild = true;
            } else {
                String vcinstalldir = System.getenv("VCINSTALLDIR");
                if (vcinstalldir != null && (vcinstalldir.contains("Microsoft Visual Studio 10") || vcinstalldir.contains("Microsoft Visual Studio 11") || vcinstalldir.contains("Microsoft Visual Studio 12") || vcinstalldir.contains("Microsoft Visual Studio 14") || vcinstalldir.contains("Microsoft Visual Studio\\2017"))) {
                    useMSBuild = true;
                }
            }
        } else if ("msbuild".equals(tool)) {
            useMSBuild = true;
        } else if ("vcbuild".equals(tool)) {
            useMSBuild = false;
        } else {
            throw new MojoExecutionException("Invalid setting for windowsBuildTool: " + this.windowsBuildTool);
        }
        if (useMSBuild ? (rc = this.cli.system(buildDir, new String[]{"msbuild", (this.windowsProjectName != null ? this.windowsProjectName : "vs2010") + ".vcxproj", "/property:Platform=" + platform, "/property:Configuration=" + configuration})) != 0 : (rc = this.cli.system(buildDir, new String[]{"vcbuild", "/platform:" + platform, (this.windowsProjectName != null ? this.windowsProjectName : "vs2008") + ".vcproj", configuration})) != 0) {
            throw new MojoExecutionException("vcbuild failed with exit code: " + rc);
        }
        File libFile = FileUtils.resolveFile((File)buildDir, (String)("target/" + platform + "-" + configuration + "/lib/" + library.getLibraryFileName()));
        if (!libFile.exists()) {
            throw new MojoExecutionException("vcbuild did not generate: " + libFile);
        }
        File target = FileUtils.resolveFile((File)this.libDirectory, (String)library.getPlatformSpecificResourcePath(libPlatform));
        FileUtils.copyFile((File)libFile, (File)target);
    }

    private void configureBasedBuild(File buildDir) throws IOException, MojoExecutionException, CommandLineException {
        int rc;
        File configure = new File(this.packageDirectory, "configure");
        if (configure.exists()) {
            FileUtils.copyDirectoryStructureIfModified((File)this.packageDirectory, (File)buildDir);
        } else if (this.downloadSourcePackage) {
            this.downloadNativeSourcePackage(buildDir);
        } else if (!buildDir.exists()) {
            throw new MojoExecutionException("The configure script is missing from the generated native source package and downloadSourcePackage is disabled: " + configure);
        }
        configure = new File(buildDir, "configure");
        File autogen = new File(buildDir, "autogen.sh");
        File makefile = new File(buildDir, "Makefile");
        File distDirectory = new File(buildDir, "target");
        File distLibDirectory = new File(distDirectory, "lib");
        distLibDirectory.mkdirs();
        if (autogen.exists() && !this.skipAutogen && (!configure.exists() && !CLI.IS_WINDOWS || this.forceAutogen)) {
            this.cli.setExecutable(autogen);
            rc = this.cli.system(buildDir, new String[]{"./autogen.sh"}, this.autogenArgs);
            if (rc != 0) {
                throw new MojoExecutionException("./autogen.sh failed with exit code: " + rc);
            }
        }
        if (configure.exists() && !this.skipConfigure && (!makefile.exists() || this.forceConfigure)) {
            File autotools = new File(buildDir, "autotools");
            File[] listFiles = autotools.listFiles();
            if (listFiles != null) {
                for (File file : listFiles) {
                    this.cli.setExecutable(file);
                }
            }
            this.cli.setExecutable(configure);
            int rc2 = this.cli.system(buildDir, new String[]{"./configure", "--disable-ccache", "--prefix=" + distDirectory.getCanonicalPath(), "--libdir=" + distDirectory.getCanonicalPath() + "/lib"}, this.configureArgs);
            if (rc2 != 0) {
                throw new MojoExecutionException("./configure failed with exit code: " + rc2);
            }
        }
        if ((rc = this.cli.system(buildDir, new String[]{"make", "install"})) != 0) {
            throw new MojoExecutionException("make based build failed with exit code: " + rc);
        }
        Library library = new Library(this.name);
        File libFile = new File(distLibDirectory, library.getLibraryFileName());
        if (!libFile.exists()) {
            throw new MojoExecutionException("Make based build did not generate: " + libFile);
        }
        if (this.platform == null) {
            this.platform = library.getPlatform();
        }
        File target = FileUtils.resolveFile((File)this.libDirectory, (String)library.getPlatformSpecificResourcePath(this.platform));
        FileUtils.copyFile((File)libFile, (File)target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadNativeSourcePackage(File buildDir) throws MojoExecutionException {
        File packageZipFile;
        if (this.nativeSrcUrl == null || this.nativeSrcUrl.trim().length() == 0) {
            Artifact artifact = null;
            artifact = this.nativeSrcDependency == null ? this.artifactFactory.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "zip", this.sourceClassifier) : this.artifactFactory.createArtifactWithClassifier(this.nativeSrcDependency.getGroupId(), this.nativeSrcDependency.getArtifactId(), this.nativeSrcDependency.getVersion(), this.nativeSrcDependency.getType(), this.nativeSrcDependency.getClassifier());
            try {
                this.artifactResolver.resolveAlways(artifact, this.remoteArtifactRepositories, this.localRepository);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Error downloading.", (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("Requested download does not exist.", (Exception)((Object)e));
            }
            packageZipFile = artifact.getFile();
            if (packageZipFile.isDirectory()) {
                throw new MojoExecutionException("Add a '-Dnative-src-url=file:...' to have maven download the native package");
            }
        } else {
            try {
                packageZipFile = new File(this.buildDirectory, "native-build.zip");
                URL url = new URL(this.nativeSrcUrl.trim());
                InputStream is = url.openStream();
                try {
                    FileOutputStream os = new FileOutputStream(packageZipFile);
                    try {
                        IOUtil.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        IOUtil.close((InputStream)is);
                    }
                }
                finally {
                    IOUtil.close((InputStream)is);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error downloading: " + this.nativeSrcUrl, e);
            }
        }
        try {
            File dest = new File(this.buildDirectory, "native-build-extracted");
            this.getLog().info((CharSequence)("Extracting " + packageZipFile + " to " + dest));
            UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
            unArchiver.setSourceFile(packageZipFile);
            unArchiver.extract("", dest);
            File source = this.findSourceRoot(dest);
            if (source == null) {
                throw new MojoExecutionException("Extracted package did not look like it contained a native source build.");
            }
            FileUtils.copyDirectoryStructureIfModified((File)source, (File)buildDir);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Could not extract the native source package.", e);
        }
    }

    private File findSourceRoot(File dest) {
        if (dest.isDirectory()) {
            if (new File(dest, "configure").exists()) {
                return dest;
            }
            for (File file : dest.listFiles()) {
                File root = this.findSourceRoot(file);
                if (root == null) continue;
                return root;
            }
            return null;
        }
        return null;
    }
}

