/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.AsyncHistoryDateUtil;
import org.flowable.engine.impl.history.async.json.transformer.HistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public abstract class AbstractHistoryJsonTransformer
implements HistoryJsonTransformer {
    protected String getStringFromJson(ObjectNode objectNode, String fieldName) {
        if (objectNode.has(fieldName)) {
            return objectNode.get(fieldName).asText();
        }
        return null;
    }

    protected Date getDateFromJson(ObjectNode objectNode, String fieldName) {
        String s = this.getStringFromJson(objectNode, fieldName);
        return AsyncHistoryDateUtil.parseDate(s);
    }

    protected Integer getIntegerFromJson(ObjectNode objectNode, String fieldName) {
        String s = this.getStringFromJson(objectNode, fieldName);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Integer.valueOf(s);
        }
        return null;
    }

    protected Double getDoubleFromJson(ObjectNode objectNode, String fieldName) {
        String s = this.getStringFromJson(objectNode, fieldName);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Double.valueOf(s);
        }
        return null;
    }

    protected Long getLongFromJson(ObjectNode objectNode, String fieldName) {
        String s = this.getStringFromJson(objectNode, fieldName);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Long.valueOf(s);
        }
        return null;
    }

    protected Boolean getBooleanFromJson(ObjectNode objectNode, String fieldName, Boolean defaultValue) {
        Boolean value = this.getBooleanFromJson(objectNode, fieldName);
        return value != null ? value : defaultValue;
    }

    protected Boolean getBooleanFromJson(ObjectNode objectNode, String fieldName) {
        String s = this.getStringFromJson(objectNode, fieldName);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return Boolean.valueOf(s);
        }
        return null;
    }

    protected void dispatchEvent(CommandContext commandContext, FlowableEvent event) {
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(event);
        }
    }

    public boolean historicActivityInstanceExistsForData(ObjectNode historicalData, CommandContext commandContext) {
        String activityId;
        String executionId = this.getStringFromJson(historicalData, "executionId");
        if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)(activityId = this.getStringFromJson(historicalData, "activityId")))) {
            HistoricActivityInstanceEntity historicActivityInstanceEntity = this.findUnfinishedHistoricActivityInstance(commandContext, executionId, activityId);
            return historicActivityInstanceEntity != null;
        }
        return false;
    }

    public boolean historicActivityInstanceExistsForDataIncludingFinished(ObjectNode historicalData, CommandContext commandContext) {
        String activityId;
        String executionId = this.getStringFromJson(historicalData, "executionId");
        if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)(activityId = this.getStringFromJson(historicalData, "activityId")))) {
            HistoricActivityInstanceEntity historicActivityInstanceEntity = this.findHistoricActivityInstance(commandContext, executionId, activityId);
            return historicActivityInstanceEntity != null;
        }
        return false;
    }

    protected HistoricActivityInstanceEntity findUnfinishedHistoricActivityInstance(CommandContext commandContext, String executionId, String activityId) {
        List<HistoricActivityInstanceEntity> historicActivityInstances;
        if (executionId == null || activityId == null) {
            return null;
        }
        HistoricActivityInstanceEntity historicActivityInstanceEntity = this.getUnfinishedHistoricActivityInstanceFromCache(commandContext, executionId, activityId);
        if (historicActivityInstanceEntity == null && !(historicActivityInstances = CommandContextUtil.getHistoricActivityInstanceEntityManager(commandContext).findUnfinishedHistoricActivityInstancesByExecutionAndActivityId(executionId, activityId)).isEmpty()) {
            historicActivityInstanceEntity = historicActivityInstances.get(0);
        }
        return historicActivityInstanceEntity;
    }

    protected HistoricActivityInstanceEntity getUnfinishedHistoricActivityInstanceFromCache(CommandContext commandContext, String executionId, String activityId) {
        List cachedHistoricActivityInstances = CommandContextUtil.getEntityCache(commandContext).findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || cachedHistoricActivityInstance.getEndTime() != null || !executionId.equals(cachedHistoricActivityInstance.getExecutionId())) continue;
            return cachedHistoricActivityInstance;
        }
        return null;
    }

    protected HistoricActivityInstanceEntity findHistoricActivityInstance(CommandContext commandContext, String executionId, String activityId) {
        List<HistoricActivityInstanceEntity> historicActivityInstances;
        if (executionId == null || activityId == null) {
            return null;
        }
        HistoricActivityInstanceEntity historicActivityInstanceEntity = this.getHistoricActivityInstanceFromCache(commandContext, executionId, activityId);
        if (historicActivityInstanceEntity == null && !(historicActivityInstances = CommandContextUtil.getHistoricActivityInstanceEntityManager(commandContext).findHistoricActivityInstancesByExecutionAndActivityId(executionId, activityId)).isEmpty()) {
            historicActivityInstanceEntity = historicActivityInstances.get(0);
        }
        return historicActivityInstanceEntity;
    }

    protected HistoricActivityInstanceEntity getHistoricActivityInstanceFromCache(CommandContext commandContext, String executionId, String activityId) {
        List cachedHistoricActivityInstances = CommandContextUtil.getEntityCache(commandContext).findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || !executionId.equals(cachedHistoricActivityInstance.getExecutionId())) continue;
            return cachedHistoricActivityInstance;
        }
        return null;
    }
}

