/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Map;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cmd.NeedsActiveExecutionCmd;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;

public class TriggerCmd
extends NeedsActiveExecutionCmd<Object> {
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> processVariables;
    protected Map<String, Object> transientVariables;

    public TriggerCmd(String executionId, Map<String, Object> processVariables) {
        super(executionId);
        this.processVariables = processVariables;
    }

    public TriggerCmd(String executionId, Map<String, Object> processVariables, Map<String, Object> transientVariables) {
        this(executionId, processVariables);
        this.transientVariables = transientVariables;
    }

    @Override
    protected Object execute(CommandContext commandContext, ExecutionEntity execution) {
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.trigger(this.executionId, this.processVariables, this.transientVariables);
            return null;
        }
        if (this.processVariables != null) {
            execution.setVariables(this.processVariables);
        }
        if (this.transientVariables != null) {
            execution.setTransientVariables(this.transientVariables);
        }
        CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSignalEvent(FlowableEngineEventType.ACTIVITY_SIGNALED, execution.getCurrentActivityId(), null, null, execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId()));
        CommandContextUtil.getAgenda(commandContext).planTriggerExecutionOperation(execution);
        return null;
    }

    @Override
    protected String getSuspendedExceptionMessage() {
        return "Cannot trigger an execution that is suspended";
    }
}

