/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class SetTaskPriorityCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected int priority;

    public SetTaskPriorityCmd(String taskId, int priority) {
        super(taskId);
        this.priority = priority;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.setTaskPriority(this.taskId, this.priority);
            return null;
        }
        task.setPriority(this.priority);
        CommandContextUtil.getHistoryManager(commandContext).recordTaskInfoChange(task);
        CommandContextUtil.getTaskService().updateTask(task, true);
        return null;
    }
}

