/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.history.HistoryLevel;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.task.api.Task;
import org.flowable.task.service.event.impl.FlowableTaskEventBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class SaveTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;

    public SaveTaskCmd(Task task) {
        this.task = (TaskEntity)task;
    }

    public Void execute(CommandContext commandContext) {
        if (this.task == null) {
            throw new FlowableIllegalArgumentException("task is null");
        }
        if (this.task.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, this.task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.saveTask(this.task);
            return null;
        }
        if (this.task.getRevision() == 0) {
            TaskHelper.insertTask(this.task, null, true);
            if (CommandContextUtil.getEventDispatcher().isEnabled()) {
                CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TASK_CREATED, (Object)this.task));
            }
        } else {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            TaskEntity originalTaskEntity = CommandContextUtil.getTaskService().getTask(this.task.getId());
            if (originalTaskEntity == null && processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
                originalTaskEntity = CommandContextUtil.getHistoricTaskService().getHistoricTask(this.task.getId());
            }
            String originalAssignee = originalTaskEntity.getAssignee();
            CommandContextUtil.getHistoryManager(commandContext).recordTaskInfoChange(this.task);
            CommandContextUtil.getTaskService().updateTask(this.task, true);
            if (!StringUtils.equals((CharSequence)originalAssignee, (CharSequence)this.task.getAssignee())) {
                CommandContextUtil.getProcessEngineConfiguration(commandContext).getListenerNotificationHelper().executeTaskListeners(this.task, "assignment");
                if (CommandContextUtil.getEventDispatcher().isEnabled()) {
                    CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TASK_ASSIGNED, (Object)this.task));
                }
            }
        }
        return null;
    }
}

