/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionInfoEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionInfoEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;

public class SaveProcessDefinitionInfoCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected ObjectNode infoNode;

    public SaveProcessDefinitionInfoCmd(String processDefinitionId, ObjectNode infoNode) {
        this.processDefinitionId = processDefinitionId;
        this.infoNode = infoNode;
    }

    public Void execute(CommandContext commandContext) {
        if (this.processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("process definition id is null");
        }
        if (this.infoNode == null) {
            throw new FlowableIllegalArgumentException("process definition info node is null");
        }
        ProcessDefinitionInfoEntityManager definitionInfoEntityManager = CommandContextUtil.getProcessDefinitionInfoEntityManager(commandContext);
        ProcessDefinitionInfoEntity definitionInfoEntity = definitionInfoEntityManager.findProcessDefinitionInfoByProcessDefinitionId(this.processDefinitionId);
        if (definitionInfoEntity == null) {
            definitionInfoEntity = (ProcessDefinitionInfoEntity)definitionInfoEntityManager.create();
            definitionInfoEntity.setProcessDefinitionId(this.processDefinitionId);
            CommandContextUtil.getProcessDefinitionInfoEntityManager().insertProcessDefinitionInfo(definitionInfoEntity);
        }
        try {
            ObjectWriter writer = CommandContextUtil.getProcessEngineConfiguration(commandContext).getObjectMapper().writer();
            CommandContextUtil.getProcessDefinitionInfoEntityManager().updateInfoJson(definitionInfoEntity.getId(), writer.writeValueAsBytes((Object)this.infoNode));
        }
        catch (Exception e) {
            throw new FlowableException("Unable to serialize info node " + this.infoNode);
        }
        return null;
    }
}

