/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Collection;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cmd.NeedsActiveExecutionCmd;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.Flowable5Util;

public class RemoveExecutionVariablesCmd
extends NeedsActiveExecutionCmd<Void> {
    private static final long serialVersionUID = 1L;
    private Collection<String> variableNames;
    private boolean isLocal;

    public RemoveExecutionVariablesCmd(String executionId, Collection<String> variableNames, boolean isLocal) {
        super(executionId);
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    protected Void execute(CommandContext commandContext, ExecutionEntity execution) {
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.removeExecutionVariables(this.executionId, this.variableNames, this.isLocal);
            return null;
        }
        if (this.isLocal) {
            execution.removeVariablesLocal(this.variableNames);
        } else {
            execution.removeVariables(this.variableNames);
        }
        return null;
    }

    @Override
    protected String getSuspendedExceptionMessage() {
        return "Cannot remove variables because execution '" + this.executionId + "' is suspended";
    }
}

