/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.persistence.deploy.ProcessDefinitionInfoCacheObject;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.repository.ProcessDefinition;

public class GetProcessDefinitionInfoCmd
implements Command<ObjectNode>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetProcessDefinitionInfoCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ObjectNode execute(CommandContext commandContext) {
        if (this.processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("process definition id is null");
        }
        ObjectNode resultNode = null;
        DeploymentManager deploymentManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDeploymentManager();
        ProcessDefinition processDefinition = deploymentManager.findDeployedProcessDefinitionById(this.processDefinitionId);
        if (Flowable5Util.isFlowable5ProcessDefinition(processDefinition, commandContext)) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            return compatibilityHandler.getProcessDefinitionInfo(this.processDefinitionId);
        }
        ProcessDefinitionInfoCacheObject definitionInfoCacheObject = deploymentManager.getProcessDefinitionInfoCache().get(this.processDefinitionId);
        if (definitionInfoCacheObject != null) {
            resultNode = definitionInfoCacheObject.getInfoNode();
        }
        return resultNode;
    }
}

