/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.Deployment;

public class GetDeploymentResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String resourceName;

    public GetDeploymentResourceCmd(String deploymentId, String resourceName) {
        this.deploymentId = deploymentId;
        this.resourceName = resourceName;
    }

    public InputStream execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("deploymentId is null");
        }
        if (this.resourceName == null) {
            throw new FlowableIllegalArgumentException("resourceName is null");
        }
        ResourceEntity resource = CommandContextUtil.getResourceEntityManager().findResourceByDeploymentIdAndResourceName(this.deploymentId, this.resourceName);
        if (resource == null) {
            if (CommandContextUtil.getDeploymentEntityManager(commandContext).findById(this.deploymentId) == null) {
                throw new FlowableObjectNotFoundException("deployment does not exist: " + this.deploymentId, Deployment.class);
            }
            throw new FlowableObjectNotFoundException("no resource found with name '" + this.resourceName + "' in deployment '" + this.deploymentId + "'", InputStream.class);
        }
        return new ByteArrayInputStream(resource.getBytes());
    }
}

