/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cfg;

import java.util.Collections;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.flowable.engine.cfg.AbstractEngineConfigurator;
import org.flowable.engine.common.AbstractEngineConfiguration;
import org.flowable.engine.common.impl.db.CustomMyBatisTypeHandlerConfig;
import org.flowable.engine.common.impl.db.CustomMybatisTypeAliasConfig;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.deploy.Deployer;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.cfg.StandaloneIdmEngineConfiguration;
import org.flowable.idm.engine.impl.db.EntityDependencyOrder;
import org.flowable.idm.engine.impl.persistence.ByteArrayRefTypeHandler;
import org.flowable.idm.engine.impl.persistence.entity.ByteArrayRef;

public class IdmEngineConfigurator
extends AbstractEngineConfigurator {
    protected IdmEngineConfiguration idmEngineConfiguration;

    @Override
    public int getPriority() {
        return 100000;
    }

    @Override
    protected List<Deployer> getCustomDeployers() {
        return null;
    }

    @Override
    protected String getMybatisCfgPath() {
        return "org/flowable/idm/db/mapping/mappings.xml";
    }

    @Override
    protected List<CustomMybatisTypeAliasConfig> getMybatisTypeAliases() {
        return Collections.singletonList(new CustomMybatisTypeAliasConfig("IdmByteArrayRefTypeHandler", ByteArrayRefTypeHandler.class));
    }

    @Override
    protected List<CustomMyBatisTypeHandlerConfig> getMybatisTypeHandlers() {
        return Collections.singletonList(new CustomMyBatisTypeHandlerConfig(ByteArrayRef.class, JdbcType.VARCHAR, ByteArrayRefTypeHandler.class));
    }

    @Override
    public void configure(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (this.idmEngineConfiguration == null) {
            this.idmEngineConfiguration = new StandaloneIdmEngineConfiguration();
        }
        this.initialiseCommonProperties(processEngineConfiguration, (AbstractEngineConfiguration)this.idmEngineConfiguration);
        this.idmEngineConfiguration.buildIdmEngine();
        this.initServiceConfigurations(processEngineConfiguration, (AbstractEngineConfiguration)this.idmEngineConfiguration);
    }

    @Override
    protected List<Class<? extends Entity>> getEntityInsertionOrder() {
        return EntityDependencyOrder.INSERT_ORDER;
    }

    @Override
    protected List<Class<? extends Entity>> getEntityDeletionOrder() {
        return EntityDependencyOrder.DELETE_ORDER;
    }

    public IdmEngineConfiguration getIdmEngineConfiguration() {
        return this.idmEngineConfiguration;
    }

    public IdmEngineConfigurator setIdmEngineConfiguration(IdmEngineConfiguration idmEngineConfiguration) {
        this.idmEngineConfiguration = idmEngineConfiguration;
        return this;
    }
}

