/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.util.CollectionUtil;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;

public class SubProcessActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected boolean isOnlyNoneStartEventAllowed = true;

    @Override
    public void execute(DelegateExecution execution) {
        SubProcess subProcess = this.getSubProcessFromExecution(execution);
        FlowElement startElement = this.getStartElement(subProcess);
        if (startElement == null) {
            throw new FlowableException("No initial activity found for subprocess " + subProcess.getId());
        }
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        executionEntity.setScope(true);
        Map<String, Object> dataObjectVars = this.processDataObjects(subProcess.getDataObjects());
        if (dataObjectVars != null) {
            executionEntity.setVariablesLocal(dataObjectVars);
        }
        CommandContext commandContext = Context.getCommandContext();
        ProcessInstanceHelper processInstanceHelper = CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessInstanceHelper();
        processInstanceHelper.processAvailableEventSubProcesses(executionEntity, (FlowElementsContainer)subProcess, commandContext);
        ExecutionEntity startSubProcessExecution = CommandContextUtil.getExecutionEntityManager(commandContext).createChildExecution(executionEntity);
        startSubProcessExecution.setCurrentFlowElement(startElement);
        CommandContextUtil.getAgenda().planContinueProcessOperation(startSubProcessExecution);
    }

    protected FlowElement getStartElement(SubProcess subProcess) {
        if (CollectionUtil.isNotEmpty((Collection)subProcess.getFlowElements())) {
            for (FlowElement subElement : subProcess.getFlowElements()) {
                if (!(subElement instanceof StartEvent)) continue;
                StartEvent startEvent = (StartEvent)subElement;
                if (this.isOnlyNoneStartEventAllowed) {
                    if (!CollectionUtil.isEmpty((Collection)startEvent.getEventDefinitions())) continue;
                    return startEvent;
                }
                return startEvent;
            }
        }
        return null;
    }

    protected SubProcess getSubProcessFromExecution(DelegateExecution execution) {
        FlowElement flowElement = execution.getCurrentFlowElement();
        SubProcess subProcess = null;
        if (!(flowElement instanceof SubProcess)) {
            throw new FlowableException("Programmatic error: sub process behaviour can only be applied to a SubProcess instance, but got an instance of " + flowElement);
        }
        subProcess = (SubProcess)flowElement;
        return subProcess;
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }
}

