/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CollectionHandler;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.Process;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.flowable.engine.common.impl.util.CollectionUtil;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ClassDelegateCollectionHandler;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionCollectionHandler;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.FlowableCollectionHandler;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiInstanceActivityBehavior
extends FlowNodeActivityBehavior
implements SubProcessActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(MultiInstanceActivityBehavior.class);
    protected final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    protected final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected Activity activity;
    protected AbstractBpmnActivityBehavior innerActivityBehavior;
    protected Expression loopCardinalityExpression;
    protected String completionCondition;
    protected Expression collectionExpression;
    protected String collectionVariable;
    protected String collectionElementVariable;
    protected String collectionString;
    protected CollectionHandler collectionHandler;
    protected String collectionElementIndexVariable = "loopCounter";

    public MultiInstanceActivityBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.activity = activity;
        this.setInnerActivityBehavior(innerActivityBehavior);
    }

    @Override
    public void execute(DelegateExecution delegateExecution) {
        ExecutionEntity execution = (ExecutionEntity)delegateExecution;
        if (this.getLocalLoopVariable(execution, this.getCollectionElementIndexVariable()) == null) {
            int nrOfInstances = 0;
            try {
                nrOfInstances = this.createInstances(delegateExecution);
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, (DelegateExecution)execution);
            }
            if (nrOfInstances == 0) {
                this.cleanupMiRoot(execution);
            }
        } else {
            if (this.activity.isAsynchronous()) {
                CommandContextUtil.getHistoryManager().recordActivityStart(execution);
            }
            this.innerActivityBehavior.execute(execution);
        }
    }

    protected abstract int createInstances(DelegateExecution var1);

    @Override
    public void leave(DelegateExecution execution) {
        this.cleanupMiRoot(execution);
    }

    protected void cleanupMiRoot(DelegateExecution execution) {
        ExecutionEntity multiInstanceRootExecution = (ExecutionEntity)this.getMultiInstanceRootExecution(execution);
        FlowElement flowElement = multiInstanceRootExecution.getCurrentFlowElement();
        ExecutionEntity parentExecution = multiInstanceRootExecution.getParent();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        executionEntityManager.deleteChildExecutions(multiInstanceRootExecution, "MI_END", false);
        executionEntityManager.deleteRelatedDataForExecution(multiInstanceRootExecution, null);
        executionEntityManager.delete(multiInstanceRootExecution);
        ExecutionEntity newExecution = executionEntityManager.createChildExecution(parentExecution);
        newExecution.setCurrentFlowElement(flowElement);
        super.leave(newExecution);
    }

    protected void executeCompensationBoundaryEvents(FlowElement flowElement, DelegateExecution execution) {
        Collection<BoundaryEvent> boundaryEvents = this.findBoundaryEventsForFlowNode(execution.getProcessDefinitionId(), flowElement);
        if (CollectionUtil.isNotEmpty(boundaryEvents)) {
            for (BoundaryEvent boundaryEvent : boundaryEvents) {
                if (CollectionUtil.isEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                ExecutionEntity childExecutionEntity = CommandContextUtil.getExecutionEntityManager().createChildExecution((ExecutionEntity)execution);
                childExecutionEntity.setParentId(execution.getId());
                childExecutionEntity.setCurrentFlowElement((FlowElement)boundaryEvent);
                childExecutionEntity.setScope(false);
                ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
                boundaryEventBehavior.execute(childExecutionEntity);
            }
        }
    }

    protected Collection<BoundaryEvent> findBoundaryEventsForFlowNode(String processDefinitionId, FlowElement flowElement) {
        Process process = this.getProcessDefinition(processDefinitionId);
        ArrayList<BoundaryEvent> results = new ArrayList<BoundaryEvent>(1);
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (boundaryEvent.getAttachedToRefId() == null || !boundaryEvent.getAttachedToRefId().equals(flowElement.getId())) continue;
            results.add(boundaryEvent);
        }
        return results;
    }

    protected Process getProcessDefinition(String processDefinitionId) {
        return ProcessDefinitionUtil.getProcess(processDefinitionId);
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        this.innerActivityBehavior.trigger(execution, signalName, signalData);
    }

    public void lastExecutionEnded(DelegateExecution execution) {
        this.leave(execution);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
        this.leave(execution);
    }

    public boolean completionConditionSatisfied(DelegateExecution execution) {
        if (this.completionCondition != null) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
            ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
            String activeCompletionCondition = null;
            if (CommandContextUtil.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
                ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.activity.getId(), execution.getProcessDefinitionId());
                activeCompletionCondition = this.getActiveValue(this.completionCondition, "multiInstanceCompletionCondition", taskElementProperties);
            } else {
                activeCompletionCondition = this.completionCondition;
            }
            Object value = expressionManager.createExpression(activeCompletionCondition).getValue((VariableContainer)execution);
            if (!(value instanceof Boolean)) {
                throw new FlowableIllegalArgumentException("completionCondition '" + activeCompletionCondition + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    public Integer getLoopVariable(DelegateExecution execution, String variableName) {
        Object value = execution.getVariableLocal(variableName);
        for (DelegateExecution parent = execution.getParent(); value == null && parent != null; parent = parent.getParent()) {
            value = parent.getVariableLocal(variableName);
        }
        return (Integer)(value != null ? value : Integer.valueOf(0));
    }

    protected int resolveNrOfInstances(DelegateExecution execution) {
        if (this.loopCardinalityExpression != null) {
            return this.resolveLoopCardinality(execution);
        }
        if (this.usesCollection()) {
            Collection collection = this.resolveAndValidateCollection(execution);
            return collection.size();
        }
        throw new FlowableIllegalArgumentException("Couldn't resolve collection expression nor variable reference");
    }

    protected void executeOriginalBehavior(DelegateExecution execution, int loopCounter) {
        if (this.usesCollection() && this.collectionElementVariable != null) {
            Collection collection = this.resolveAndValidateCollection(execution);
            Object value = null;
            Iterator it = collection.iterator();
            for (int index = 0; index <= loopCounter; ++index) {
                value = it.next();
            }
            this.setLoopVariable(execution, this.collectionElementVariable, value);
        }
        execution.setCurrentFlowElement((FlowElement)this.activity);
        CommandContextUtil.getAgenda().planContinueMultiInstanceOperation((ExecutionEntity)execution, loopCounter);
    }

    protected Collection resolveAndValidateCollection(DelegateExecution execution) {
        Object obj = this.resolveCollection(execution);
        if (this.collectionHandler != null) {
            return this.createFlowableCollectionHandler(this.collectionHandler, execution).resolveCollection(obj, execution);
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof String) {
            Object collectionVariable = execution.getVariable((String)obj);
            if (collectionVariable instanceof Collection) {
                return (Collection)collectionVariable;
            }
            if (collectionVariable == null) {
                throw new FlowableIllegalArgumentException("Variable " + collectionVariable + " is not found");
            }
            throw new FlowableIllegalArgumentException("Variable " + collectionVariable + "' is not a Collection");
        }
        throw new FlowableIllegalArgumentException("Couldn't resolve collection expression, variable reference or string");
    }

    protected Object resolveCollection(DelegateExecution execution) {
        Object collection = null;
        if (this.collectionExpression != null) {
            collection = this.collectionExpression.getValue((VariableContainer)execution);
        } else if (this.collectionVariable != null) {
            collection = execution.getVariable(this.collectionVariable);
        } else if (this.collectionString != null) {
            collection = this.collectionString;
        }
        return collection;
    }

    protected boolean usesCollection() {
        return this.collectionExpression != null || this.collectionVariable != null || this.collectionString != null;
    }

    protected boolean isExtraScopeNeeded(FlowNode flowNode) {
        return flowNode.getSubProcess() != null;
    }

    protected int resolveLoopCardinality(DelegateExecution execution) {
        Object value = this.loopCardinalityExpression.getValue((VariableContainer)execution);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new FlowableIllegalArgumentException("Could not resolve loopCardinality expression '" + this.loopCardinalityExpression.getExpressionText() + "': not a number nor number String");
    }

    protected void setLoopVariable(DelegateExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected Integer getLocalLoopVariable(DelegateExecution execution, String variableName) {
        return (Integer)execution.getVariableLocal(variableName);
    }

    protected void callActivityEndListeners(DelegateExecution execution) {
        CommandContextUtil.getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners((HasExecutionListeners)this.activity, execution, "end");
    }

    protected void logLoopDetails(DelegateExecution execution, String custom, int loopCounter, int nrOfCompletedInstances, int nrOfActiveInstances, int nrOfInstances) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Multi-instance '{}' {}. Details: loopCounter={}, nrOrCompletedInstances={},nrOfActiveInstances={},nrOfInstances={}", new Object[]{execution.getCurrentFlowElement() != null ? execution.getCurrentFlowElement().getId() : "", custom, loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances});
        }
    }

    protected DelegateExecution getMultiInstanceRootExecution(DelegateExecution executionEntity) {
        DelegateExecution multiInstanceRootExecution = null;
        DelegateExecution currentExecution = executionEntity;
        while (currentExecution != null && multiInstanceRootExecution == null && currentExecution.getParent() != null) {
            if (currentExecution.isMultiInstanceRoot()) {
                multiInstanceRootExecution = currentExecution;
                continue;
            }
            currentExecution = currentExecution.getParent();
        }
        return multiInstanceRootExecution;
    }

    protected String getActiveValue(String originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }

    protected FlowableCollectionHandler createFlowableCollectionHandler(CollectionHandler handler, DelegateExecution execution) {
        FlowableCollectionHandler collectionHandler = null;
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(handler.getImplementationType())) {
            collectionHandler = new ClassDelegateCollectionHandler(handler.getImplementation(), null);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(handler.getImplementationType())) {
            Object delegate = DelegateExpressionUtil.resolveDelegateExpression(CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(handler.getImplementation()), execution);
            if (delegate instanceof FlowableCollectionHandler) {
                collectionHandler = new DelegateExpressionCollectionHandler(execution, CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(handler.getImplementation()));
            } else {
                throw new FlowableIllegalArgumentException("Delegate expression " + handler.getImplementation() + " did not resolve to an implementation of " + FlowableCollectionHandler.class);
            }
        }
        return collectionHandler;
    }

    public Expression getLoopCardinalityExpression() {
        return this.loopCardinalityExpression;
    }

    public void setLoopCardinalityExpression(Expression loopCardinalityExpression) {
        this.loopCardinalityExpression = loopCardinalityExpression;
    }

    public String getCompletionCondition() {
        return this.completionCondition;
    }

    public void setCompletionCondition(String completionCondition) {
        this.completionCondition = completionCondition;
    }

    public Expression getCollectionExpression() {
        return this.collectionExpression;
    }

    public void setCollectionExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    public String getCollectionVariable() {
        return this.collectionVariable;
    }

    public void setCollectionVariable(String collectionVariable) {
        this.collectionVariable = collectionVariable;
    }

    public String getCollectionElementVariable() {
        return this.collectionElementVariable;
    }

    public void setCollectionElementVariable(String collectionElementVariable) {
        this.collectionElementVariable = collectionElementVariable;
    }

    public String getCollectionString() {
        return this.collectionString;
    }

    public void setCollectionString(String collectionString) {
        this.collectionString = collectionString;
    }

    public CollectionHandler getHandler() {
        return this.collectionHandler;
    }

    public void setHandler(CollectionHandler collectionHandler) {
        this.collectionHandler = collectionHandler;
    }

    public String getCollectionElementIndexVariable() {
        return this.collectionElementIndexVariable;
    }

    public void setCollectionElementIndexVariable(String collectionElementIndexVariable) {
        this.collectionElementIndexVariable = collectionElementIndexVariable;
    }

    public void setInnerActivityBehavior(AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.innerActivityBehavior = innerActivityBehavior;
        this.innerActivityBehavior.setMultiInstanceActivityBehavior(this);
    }

    public AbstractBpmnActivityBehavior getInnerActivityBehavior() {
        return this.innerActivityBehavior;
    }
}

