/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.flowable.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public class BoundaryCompensateEventActivityBehavior
extends BoundaryEventActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected CompensateEventDefinition compensateEventDefinition;

    public BoundaryCompensateEventActivityBehavior(CompensateEventDefinition compensateEventDefinition, boolean interrupting) {
        super(interrupting);
        this.compensateEventDefinition = compensateEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
        Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId());
        if (process == null) {
            throw new FlowableException("Process model (id = " + execution.getId() + ") could not be found");
        }
        Activity compensationActivity = null;
        List associations = process.findAssociationsWithSourceRefRecursive(boundaryEvent.getId());
        for (Association association : associations) {
            Activity activity;
            FlowElement targetElement = process.getFlowElement(association.getTargetRef(), true);
            if (!(targetElement instanceof Activity) || !(activity = (Activity)targetElement).isForCompensation()) continue;
            compensationActivity = activity;
            break;
        }
        if (compensationActivity == null) {
            throw new FlowableException("Compensation activity could not be found (or it is missing 'isForCompensation=\"true\"'");
        }
        ExecutionEntity scopeExecution = null;
        ExecutionEntity parentExecution = executionEntity.getParent();
        while (scopeExecution == null && parentExecution != null) {
            if (parentExecution.getCurrentFlowElement() instanceof SubProcess) {
                scopeExecution = parentExecution;
                continue;
            }
            if (parentExecution.isProcessInstanceType()) {
                scopeExecution = parentExecution;
                continue;
            }
            parentExecution = parentExecution.getParent();
        }
        if (scopeExecution == null) {
            throw new FlowableException("Could not find a scope execution for compensation boundary event " + boundaryEvent.getId());
        }
        CommandContextUtil.getEventSubscriptionEntityManager().insertCompensationEvent(scopeExecution, compensationActivity.getId());
    }

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
        if (boundaryEvent.isCancelActivity()) {
            EventSubscriptionEntityManager eventSubscriptionEntityManager = CommandContextUtil.getEventSubscriptionEntityManager();
            List<EventSubscriptionEntity> eventSubscriptions = executionEntity.getEventSubscriptions();
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                if (!(eventSubscription instanceof CompensateEventSubscriptionEntity) || !eventSubscription.getActivityId().equals(this.compensateEventDefinition.getActivityRef())) continue;
                eventSubscriptionEntityManager.delete(eventSubscription);
            }
        }
        super.trigger(executionEntity, triggerName, triggerData);
    }
}

