/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;

public class DestroyScopeOperation
extends AbstractOperation {
    public DestroyScopeOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    @Override
    public void run() {
        ExecutionEntity scopeExecution;
        ExecutionEntity executionEntity = scopeExecution = this.execution.isScope() ? this.execution : this.findFirstParentScopeExecution(this.execution);
        if (scopeExecution == null) {
            throw new FlowableException("Programmatic error: no parent scope execution found for boundary event");
        }
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(this.commandContext);
        executionEntityManager.deleteChildExecutions(scopeExecution, this.execution.getDeleteReason(), true);
        executionEntityManager.deleteExecutionAndRelatedData(scopeExecution, this.execution.getDeleteReason(), true, null);
        if (scopeExecution.isActive()) {
            CommandContextUtil.getHistoryManager(this.commandContext).recordActivityEnd(scopeExecution, scopeExecution.getDeleteReason());
        }
        executionEntityManager.delete(scopeExecution);
    }
}

