/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.common.impl.agenda.AbstractAgenda;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.agenda.ContinueMultiInstanceOperation;
import org.flowable.engine.impl.agenda.ContinueProcessOperation;
import org.flowable.engine.impl.agenda.DestroyScopeOperation;
import org.flowable.engine.impl.agenda.EndExecutionOperation;
import org.flowable.engine.impl.agenda.ExecuteInactiveBehaviorsOperation;
import org.flowable.engine.impl.agenda.TakeOutgoingSequenceFlowsOperation;
import org.flowable.engine.impl.agenda.TriggerExecutionOperation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlowableEngineAgenda
extends AbstractAgenda
implements FlowableEngineAgenda {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFlowableEngineAgenda.class);

    public DefaultFlowableEngineAgenda(CommandContext commandContext) {
        super(commandContext);
    }

    @Override
    public void planOperation(Runnable operation, ExecutionEntity executionEntity) {
        this.operations.add(operation);
        LOGGER.debug("Operation {} added to agenda", operation.getClass());
        if (executionEntity != null) {
            CommandContextUtil.addInvolvedExecution(this.commandContext, executionEntity);
        }
    }

    @Override
    public void planContinueProcessOperation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution), execution);
    }

    @Override
    public void planContinueProcessSynchronousOperation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution, true, false), execution);
    }

    @Override
    public void planContinueProcessInCompensation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution, false, true), execution);
    }

    @Override
    public void planContinueMultiInstanceOperation(ExecutionEntity execution, int loopCounter) {
        this.planOperation(new ContinueMultiInstanceOperation(this.commandContext, execution, loopCounter), execution);
    }

    @Override
    public void planTakeOutgoingSequenceFlowsOperation(ExecutionEntity execution, boolean evaluateConditions) {
        this.planOperation(new TakeOutgoingSequenceFlowsOperation(this.commandContext, execution, evaluateConditions), execution);
    }

    @Override
    public void planEndExecutionOperation(ExecutionEntity execution) {
        this.planOperation(new EndExecutionOperation(this.commandContext, execution), execution);
    }

    @Override
    public void planTriggerExecutionOperation(ExecutionEntity execution) {
        this.planOperation(new TriggerExecutionOperation(this.commandContext, execution), execution);
    }

    @Override
    public void planDestroyScopeOperation(ExecutionEntity execution) {
        this.planOperation(new DestroyScopeOperation(this.commandContext, execution), execution);
    }

    @Override
    public void planExecuteInactiveBehaviorsOperation() {
        this.planOperation(new ExecuteInactiveBehaviorsOperation(this.commandContext));
    }
}

