/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.flowable.cmmn.converter.export.FieldExport;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.model.FlowableListener;
import org.flowable.cmmn.model.ImplementationType;

public class FlowableListenerExport {
    public static boolean writeFlowableListeners(XMLStreamWriter xtw, String xmlElementName, List<FlowableListener> listeners, boolean didWriteExtensionStartElement) throws Exception {
        if (listeners != null) {
            for (FlowableListener listener : listeners) {
                if (!didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("flowable", xmlElementName, "http://flowable.org/cmmn");
                CmmnXmlUtil.writeDefaultAttribute("event", listener.getEvent(), xtw);
                CmmnXmlUtil.writeDefaultAttribute("sourceState", listener.getSourceState(), xtw);
                CmmnXmlUtil.writeDefaultAttribute("targetState", listener.getTargetState(), xtw);
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(listener.getImplementationType())) {
                    CmmnXmlUtil.writeDefaultAttribute("class", listener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(listener.getImplementationType())) {
                    CmmnXmlUtil.writeDefaultAttribute("expression", listener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(listener.getImplementationType())) {
                    CmmnXmlUtil.writeDefaultAttribute("delegateExpression", listener.getImplementation(), xtw);
                }
                CmmnXmlUtil.writeDefaultAttribute("onTransaction", listener.getOnTransaction(), xtw);
                FieldExport.writeFieldExtensions(listener.getFieldExtensions(), true, xtw);
                xtw.writeEndElement();
            }
        }
        return didWriteExtensionStartElement;
    }
}

