/*
 * Decompiled with CFR 0.152.
 */
package kilim.tools;

import kilim.WeavingClassLoader;

public class Kilim {
    private static Object dummy = new Object();

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Kilim.usage();
        }
        String className = args[0];
        args = Kilim.processArgs(args);
        Kilim.run(className, "main", args);
    }

    public static void run(String className, String method, String ... args) throws Exception {
        new WeavingClassLoader().run(className, method, args);
    }

    public static boolean trampoline(boolean check, String ... args) {
        return Kilim.trampoline(dummy, check, args);
    }

    public static boolean trampoline(Object example, boolean check, String ... args) {
        ClassLoader cl = Kilim.class.getClassLoader();
        if (cl.getClass().getName().equals(WeavingClassLoader.class.getName())) {
            return false;
        }
        int offset = example == dummy ? 2 : 1;
        StackTraceElement ste = new Exception().getStackTrace()[offset];
        boolean simple = example == null | example == dummy;
        try {
            Class<?> klass;
            if (check) {
                try {
                    klass = cl.loadClass(ste.getClassName());
                    if (Kilim.isWoven(klass)) {
                        return false;
                    }
                }
                catch (ClassNotFoundException klass2) {
                    // empty catch block
                }
            }
            klass = simple ? null : (example instanceof Class ? (Class<?>)example : example.getClass());
            ClassLoader ecl = simple ? null : klass.getClassLoader();
            new WeavingClassLoader(ecl, null).run(ste.getClassName(), ste.getMethodName(), args);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    public static boolean isWoven(Class klass) {
        try {
            klass.getField("$isWoven");
            return true;
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
    }

    private static void usage() {
        System.out.println("java [-Dkilim.class.path=...] kilim.tools.Kilim class [args ...]");
        System.exit(1);
    }

    private static String[] processArgs(String[] args) {
        String[] ret = new String[args.length - 1];
        if (ret.length > 0) {
            System.arraycopy(args, 1, ret, 0, ret.length);
        }
        return ret;
    }
}

