/*
 * Decompiled with CFR 0.152.
 */
package kilim.timerservice;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kilim.AffineThreadPool;
import kilim.Event;
import kilim.EventPublisher;
import kilim.EventSubscriber;
import kilim.Scheduler;
import kilim.concurrent.MPSCQueue;
import kilim.timerservice.Timer;
import kilim.timerservice.TimerPriorityHeap;

public class TimerService {
    private final MPSCQueue<Timer> timerQueue;
    private final TimerPriorityHeap timerHeap;
    private ScheduledExecutorService timerProxy;
    private final Lock lock;
    private static boolean debugStats = false;
    private volatile WatchdogTask argos = new WatchdogTask(0L);
    private static volatile int c1;
    private static volatile int c2;
    private static volatile int c3;
    public ThreadPoolExecutor defaultExec;

    public TimerService() {
        this.argos.done = true;
        this.timerHeap = new TimerPriorityHeap();
        this.timerQueue = new MPSCQueue(Integer.getInteger("kilim.maxpendingtimers", 100000));
        this.timerProxy = Executors.newSingleThreadScheduledExecutor();
        this.lock = new ReentrantLock();
    }

    public void shutdown() {
        this.timerProxy.shutdown();
        if (debugStats) {
            System.out.format("timerservice: %d %d %d\n", c1, c2, c3);
        }
    }

    public void submit(Timer t) {
        if (t.onQueue.compareAndSet(false, true)) {
            while (!this.timerQueue.offer(t)) {
                this.trigger(this.defaultExec);
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }

    private boolean empty() {
        return this.timerHeap.isEmpty() && this.timerQueue.isEmpty();
    }

    public boolean isEmptyLazy(ThreadPoolExecutor executor) {
        return this.empty() && new Empty().check(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(ThreadPoolExecutor executor) {
        int maxtry = 5;
        long clock = System.currentTimeMillis();
        long sched = 0L;
        int retry = -1;
        while ((retry < 0 || !this.timerQueue.isEmpty() || sched > 0L && sched <= clock) && ++retry < maxtry && this.lock.tryLock()) {
            try {
                sched = this.doTrigger(clock);
            }
            finally {
                this.lock.unlock();
            }
            clock = System.currentTimeMillis();
        }
        if (!Scheduler.getDefaultScheduler().isEmptyish()) {
            return;
        }
        WatchdogTask dragon = this.argos;
        if (retry == maxtry) {
            this.argos = new WatchdogTask(0L);
            AffineThreadPool.publish(executor, this.argos);
            ++c1;
        } else if (sched > 0L & (dragon.done | sched < dragon.time)) {
            Watcher watcher = new Watcher(executor, sched);
            this.argos = watcher.dog;
            this.timerProxy.schedule(watcher, sched - clock, TimeUnit.MILLISECONDS);
            ++c2;
        }
    }

    private long doTrigger(long currentTime) {
        long executionTime;
        Timer t;
        Timer t2;
        Timer[] buf = new Timer[100];
        while ((t2 = this.timerHeap.peek()) != null && t2.getExecutionTime() == -1L) {
            t2.onHeap = false;
            this.timerHeap.poll();
        }
        int i = 0;
        this.timerQueue.fill((Timer[])buf);
        do {
            for (i = 0; i < buf.length && (t = buf[i]) != null; ++i) {
                t.onQueue.set(false);
                executionTime = t.getExecutionTime();
                if (executionTime < 0L) {
                    t = null;
                } else if (executionTime > 0L && executionTime <= currentTime) {
                    t.es.onEvent(null, Timer.timedOut);
                } else if (!t.onHeap) {
                    this.timerHeap.add(t);
                    t.onHeap = true;
                } else {
                    this.timerHeap.reschedule(t.index);
                }
                buf[i] = null;
            }
        } while (i == 100);
        while (!this.timerHeap.isEmpty()) {
            t = this.timerHeap.peek();
            executionTime = t.getExecutionTime();
            if (executionTime > currentTime) {
                return executionTime;
            }
            t.onHeap = false;
            this.timerHeap.poll();
            if (executionTime < 0L) continue;
            t.es.onEvent(null, Timer.timedOut);
        }
        return 0L;
    }

    static class WatchdogTask
    implements Runnable {
        volatile boolean done;
        final long time;

        public WatchdogTask(long $time) {
            this.time = $time;
        }

        @Override
        public void run() {
            this.done = true;
            c3++;
        }
    }

    private class Watcher
    implements Runnable {
        ThreadPoolExecutor executor;
        WatchdogTask dog;

        Watcher(ThreadPoolExecutor $executor, long time) {
            this.executor = $executor;
            this.dog = new WatchdogTask(time);
        }

        @Override
        public void run() {
            if (!this.launch()) {
                this.dog.done = true;
                this.launch();
            }
        }

        private boolean launch() {
            WatchdogTask hund = TimerService.this.argos;
            if (this.dog.time <= hund.time | hund.done && Scheduler.getDefaultScheduler().isEmptyish()) {
                AffineThreadPool.publish(this.executor, this.dog);
                return true;
            }
            return false;
        }
    }

    private class Empty
    implements EventSubscriber {
        boolean empty;
        boolean done;
        ThreadPoolExecutor executor;

        private Empty() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(EventPublisher ep, Event e) {
            this.empty = AffineThreadPool.isEmptyProxy(this.executor) && TimerService.this.empty();
            this.done = true;
            Empty empty = this;
            synchronized (empty) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean check(ThreadPoolExecutor executor) {
            this.executor = executor;
            if (!TimerService.this.timerQueue.offer(new Timer(this))) {
                return false;
            }
            TimerService.this.trigger(executor);
            Empty empty = this;
            synchronized (empty) {
                try {
                    if (!this.done) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.empty;
        }
    }
}

