/*
 * Decompiled with CFR 0.152.
 */
package kilim.timerservice;

import java.util.Arrays;
import kilim.timerservice.Timer;

public class TimerPriorityHeap {
    private Timer[] queue;
    private int size = 0;

    public TimerPriorityHeap() {
        this(128);
    }

    public TimerPriorityHeap(int size) {
        this.queue = new Timer[size];
    }

    public int size() {
        return this.size;
    }

    public Timer peek() {
        return this.queue[1];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(Timer task) {
        if (this.size + 1 == this.queue.length) {
            this.queue = Arrays.copyOf(this.queue, 2 * this.queue.length);
        }
        this.queue[++this.size] = task;
        this.heapifyUp(this.size);
    }

    public void reschedule(int i) {
        this.heapifyUp(i);
        this.heapifyDown(i);
    }

    private void heapifyUp(int k) {
        int j;
        while (k > 1 && this.queue[j = k >> 1].getExecutionTime() > this.queue[k].getExecutionTime()) {
            Timer tmp = this.queue[j];
            this.queue[j] = this.queue[k];
            this.queue[j].index = j;
            this.queue[k] = tmp;
            this.queue[k].index = k;
            k = j;
        }
    }

    private void heapifyDown(int k) {
        int j;
        while ((j = k << 1) <= this.size && j > 0) {
            if (j < this.size && this.queue[j].getExecutionTime() > this.queue[j + 1].getExecutionTime()) {
                ++j;
            }
            if (this.queue[k].getExecutionTime() <= this.queue[j].getExecutionTime()) break;
            Timer tmp = this.queue[j];
            this.queue[j] = this.queue[k];
            this.queue[j].index = j;
            this.queue[k] = tmp;
            this.queue[k].index = k;
            k = j;
        }
    }

    public void poll() {
        this.queue[1] = this.queue[this.size];
        this.queue[1].index = 1;
        this.queue[this.size--] = null;
        this.heapifyDown(1);
    }
}

