/*
 * Decompiled with CFR 0.152.
 */
package kilim.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import kilim.Fiber;
import kilim.Mailbox;
import kilim.Pausable;
import kilim.Scheduler;
import kilim.Task;
import kilim.nio.EndPoint;
import kilim.nio.SessionTask;
import kilim.nio.SockEvent;

public class NioSelectorScheduler {
    public static int LISTEN_BACKLOG = 1000;
    private Selector sel;
    private SelectorThread selectorThread;
    final Mailbox<SockEvent> regbox = new Mailbox(1000);
    AtomicBoolean update = new AtomicBoolean();
    private final Task regtask;
    volatile boolean running = true;

    public NioSelectorScheduler() throws IOException {
        this.sel = Selector.open();
        this.selectorThread = new SelectorThread();
        this.selectorThread.start();
        this.regtask = new RegistrationTask();
        this.regtask.start();
    }

    public int listen(int port, SessionFactory factory, Scheduler sockTaskScheduler) throws IOException {
        ListenTask t = new ListenTask(port);
        t.factory = factory;
        return this.listen(t, sockTaskScheduler);
    }

    public int listen(int port, Class<? extends SessionTask> sockTaskClass, Scheduler sockTaskScheduler) throws IOException {
        ListenTask t = new ListenTask(port);
        t.sessionClass = sockTaskClass;
        return this.listen(t, sockTaskScheduler);
    }

    private int listen(ListenTask t, Scheduler sockTaskScheduler) {
        t.setScheduler(sockTaskScheduler);
        t.start();
        return t.port;
    }

    public void shutdown() {
        this.running = false;
        this.sel.wakeup();
    }

    public class RegistrationTask
    extends Task {
        public static final boolean $isWoven = true;

        private RegistrationTask() {
        }

        public void wake() {
            NioSelectorScheduler.this.update.set(true);
            if (Thread.currentThread() != NioSelectorScheduler.this.selectorThread) {
                NioSelectorScheduler.this.sel.wakeup();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void execute(Fiber var1_1) throws Pausable, Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[SWITCH], 3[CASE]], but top level block is 8[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void execute() throws Pausable, Exception {
            Task.errNotWoven();
        }
    }

    class ListenTask
    extends SessionTask {
        Class<? extends SessionTask> sessionClass;
        SessionFactory factory;
        ServerSocketChannel ssc;
        int port;
        public static final boolean $isWoven = true;

        ListenTask(int port) throws IOException {
            this.port = port;
            this.ssc = ServerSocketChannel.open();
            this.ssc.socket().setReuseAddress(true);
            this.ssc.socket().bind(new InetSocketAddress(port), LISTEN_BACKLOG);
            this.ssc.configureBlocking(false);
            this.endpoint = new EndPoint(NioSelectorScheduler.this, this.ssc);
            if (port == 0) {
                this.port = this.ssc.socket().getLocalPort();
            }
        }

        @Override
        public String toString() {
            return "ListenTask: " + this.port;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void execute(Fiber var1_1) throws Pausable, Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CASE], 0[SWITCH]], but top level block is 9[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void execute() throws Pausable, Exception {
            Task.errNotWoven();
        }
    }

    public static interface SessionFactory {
        public SessionTask get() throws Exception;
    }

    class SelectorThread
    extends Thread {
        public SelectorThread() {
            super("KilimSelector:" + Thread.currentThread().getId());
        }

        @Override
        public void run() {
            while (true) {
                int n;
                Object o;
                try {
                    if (!NioSelectorScheduler.this.running) {
                        for (SelectionKey sk : NioSelectorScheduler.this.sel.keys()) {
                            sk.cancel();
                            o = sk.attachment();
                            if (!(o instanceof SockEvent) || !(((SockEvent)o).ch instanceof ServerSocketChannel)) continue;
                            try {
                                ((ServerSocketChannel)((SockEvent)o).ch).close();
                            }
                            catch (IOException iOException) {}
                        }
                        break;
                    }
                    n = NioSelectorScheduler.this.update.get() ? NioSelectorScheduler.this.sel.selectNow() : NioSelectorScheduler.this.sel.select();
                }
                catch (IOException ignore) {
                    n = 0;
                    ignore.printStackTrace();
                }
                if (n > 0) {
                    Iterator<SelectionKey> it = NioSelectorScheduler.this.sel.selectedKeys().iterator();
                    while (it.hasNext()) {
                        SelectionKey sk;
                        sk = it.next();
                        it.remove();
                        o = sk.attachment();
                        sk.interestOps(0);
                        assert (o instanceof SockEvent);
                        SockEvent ev = (SockEvent)o;
                        ev.replyTo.putnb(ev);
                    }
                }
                if (!NioSelectorScheduler.this.update.getAndSet(false)) continue;
                NioSelectorScheduler.this.regtask.run();
            }
        }
    }
}

