/*
 * Decompiled with CFR 0.152.
 */
package kilim.mirrors;

import java.util.ArrayList;
import kilim.NotPausable;
import kilim.Pausable;
import kilim.analysis.AsmDetector;
import kilim.mirrors.CachedClassMirrors;
import kilim.mirrors.ClassMirrorNotFoundException;

public class Detector {
    public static final int METHOD_NOT_FOUND_OR_PAUSABLE = 0;
    public static final int PAUSABLE_METHOD_FOUND = 1;
    public static final int METHOD_NOT_PAUSABLE = 2;
    static final String[] STANDARD_DONT_CHECK_LIST = new String[]{"java.", "javax."};
    public final CachedClassMirrors mirrors;
    CachedClassMirrors.ClassMirror NOT_PAUSABLE;
    CachedClassMirrors.ClassMirror PAUSABLE;
    CachedClassMirrors.ClassMirror OBJECT;
    private static final ArrayList<String> EMPTY_STRINGS = new ArrayList(0);
    static String JAVA_LANG_OBJECT = "java.lang.Object";

    public Detector(CachedClassMirrors mirrors) {
        this.mirrors = mirrors;
        this.NOT_PAUSABLE = mirrors.mirror(NotPausable.class);
        this.PAUSABLE = mirrors.mirror(Pausable.class);
        this.OBJECT = mirrors.mirror(Object.class);
    }

    public boolean isPausable(String className, String methodName, String desc) {
        return this.getPausableStatus(className, methodName, desc) == 1;
    }

    static boolean isNonPausableClass(String className) {
        return className == null || className.charAt(0) == '[' || className.startsWith("java.") || className.startsWith("javax.");
    }

    static boolean isNonPausableMethod(String methodName) {
        return methodName.endsWith("init>");
    }

    public int getPausableStatus(String className, String methodName, String desc) {
        int ret = 0;
        if (Detector.isNonPausableClass(className) || Detector.isNonPausableMethod(methodName)) {
            return 0;
        }
        className = className.replace('/', '.');
        try {
            CachedClassMirrors.MethodMirror m = this.findPausableMethod(className, methodName, desc);
            if (m != null) {
                for (String ex : m.getExceptionTypes()) {
                    if (Detector.isNonPausableClass(ex)) continue;
                    CachedClassMirrors.ClassMirror c = this.classForName(ex);
                    if (this.NOT_PAUSABLE.isAssignableFrom(c)) {
                        return 2;
                    }
                    if (!this.PAUSABLE.isAssignableFrom(c)) continue;
                    return 1;
                }
                return 2;
            }
        }
        catch (ClassMirrorNotFoundException m) {
        }
        catch (VerifyError ve) {
            return AsmDetector.getPausableStatus(className, methodName, desc, this);
        }
        return ret;
    }

    public CachedClassMirrors.ClassMirror classForName(String className) throws ClassMirrorNotFoundException {
        className = className.replace('/', '.');
        return this.mirrors.classForName(className);
    }

    public CachedClassMirrors.ClassMirror[] classForNames(String[] classNames) throws ClassMirrorNotFoundException {
        if (classNames == null) {
            return new CachedClassMirrors.ClassMirror[0];
        }
        CachedClassMirrors.ClassMirror[] ret = new CachedClassMirrors.ClassMirror[classNames.length];
        int i = 0;
        for (String cn : classNames) {
            ret[i++] = this.classForName(cn);
        }
        return ret;
    }

    private CachedClassMirrors.MethodMirror findPausableMethod(String className, String methodName, String desc) throws ClassMirrorNotFoundException {
        if (Detector.isNonPausableClass(className) || Detector.isNonPausableMethod(methodName)) {
            return null;
        }
        CachedClassMirrors.ClassMirror cl = this.classForName(className);
        if (cl == null) {
            return null;
        }
        for (CachedClassMirrors.MethodMirror om : cl.getDeclaredMethods()) {
            String omDesc;
            if (!om.getName().equals(methodName) || !(omDesc = om.getMethodDescriptor()).substring(0, omDesc.indexOf(")")).equals(desc.substring(0, desc.indexOf(")"))) || om.isBridge()) continue;
            return om;
        }
        if (this.OBJECT.equals(cl)) {
            return null;
        }
        CachedClassMirrors.MethodMirror m = this.findPausableMethod(cl.getSuperclass(), methodName, desc);
        if (m != null) {
            return m;
        }
        for (String ifname : cl.getInterfaces()) {
            if (Detector.isNonPausableClass(ifname) || (m = this.findPausableMethod(ifname, methodName, desc)) == null) continue;
            return m;
        }
        return null;
    }

    private static String statusToStr(int st) {
        switch (st) {
            case 0: {
                return "not found or pausable";
            }
            case 1: {
                return "pausable";
            }
            case 2: {
                return "not pausable";
            }
        }
        throw new AssertionError((Object)"Unknown status");
    }

    public String commonSuperType(String oa, String ob) throws ClassMirrorNotFoundException {
        String a = Detector.toClassName(oa);
        String b = Detector.toClassName(ob);
        try {
            CachedClassMirrors.ClassMirror ca = this.classForName(a);
            CachedClassMirrors.ClassMirror cb = this.classForName(b);
            if (ca.isAssignableFrom(cb)) {
                return oa;
            }
            if (cb.isAssignableFrom(ca)) {
                return ob;
            }
            if (ca.isInterface() && cb.isInterface()) {
                return "java/lang/Object";
            }
        }
        catch (ClassMirrorNotFoundException ca) {
            // empty catch block
        }
        if (a.equals(b)) {
            return oa;
        }
        ArrayList<String> sca = this.getSuperClasses(a);
        ArrayList<String> scb = this.getSuperClasses(b);
        int lasta = sca.size() - 1;
        int lastb = scb.size() - 1;
        while (sca.get(lasta).equals(scb.get(lastb)) && --lasta >= 0 && --lastb >= 0) {
        }
        if (sca.size() == lasta + 1) {
            return "java/lang/Object";
        }
        return sca.get(lasta + 1).replace('.', '/');
    }

    public ArrayList<String> getSuperClasses(String name) throws ClassMirrorNotFoundException {
        if (name == null) {
            return EMPTY_STRINGS;
        }
        ArrayList<String> ret = new ArrayList<String>(3);
        while (name != null) {
            ret.add(name);
            CachedClassMirrors.ClassMirror c = this.classForName(name);
            name = c.getSuperclass();
        }
        return ret;
    }

    private static String toDesc(String name) {
        return name.equals(JAVA_LANG_OBJECT) ? "Ljava/lang/Object;" : "L" + name.replace('.', '/') + ';';
    }

    private static String toClassName(String s) {
        if (s.endsWith(";")) {
            return s.replace('/', '.').substring(1, s.length() - 1);
        }
        return s.replace('/', '.');
    }
}

