/*
 * Decompiled with CFR 0.152.
 */
package kilim.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import kilim.http.HttpRequest;

public class HttpRequestParser {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte[] _http_parser_actions = HttpRequestParser.init__http_parser_actions_0();
    private static final short[] _http_parser_key_offsets = HttpRequestParser.init__http_parser_key_offsets_0();
    private static final char[] _http_parser_trans_keys = HttpRequestParser.init__http_parser_trans_keys_0();
    private static final byte[] _http_parser_single_lengths = HttpRequestParser.init__http_parser_single_lengths_0();
    private static final byte[] _http_parser_range_lengths = HttpRequestParser.init__http_parser_range_lengths_0();
    private static final short[] _http_parser_index_offsets = HttpRequestParser.init__http_parser_index_offsets_0();
    private static final byte[] _http_parser_indicies = HttpRequestParser.init__http_parser_indicies_0();
    private static final byte[] _http_parser_trans_targs = HttpRequestParser.init__http_parser_trans_targs_0();
    private static final byte[] _http_parser_trans_actions = HttpRequestParser.init__http_parser_trans_actions_0();
    static final int http_parser_start = 1;
    static final int http_parser_first_final = 56;
    static final int http_parser_error = 0;
    static final int http_parser_en_main = 1;
    private static final byte[] _http_keywords_actions = HttpRequestParser.init__http_keywords_actions_0();
    private static final short[] _http_keywords_key_offsets = HttpRequestParser.init__http_keywords_key_offsets_0();
    private static final char[] _http_keywords_trans_keys = HttpRequestParser.init__http_keywords_trans_keys_0();
    private static final byte[] _http_keywords_single_lengths = HttpRequestParser.init__http_keywords_single_lengths_0();
    private static final byte[] _http_keywords_range_lengths = HttpRequestParser.init__http_keywords_range_lengths_0();
    private static final short[] _http_keywords_index_offsets = HttpRequestParser.init__http_keywords_index_offsets_0();
    private static final short[] _http_keywords_trans_targs = HttpRequestParser.init__http_keywords_trans_targs_0();
    private static final byte[] _http_keywords_trans_actions = HttpRequestParser.init__http_keywords_trans_actions_0();
    private static final byte[] _http_keywords_to_state_actions = HttpRequestParser.init__http_keywords_to_state_actions_0();
    private static final byte[] _http_keywords_from_state_actions = HttpRequestParser.init__http_keywords_from_state_actions_0();
    private static final short[] _http_keywords_eof_trans = HttpRequestParser.init__http_keywords_eof_trans_0();
    static final int http_keywords_start = 307;
    static final int http_keywords_first_final = 307;
    static final int http_keywords_error = 0;
    static final int http_keywords_en_main = 307;
    private static final byte[] _http_date_actions = HttpRequestParser.init__http_date_actions_0();
    private static final short[] _http_date_key_offsets = HttpRequestParser.init__http_date_key_offsets_0();
    private static final char[] _http_date_trans_keys = HttpRequestParser.init__http_date_trans_keys_0();
    private static final byte[] _http_date_single_lengths = HttpRequestParser.init__http_date_single_lengths_0();
    private static final byte[] _http_date_range_lengths = HttpRequestParser.init__http_date_range_lengths_0();
    private static final short[] _http_date_index_offsets = HttpRequestParser.init__http_date_index_offsets_0();
    private static final byte[] _http_date_trans_targs = HttpRequestParser.init__http_date_trans_targs_0();
    private static final byte[] _http_date_trans_actions = HttpRequestParser.init__http_date_trans_actions_0();
    static final int http_date_start = 1;
    static final int http_date_first_final = 98;
    static final int http_date_error = 0;
    static final int http_date_en_main = 1;
    public static TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static String crlf = "\r\n";

    private static byte[] init__http_parser_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 2, 0, 3, 2, 0, 6, 2, 1, 5};
    }

    private static short[] init__http_parser_key_offsets_0() {
        return new short[]{0, 0, 10, 12, 14, 16, 18, 20, 21, 31, 41, 50, 52, 53, 54, 55, 56, 58, 61, 63, 66, 67, 69, 70, 72, 73, 75, 84, 93, 99, 105, 111, 117, 121, 125, 135, 141, 147, 156, 165, 171, 177, 179, 181, 183, 185, 187, 189, 191, 193, 195, 197, 199, 203, 205, 207, 209};
    }

    private static char[] init__http_parser_trans_keys_0() {
        return new char[]{'D', 'G', 'H', 'O', 'P', 'd', 'g', 'h', 'o', 'p', 'E', 'e', 'L', 'l', 'E', 'e', 'T', 't', 'E', 'e', ' ', ' ', '+', '/', ':', '-', '9', 'A', 'Z', 'a', 'z', '+', ':', '-', '.', '0', '9', 'A', 'Z', 'a', 'z', ' ', '\"', '#', '%', '<', '>', '\u007f', '\u0000', '\u001f', ' ', 'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', '0', '9', '\r', '0', '9', '\n', '\r', ':', ':', '\r', ' ', '\r', '\n', ':', ' ', '%', '<', '>', '\u007f', '\u0000', '\u001f', '\"', '#', ' ', '%', '<', '>', '\u007f', '\u0000', '\u001f', '\"', '#', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', ' ', '#', ';', '?', ' ', '#', ';', '?', ' ', '\"', '#', '%', '<', '>', '?', '\u007f', '\u0000', '\u001f', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', ' ', '\"', '#', '%', '<', '>', '\u007f', '\u0000', '\u001f', ' ', '\"', '#', '%', '<', '>', '\u007f', '\u0000', '\u001f', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', 'E', 'e', 'T', 't', 'E', 'e', 'A', 'a', 'D', 'd', 'P', 'p', 'T', 't', 'I', 'i', 'O', 'o', 'N', 'n', 'S', 's', 'O', 'U', 'o', 'u', 'S', 's', 'T', 't', 'T', 't', ':', '\u0000'};
    }

    private static byte[] init__http_parser_single_lengths_0() {
        return new byte[]{0, 10, 2, 2, 2, 2, 2, 1, 4, 2, 7, 2, 1, 1, 1, 1, 0, 1, 0, 1, 1, 2, 1, 2, 1, 2, 5, 5, 0, 0, 0, 0, 4, 4, 8, 0, 0, 7, 7, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 1};
    }

    private static byte[] init__http_parser_range_lengths_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 3, 4, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 2, 2, 3, 3, 3, 3, 0, 0, 1, 3, 3, 1, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static short[] init__http_parser_index_offsets_0() {
        return new short[]{0, 0, 11, 14, 17, 20, 23, 26, 28, 36, 43, 52, 55, 57, 59, 61, 63, 65, 68, 70, 73, 75, 78, 80, 83, 85, 88, 96, 104, 108, 112, 116, 120, 125, 130, 140, 144, 148, 157, 166, 170, 174, 177, 180, 183, 186, 189, 192, 195, 198, 201, 204, 207, 212, 215, 218, 221};
    }

    private static byte[] init__http_parser_indicies_0() {
        return new byte[]{0, 2, 3, 4, 5, 0, 2, 3, 4, 5, 1, 6, 6, 1, 7, 7, 1, 8, 8, 1, 9, 9, 1, 10, 10, 1, 11, 1, 11, 12, 13, 14, 12, 12, 12, 1, 15, 16, 15, 15, 15, 15, 1, 17, 1, 18, 19, 1, 1, 1, 1, 16, 17, 20, 1, 21, 1, 22, 1, 23, 1, 24, 1, 25, 1, 26, 27, 1, 28, 1, 29, 28, 1, 30, 1, 32, 1, 31, 34, 33, 36, 37, 35, 39, 38, 40, 34, 33, 41, 43, 1, 1, 1, 1, 1, 42, 44, 46, 1, 1, 1, 1, 1, 45, 47, 47, 47, 1, 45, 45, 45, 1, 48, 48, 48, 1, 16, 16, 16, 1, 17, 18, 50, 51, 49, 52, 53, 54, 55, 49, 17, 1, 18, 56, 1, 1, 51, 1, 1, 50, 57, 57, 57, 1, 50, 50, 50, 1, 58, 1, 60, 61, 1, 1, 1, 1, 59, 62, 1, 64, 65, 1, 1, 1, 1, 63, 66, 66, 66, 1, 63, 63, 63, 1, 67, 67, 1, 68, 68, 1, 69, 69, 1, 70, 70, 1, 71, 71, 1, 72, 72, 1, 73, 73, 1, 74, 74, 1, 75, 75, 1, 76, 76, 1, 77, 77, 1, 78, 79, 78, 79, 1, 80, 80, 1, 81, 81, 1, 82, 82, 1, 34, 33, 0};
    }

    private static byte[] init__http_parser_trans_targs_0() {
        return new byte[]{2, 0, 41, 43, 46, 52, 3, 4, 5, 6, 7, 8, 9, 32, 10, 9, 10, 11, 26, 30, 12, 13, 14, 15, 16, 17, 18, 17, 19, 20, 21, 22, 25, 22, 23, 24, 20, 23, 24, 20, 56, 11, 27, 28, 11, 27, 28, 29, 31, 33, 34, 37, 11, 26, 34, 37, 35, 36, 11, 38, 26, 39, 11, 38, 26, 39, 40, 42, 7, 44, 45, 7, 47, 48, 49, 50, 51, 7, 53, 55, 54, 7, 7};
    }

    private static byte[] init__http_parser_trans_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 15, 0, 1, 1, 0, 5, 1, 29, 1, 0, 7, 0, 32, 1, 1, 13, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 9, 0, 0, 35, 3, 35, 3, 11, 0, 11, 0, 0, 0, 17, 0, 0, 23, 0, 0, 0, 0, 0, 27, 0, 0, 0, 19, 25};
    }

    public static void err(String msg) throws IOException {
        throw new IOException(msg);
    }

    /*
     * Unable to fully structure code
     */
    public static void initHeader(HttpRequest req, int headerLength) throws IOException {
        bb = req.buffer;
        data = bb.array();
        p = 0;
        pe = headerLength;
        cs = 0;
        query_start = 0;
        mark = 0;
        field_name = "";
        cs = 1;
        _trans = 0;
        _goto_targ = 0;
        block23: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block23;
                    }
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block23;
                    }
                }
                case 1: {
                    _keys = HttpRequestParser._http_parser_key_offsets[cs];
                    _trans = HttpRequestParser._http_parser_index_offsets[cs];
                    _klen = HttpRequestParser._http_parser_single_lengths[cs];
                    if (_klen <= 0) ** GOTO lbl40
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if (data[p] < HttpRequestParser._http_parser_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if (data[p] > HttpRequestParser._http_parser_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl54
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl40:
                    // 2 sources

                    if ((_klen = HttpRequestParser._http_parser_range_lengths[cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if (data[p] < HttpRequestParser._http_parser_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if (data[p] > HttpRequestParser._http_parser_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl54
                        }
                        _trans += _klen;
                    }
lbl54:
                    // 5 sources

                    _trans = HttpRequestParser._http_parser_indicies[_trans];
                    cs = HttpRequestParser._http_parser_trans_targs[_trans];
                    if (HttpRequestParser._http_parser_trans_actions[_trans] != 0) {
                        _acts = HttpRequestParser._http_parser_trans_actions[_trans];
                        _nacts = HttpRequestParser._http_parser_actions[_acts++];
                        block26: while (_nacts-- > 0) {
                            block6 : switch (HttpRequestParser._http_parser_actions[_acts++]) {
                                case 0: {
                                    mark = p;
                                    break;
                                }
                                case 1: {
                                    query_start = p;
                                    break;
                                }
                                case 2: {
                                    field_name = HttpRequestParser.kw_lookup(data, mark, p);
                                    if (field_name != null) break;
                                    field_name = req.extractRange(mark, p);
                                    break;
                                }
                                case 3: {
                                    value = HttpRequestParser.encodeRange(mark, p);
                                    req.addField(field_name, value);
                                    break;
                                }
                                case 4: {
                                    s = req.uriPath = req.extractRange(mark, p);
                                    len = s.length();
                                    for (i = 0; i < len; ++i) {
                                        c = s.charAt(i);
                                        if (c != '%' && c <= '\u007f') continue;
                                        try {
                                            req.uriPath = URLDecoder.decode(req.uriPath, "UTF-8");
                                            break block6;
                                        }
                                        catch (UnsupportedEncodingException var21_22) {
                                            // empty catch block
                                        }
                                    }
                                    continue block26;
                                }
                                case 5: {
                                    req.queryStringRange = HttpRequestParser.encodeRange(query_start, p);
                                    break;
                                }
                                case 6: {
                                    req.uriFragmentRange = HttpRequestParser.encodeRange(mark, p);
                                    break;
                                }
                                case 7: {
                                    req.versionRange = HttpRequestParser.encodeRange(mark, p);
                                    break;
                                }
                                case 8: {
                                    req.method = "GET";
                                    break;
                                }
                                case 9: {
                                    req.method = "POST";
                                    break;
                                }
                                case 10: {
                                    req.method = "DELETE";
                                    break;
                                }
                                case 11: {
                                    req.method = "HEAD";
                                    break;
                                }
                                case 12: {
                                    req.method = "PUT";
                                    break;
                                }
                                case 13: {
                                    req.method = "OPTIONS";
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block23;
                    }
                    if (++p == pe) break block23;
                    _goto_targ = 1;
                    continue block23;
                }
            }
            break;
        }
        if (cs == 0) {
            throw new IOException("Malformed HTTP Header. p = " + p + ", cs = " + cs);
        }
    }

    public static int encodeRange(int start, int end) {
        return (start << 16) + end;
    }

    private static byte[] init__http_keywords_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16, 1, 17, 1, 18, 1, 19, 1, 20, 1, 21, 1, 22, 1, 23, 1, 24, 1, 25, 1, 26, 1, 27, 1, 28, 1, 29, 1, 30, 1, 31, 1, 32, 1, 33, 1, 34, 1, 35, 1, 36, 1, 37, 1, 38, 1, 39, 1, 40, 1, 41, 1, 42, 1, 43, 1, 44, 1, 45, 1, 46, 1, 47, 1, 48, 1, 49, 1, 50};
    }

    private static short[] init__http_keywords_key_offsets_0() {
        return new short[]{0, 0, 8, 10, 12, 14, 16, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 92, 94, 96, 98, 100, 102, 104, 108, 110, 112, 114, 115, 117, 119, 121, 123, 125, 127, 129, 131, 135, 137, 139, 141, 143, 145, 147, 149, 151, 153, 154, 164, 166, 168, 170, 172, 174, 176, 178, 184, 186, 188, 190, 192, 194, 196, 198, 200, 202, 204, 206, 208, 210, 212, 214, 216, 218, 219, 221, 223, 225, 227, 229, 231, 233, 235, 237, 239, 243, 245, 247, 249, 253, 255, 257, 259, 261, 263, 265, 267, 269, 271, 273, 275, 277, 278, 286, 290, 292, 294, 296, 298, 300, 302, 304, 306, 308, 309, 311, 313, 315, 317, 319, 321, 323, 325, 326, 328, 330, 332, 334, 336, 338, 340, 342, 344, 346, 348, 350, 352, 354, 356, 358, 360, 362, 363, 365, 367, 369, 371, 373, 377, 379, 381, 382, 384, 386, 388, 390, 392, 394, 396, 398, 400, 402, 404, 406, 408, 410, 412, 414, 415, 417, 419, 421, 423, 425, 427, 429, 431, 433, 437, 439, 441, 443, 445, 447, 448, 450, 452, 454, 456, 460, 462, 464, 466, 468, 470, 472, 474, 476, 478, 480, 482, 484, 486, 488, 490, 494, 496, 498, 500, 504, 506, 508, 510, 512, 514, 516, 517, 519, 521, 523, 525, 527, 529, 531, 533, 535, 537, 541, 543, 547, 549, 551, 553, 555, 557, 559, 561, 562, 564, 566, 568, 570, 572, 574, 576, 578, 582, 584, 586, 588, 590, 592, 594, 596, 597, 599, 601, 603, 605, 607, 611, 613, 615, 617, 621, 623, 625, 627, 629, 631, 633, 634, 636, 638, 640, 642, 644, 646, 648, 650, 652, 654, 656, 658, 690};
    }

    private static char[] init__http_keywords_trans_keys_0() {
        return new char[]{'C', 'G', 'L', 'U', 'c', 'g', 'l', 'u', 'C', 'c', 'E', 'e', 'P', 'p', 'T', 't', 'C', 'E', 'L', 'R', 'c', 'e', 'l', 'r', 'H', 'h', 'A', 'a', 'R', 'r', 'S', 's', 'E', 'e', 'T', 't', 'N', 'n', 'C', 'c', 'O', 'o', 'D', 'd', 'I', 'i', 'N', 'n', 'G', 'g', 'A', 'a', 'N', 'n', 'G', 'g', 'U', 'u', 'A', 'a', 'G', 'g', 'E', 'e', 'A', 'a', 'N', 'n', 'G', 'g', 'E', 'e', 'S', 's', 'E', 'e', 'L', 'l', 'O', 'o', 'W', 'w', 'T', 't', 'H', 'h', 'O', 'o', 'R', 'r', 'I', 'i', 'Z', 'z', 'A', 'a', 'T', 't', 'I', 'i', 'O', 'o', 'N', 'n', 'A', 'O', 'a', 'o', 'C', 'c', 'H', 'h', 'E', 'e', '-', 'C', 'c', 'O', 'o', 'N', 'n', 'T', 't', 'R', 'r', 'O', 'o', 'L', 'l', 'N', 'n', 'N', 'T', 'n', 't', 'E', 'e', 'C', 'c', 'T', 't', 'I', 'i', 'O', 'o', 'N', 'n', 'E', 'e', 'N', 'n', 'T', 't', '-', 'E', 'L', 'M', 'R', 'T', 'e', 'l', 'm', 'r', 't', 'N', 'n', 'C', 'c', 'O', 'o', 'D', 'd', 'I', 'i', 'N', 'n', 'G', 'g', 'A', 'E', 'O', 'a', 'e', 'o', 'N', 'n', 'G', 'g', 'U', 'u', 'A', 'a', 'G', 'g', 'E', 'e', 'N', 'n', 'G', 'g', 'T', 't', 'H', 'h', 'C', 'c', 'A', 'a', 'T', 't', 'I', 'i', 'O', 'o', 'N', 'n', 'D', 'd', '5', 'A', 'a', 'N', 'n', 'G', 'g', 'E', 'e', 'Y', 'y', 'P', 'p', 'E', 'e', 'A', 'a', 'T', 't', 'E', 'e', 'T', 'X', 't', 'x', 'A', 'a', 'G', 'g', 'P', 'p', 'E', 'I', 'e', 'i', 'C', 'c', 'T', 't', 'R', 'r', 'E', 'e', 'S', 's', 'R', 'r', 'O', 'o', 'M', 'm', 'O', 'o', 'S', 's', 'T', 't', 'F', 'f', '-', 'M', 'N', 'R', 'U', 'm', 'n', 'r', 'u', 'A', 'O', 'a', 'o', 'T', 't', 'C', 'c', 'H', 'h', 'D', 'd', 'I', 'i', 'F', 'f', 'I', 'i', 'E', 'e', 'D', 'd', '-', 'S', 's', 'I', 'i', 'N', 'n', 'C', 'c', 'E', 'e', 'O', 'o', 'N', 'n', 'E', 'e', '-', 'M', 'm', 'A', 'a', 'T', 't', 'C', 'c', 'H', 'h', 'A', 'a', 'N', 'n', 'G', 'g', 'E', 'e', 'N', 'n', 'M', 'm', 'O', 'o', 'D', 'd', 'I', 'i', 'F', 'f', 'I', 'i', 'E', 'e', 'D', 'd', '-', 'S', 's', 'I', 'i', 'N', 'n', 'C', 'c', 'E', 'e', 'A', 'O', 'a', 'o', 'S', 's', 'T', 't', '-', 'M', 'm', 'O', 'o', 'D', 'd', 'I', 'i', 'F', 'f', 'I', 'i', 'E', 'e', 'D', 'd', 'C', 'c', 'A', 'a', 'T', 't', 'I', 'i', 'O', 'o', 'N', 'n', 'A', 'a', 'X', 'x', '-', 'F', 'f', 'O', 'o', 'R', 'r', 'W', 'w', 'A', 'a', 'R', 'r', 'D', 'd', 'S', 's', 'R', 'r', 'A', 'O', 'a', 'o', 'G', 'g', 'M', 'm', 'A', 'a', 'X', 'x', 'Y', 'y', '-', 'A', 'a', 'U', 'u', 'T', 't', 'H', 'h', 'E', 'O', 'e', 'o', 'N', 'n', 'T', 't', 'I', 'i', 'C', 'c', 'A', 'a', 'T', 't', 'E', 'e', 'R', 'r', 'I', 'i', 'Z', 'z', 'A', 'a', 'T', 't', 'I', 'i', 'O', 'o', 'N', 'n', 'A', 'E', 'a', 'e', 'N', 'n', 'G', 'g', 'E', 'e', 'F', 'T', 'f', 't', 'E', 'e', 'R', 'r', 'E', 'e', 'R', 'r', 'R', 'r', 'Y', 'y', '-', 'A', 'a', 'F', 'f', 'T', 't', 'E', 'e', 'R', 'r', 'E', 'e', 'R', 'r', 'V', 'v', 'E', 'e', 'R', 'r', 'E', 'R', 'e', 'r', 'A', 'a', 'I', 'N', 'i', 'n', 'L', 'l', 'E', 'e', 'R', 'r', 'S', 's', 'F', 'f', 'E', 'e', 'R', 'r', '-', 'E', 'e', 'N', 'n', 'C', 'c', 'O', 'o', 'D', 'd', 'I', 'i', 'N', 'n', 'G', 'g', 'P', 'S', 'p', 's', 'G', 'g', 'R', 'r', 'A', 'a', 'D', 'd', 'E', 'e', 'E', 'e', 'R', 'r', '-', 'A', 'a', 'G', 'g', 'E', 'e', 'N', 'n', 'T', 't', 'A', 'I', 'a', 'i', 'R', 'r', 'Y', 'y', 'A', 'a', 'A', 'W', 'a', 'w', 'R', 'r', 'N', 'n', 'I', 'i', 'N', 'n', 'G', 'g', 'W', 'w', '-', 'A', 'a', 'U', 'u', 'T', 't', 'H', 'h', 'E', 'e', 'N', 'n', 'T', 't', 'I', 'i', 'C', 'c', 'A', 'a', 'T', 't', 'E', 'e', 'A', 'C', 'D', 'E', 'F', 'H', 'I', 'L', 'M', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'a', 'c', 'd', 'e', 'f', 'h', 'i', 'l', 'm', 'p', 'r', 's', 't', 'u', 'v', 'w', '-', '\u0000'};
    }

    private static byte[] init__http_keywords_single_lengths_0() {
        return new byte[]{0, 8, 2, 2, 2, 2, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 10, 2, 2, 2, 2, 2, 2, 2, 6, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 8, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 4, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 4, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 4, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 32, 1};
    }

    private static byte[] init__http_keywords_range_lengths_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static short[] init__http_keywords_index_offsets_0() {
        return new short[]{0, 0, 9, 12, 15, 18, 21, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96, 99, 102, 105, 108, 111, 114, 117, 120, 123, 126, 129, 132, 135, 138, 141, 144, 147, 150, 155, 158, 161, 164, 166, 169, 172, 175, 178, 181, 184, 187, 190, 195, 198, 201, 204, 207, 210, 213, 216, 219, 222, 224, 235, 238, 241, 244, 247, 250, 253, 256, 263, 266, 269, 272, 275, 278, 281, 284, 287, 290, 293, 296, 299, 302, 305, 308, 311, 314, 316, 319, 322, 325, 328, 331, 334, 337, 340, 343, 346, 351, 354, 357, 360, 365, 368, 371, 374, 377, 380, 383, 386, 389, 392, 395, 398, 401, 403, 412, 417, 420, 423, 426, 429, 432, 435, 438, 441, 444, 446, 449, 452, 455, 458, 461, 464, 467, 470, 472, 475, 478, 481, 484, 487, 490, 493, 496, 499, 502, 505, 508, 511, 514, 517, 520, 523, 526, 528, 531, 534, 537, 540, 543, 548, 551, 554, 556, 559, 562, 565, 568, 571, 574, 577, 580, 583, 586, 589, 592, 595, 598, 601, 604, 606, 609, 612, 615, 618, 621, 624, 627, 630, 633, 638, 641, 644, 647, 650, 653, 655, 658, 661, 664, 667, 672, 675, 678, 681, 684, 687, 690, 693, 696, 699, 702, 705, 708, 711, 714, 717, 722, 725, 728, 731, 736, 739, 742, 745, 748, 751, 754, 756, 759, 762, 765, 768, 771, 774, 777, 780, 783, 786, 791, 794, 799, 802, 805, 808, 811, 814, 817, 820, 822, 825, 828, 831, 834, 837, 840, 843, 846, 851, 854, 857, 860, 863, 866, 869, 872, 874, 877, 880, 883, 886, 889, 894, 897, 900, 903, 908, 911, 914, 917, 920, 923, 926, 928, 931, 934, 937, 940, 943, 946, 949, 952, 955, 958, 961, 964, 997};
    }

    private static short[] init__http_keywords_trans_targs_0() {
        return new short[]{2, 32, 33, 36, 2, 32, 33, 36, 0, 3, 3, 0, 4, 4, 0, 5, 5, 0, 308, 308, 0, 7, 13, 20, 27, 7, 13, 20, 27, 307, 8, 8, 307, 9, 9, 307, 10, 10, 307, 11, 11, 307, 12, 12, 307, 307, 307, 307, 14, 14, 307, 15, 15, 307, 16, 16, 307, 17, 17, 307, 18, 18, 307, 19, 19, 307, 307, 307, 307, 21, 21, 307, 22, 22, 307, 23, 23, 307, 24, 24, 307, 25, 25, 307, 26, 26, 307, 307, 307, 307, 28, 28, 307, 29, 29, 307, 30, 30, 307, 31, 31, 307, 307, 307, 307, 307, 307, 0, 34, 34, 0, 35, 35, 0, 307, 307, 0, 37, 37, 0, 38, 38, 0, 39, 39, 0, 40, 40, 0, 41, 41, 0, 42, 42, 0, 43, 43, 0, 44, 44, 0, 45, 45, 0, 46, 46, 0, 307, 307, 0, 48, 59, 48, 59, 0, 49, 49, 0, 50, 50, 0, 51, 51, 0, 52, 0, 53, 53, 0, 54, 54, 0, 55, 55, 0, 56, 56, 0, 57, 57, 0, 58, 58, 0, 307, 307, 0, 60, 60, 0, 61, 67, 61, 67, 0, 62, 62, 0, 63, 63, 0, 64, 64, 0, 65, 65, 0, 66, 66, 0, 307, 307, 0, 68, 68, 0, 69, 69, 0, 70, 70, 0, 71, 0, 72, 79, 96, 98, 102, 72, 79, 96, 98, 102, 0, 73, 73, 0, 74, 74, 0, 75, 75, 0, 76, 76, 0, 77, 77, 0, 78, 78, 0, 307, 307, 0, 80, 86, 90, 80, 86, 90, 0, 81, 81, 0, 82, 82, 0, 83, 83, 0, 84, 84, 0, 85, 85, 0, 307, 307, 0, 87, 87, 0, 88, 88, 0, 89, 89, 0, 307, 307, 0, 91, 91, 0, 92, 92, 0, 93, 93, 0, 94, 94, 0, 95, 95, 0, 307, 307, 0, 97, 97, 0, 307, 0, 99, 99, 0, 100, 100, 0, 101, 101, 0, 307, 307, 0, 103, 103, 0, 104, 104, 0, 307, 307, 0, 106, 106, 0, 107, 107, 0, 307, 307, 0, 109, 111, 109, 111, 0, 110, 110, 0, 307, 307, 0, 112, 112, 0, 113, 115, 113, 115, 0, 114, 114, 0, 307, 307, 0, 116, 116, 0, 117, 117, 0, 307, 307, 0, 119, 119, 0, 120, 120, 0, 307, 307, 0, 122, 122, 0, 123, 123, 0, 307, 307, 0, 125, 125, 0, 126, 0, 127, 143, 152, 156, 127, 143, 152, 156, 0, 128, 131, 128, 131, 0, 129, 129, 0, 130, 130, 0, 307, 307, 0, 132, 132, 0, 133, 133, 0, 134, 134, 0, 135, 135, 0, 136, 136, 0, 137, 137, 0, 138, 0, 139, 139, 0, 140, 140, 0, 141, 141, 0, 142, 142, 0, 307, 307, 0, 144, 144, 0, 145, 145, 0, 146, 146, 0, 147, 0, 148, 148, 0, 149, 149, 0, 150, 150, 0, 151, 151, 0, 307, 307, 0, 153, 153, 0, 154, 154, 0, 155, 155, 0, 307, 307, 0, 157, 157, 0, 158, 158, 0, 159, 159, 0, 160, 160, 0, 161, 161, 0, 162, 162, 0, 163, 163, 0, 164, 164, 0, 165, 165, 0, 166, 0, 167, 167, 0, 168, 168, 0, 169, 169, 0, 170, 170, 0, 307, 307, 0, 172, 183, 172, 183, 0, 173, 173, 0, 174, 174, 0, 175, 0, 176, 176, 0, 177, 177, 0, 178, 178, 0, 179, 179, 0, 180, 180, 0, 181, 181, 0, 182, 182, 0, 307, 307, 0, 184, 184, 0, 185, 185, 0, 186, 186, 0, 187, 187, 0, 188, 188, 0, 307, 307, 0, 190, 190, 0, 191, 191, 0, 192, 0, 193, 193, 0, 194, 194, 0, 195, 195, 0, 196, 196, 0, 197, 197, 0, 198, 198, 0, 199, 199, 0, 307, 307, 0, 201, 201, 0, 202, 205, 202, 205, 0, 203, 203, 0, 204, 204, 0, 307, 307, 0, 206, 206, 0, 207, 207, 0, 208, 0, 209, 209, 0, 210, 210, 0, 211, 211, 0, 212, 212, 0, 213, 220, 213, 220, 0, 214, 214, 0, 215, 215, 0, 216, 216, 0, 217, 217, 0, 218, 218, 0, 219, 219, 0, 307, 307, 0, 221, 221, 0, 222, 222, 0, 223, 223, 0, 224, 224, 0, 225, 225, 0, 226, 226, 0, 227, 227, 0, 307, 307, 0, 229, 232, 229, 232, 0, 230, 230, 0, 231, 231, 0, 307, 307, 0, 233, 237, 233, 237, 0, 234, 234, 0, 235, 235, 0, 236, 236, 0, 307, 307, 0, 238, 238, 0, 239, 239, 0, 240, 0, 241, 241, 0, 242, 242, 0, 243, 243, 0, 244, 244, 0, 307, 307, 0, 246, 246, 0, 247, 247, 0, 248, 248, 0, 249, 249, 0, 307, 307, 0, 307, 251, 307, 251, 0, 252, 252, 0, 253, 256, 253, 256, 0, 254, 254, 0, 255, 255, 0, 307, 307, 0, 257, 257, 0, 258, 258, 0, 259, 259, 0, 260, 260, 0, 261, 0, 262, 262, 0, 263, 263, 0, 264, 264, 0, 265, 265, 0, 266, 266, 0, 267, 267, 0, 268, 268, 0, 307, 307, 0, 270, 275, 270, 275, 0, 271, 271, 0, 272, 272, 0, 273, 273, 0, 274, 274, 0, 307, 307, 0, 276, 276, 0, 277, 277, 0, 278, 0, 279, 279, 0, 280, 280, 0, 281, 281, 0, 282, 282, 0, 307, 307, 0, 284, 286, 284, 286, 0, 285, 285, 0, 307, 307, 0, 307, 307, 0, 288, 293, 288, 293, 0, 289, 289, 0, 290, 290, 0, 291, 291, 0, 292, 292, 0, 307, 307, 0, 294, 294, 0, 295, 0, 296, 296, 0, 297, 297, 0, 298, 298, 0, 299, 299, 0, 300, 300, 0, 301, 301, 0, 302, 302, 0, 303, 303, 0, 304, 304, 0, 305, 305, 0, 306, 306, 0, 307, 307, 0, 1, 47, 105, 108, 118, 121, 124, 171, 189, 200, 228, 245, 250, 269, 283, 287, 1, 47, 105, 108, 118, 121, 124, 171, 189, 200, 228, 245, 250, 269, 283, 287, 0, 6, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 0};
    }

    private static byte[] init__http_keywords_trans_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 7, 7, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 9, 9, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 11, 11, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 0, 0, 101, 13, 13, 101, 15, 15, 0, 0, 0, 0, 0, 0, 0, 17, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 31, 0, 0, 0, 0, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 35, 0, 0, 0, 0, 0, 0, 0, 37, 37, 0, 0, 0, 0, 0, 0, 0, 39, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 43, 0, 0, 0, 0, 0, 0, 0, 45, 45, 0, 0, 0, 0, 0, 0, 0, 47, 47, 0, 0, 0, 0, 0, 0, 0, 49, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 69, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 77, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 79, 0, 81, 0, 81, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 89, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 91, 0, 93, 93, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 97, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 99, 0};
    }

    private static byte[] init__http_keywords_to_state_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0};
    }

    private static byte[] init__http_keywords_from_state_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0};
    }

    private static short[] init__http_keywords_eof_trans_0() {
        return new short[]{0, 0, 0, 0, 0, 0, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1026};
    }

    /*
     * Unable to fully structure code
     */
    public static String kw_lookup(byte[] data, int start, int len) {
        p = start;
        eof = pe = start + len;
        kw = null;
        cs = 307;
        ts = -1;
        te = -1;
        act = false;
        _trans = 0;
        _goto_targ = 0;
        block64: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block64;
                    }
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block64;
                    }
                }
                case 1: {
                    _acts = HttpRequestParser._http_keywords_from_state_actions[cs];
                    _nacts = HttpRequestParser._http_keywords_actions[_acts++];
                    while (_nacts-- > 0) {
                        switch (HttpRequestParser._http_keywords_actions[_acts++]) {
                            case 1: {
                                ts = p;
                            }
                        }
                    }
                    _keys = HttpRequestParser._http_keywords_key_offsets[cs];
                    _trans = HttpRequestParser._http_keywords_index_offsets[cs];
                    _klen = HttpRequestParser._http_keywords_single_lengths[cs];
                    if (_klen <= 0) ** GOTO lbl45
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if (data[p] < HttpRequestParser._http_keywords_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if (data[p] > HttpRequestParser._http_keywords_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl59
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl45:
                    // 2 sources

                    if ((_klen = HttpRequestParser._http_keywords_range_lengths[cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if (data[p] < HttpRequestParser._http_keywords_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if (data[p] > HttpRequestParser._http_keywords_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl59
                        }
                        _trans += _klen;
                    }
                }
lbl59:
                // 6 sources

                case 3: {
                    cs = HttpRequestParser._http_keywords_trans_targs[_trans];
                    if (HttpRequestParser._http_keywords_trans_actions[_trans] != 0) {
                        _acts = HttpRequestParser._http_keywords_trans_actions[_trans];
                        _nacts = HttpRequestParser._http_keywords_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (HttpRequestParser._http_keywords_actions[_acts++]) {
                                case 2: {
                                    te = p + 1;
                                    break;
                                }
                                case 3: {
                                    te = p + 1;
                                    kw = "Accept-Charset";
                                    break;
                                }
                                case 4: {
                                    te = p + 1;
                                    kw = "Accept-Encoding";
                                    break;
                                }
                                case 5: {
                                    te = p + 1;
                                    kw = "Accept-Language";
                                    break;
                                }
                                case 6: {
                                    te = p + 1;
                                    kw = "Accept-Ranges";
                                    break;
                                }
                                case 7: {
                                    te = p + 1;
                                    kw = "Age";
                                    break;
                                }
                                case 8: {
                                    te = p + 1;
                                    kw = "Allow";
                                    break;
                                }
                                case 9: {
                                    te = p + 1;
                                    kw = "Authorization";
                                    break;
                                }
                                case 10: {
                                    te = p + 1;
                                    kw = "Cache-Control";
                                    break;
                                }
                                case 11: {
                                    te = p + 1;
                                    kw = "Connection";
                                    break;
                                }
                                case 12: {
                                    te = p + 1;
                                    kw = "Content-Encoding";
                                    break;
                                }
                                case 13: {
                                    te = p + 1;
                                    kw = "Content-Language";
                                    break;
                                }
                                case 14: {
                                    te = p + 1;
                                    kw = "Content-Length";
                                    break;
                                }
                                case 15: {
                                    te = p + 1;
                                    kw = "Content-Location";
                                    break;
                                }
                                case 16: {
                                    te = p + 1;
                                    kw = "Content-MD5";
                                    break;
                                }
                                case 17: {
                                    te = p + 1;
                                    kw = "Content-Range";
                                    break;
                                }
                                case 18: {
                                    te = p + 1;
                                    kw = "Content-Type";
                                    break;
                                }
                                case 19: {
                                    te = p + 1;
                                    kw = "Date";
                                    break;
                                }
                                case 20: {
                                    te = p + 1;
                                    kw = "ETag";
                                    break;
                                }
                                case 21: {
                                    te = p + 1;
                                    kw = "Expect";
                                    break;
                                }
                                case 22: {
                                    te = p + 1;
                                    kw = "Expires";
                                    break;
                                }
                                case 23: {
                                    te = p + 1;
                                    kw = "From";
                                    break;
                                }
                                case 24: {
                                    te = p + 1;
                                    kw = "Host";
                                    break;
                                }
                                case 25: {
                                    te = p + 1;
                                    kw = "If-Match";
                                    break;
                                }
                                case 26: {
                                    te = p + 1;
                                    kw = "If-Modified-Since";
                                    break;
                                }
                                case 27: {
                                    te = p + 1;
                                    kw = "If-None-Match";
                                    break;
                                }
                                case 28: {
                                    te = p + 1;
                                    kw = "If-Range";
                                    break;
                                }
                                case 29: {
                                    te = p + 1;
                                    kw = "If-Unmodified-Since";
                                    break;
                                }
                                case 30: {
                                    te = p + 1;
                                    kw = "Last-Modified";
                                    break;
                                }
                                case 31: {
                                    te = p + 1;
                                    kw = "Location";
                                    break;
                                }
                                case 32: {
                                    te = p + 1;
                                    kw = "Max-Forwards";
                                    break;
                                }
                                case 33: {
                                    te = p + 1;
                                    kw = "Pragma";
                                    break;
                                }
                                case 34: {
                                    te = p + 1;
                                    kw = "Proxy-Authenticate";
                                    break;
                                }
                                case 35: {
                                    te = p + 1;
                                    kw = "Proxy-Authorization";
                                    break;
                                }
                                case 36: {
                                    te = p + 1;
                                    kw = "Range";
                                    break;
                                }
                                case 37: {
                                    te = p + 1;
                                    kw = "Referer";
                                    break;
                                }
                                case 38: {
                                    te = p + 1;
                                    kw = "Retry-After";
                                    break;
                                }
                                case 39: {
                                    te = p + 1;
                                    kw = "Server";
                                    break;
                                }
                                case 40: {
                                    te = p + 1;
                                    kw = "TE";
                                    break;
                                }
                                case 41: {
                                    te = p + 1;
                                    kw = "Trailer";
                                    break;
                                }
                                case 42: {
                                    te = p + 1;
                                    kw = "Transfer-Encoding";
                                    break;
                                }
                                case 43: {
                                    te = p + 1;
                                    kw = "Upgrade";
                                    break;
                                }
                                case 44: {
                                    te = p + 1;
                                    kw = "User-Agent";
                                    break;
                                }
                                case 45: {
                                    te = p + 1;
                                    kw = "Vary";
                                    break;
                                }
                                case 46: {
                                    te = p + 1;
                                    kw = "Via";
                                    break;
                                }
                                case 47: {
                                    te = p + 1;
                                    kw = "Warning";
                                    break;
                                }
                                case 48: {
                                    te = p + 1;
                                    kw = "WWW-Authenticate";
                                    break;
                                }
                                case 49: {
                                    te = p--;
                                    kw = "Accept";
                                    break;
                                }
                                case 50: {
                                    p = te - 1;
                                    kw = "Accept";
                                }
                            }
                        }
                    }
                }
                case 2: {
                    _acts = HttpRequestParser._http_keywords_to_state_actions[cs];
                    _nacts = HttpRequestParser._http_keywords_actions[_acts++];
                    while (_nacts-- > 0) {
                        switch (HttpRequestParser._http_keywords_actions[_acts++]) {
                            case 0: {
                                ts = -1;
                            }
                        }
                    }
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block64;
                    }
                    if (++p != pe) {
                        _goto_targ = 1;
                        continue block64;
                    }
                }
                case 4: {
                    if (p != eof || HttpRequestParser._http_keywords_eof_trans[cs] <= 0) break block64;
                    _trans = HttpRequestParser._http_keywords_eof_trans[cs] - 1;
                    _goto_targ = 3;
                    continue block64;
                }
            }
            break;
        }
        return kw;
    }

    private static byte[] init__http_date_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 1, 15, 1, 16};
    }

    private static short[] init__http_date_key_offsets_0() {
        return new short[]{0, 0, 5, 6, 7, 9, 18, 20, 21, 22, 25, 28, 31, 34, 36, 39, 41, 44, 47, 48, 49, 50, 51, 52, 54, 55, 57, 58, 60, 61, 62, 63, 64, 65, 66, 67, 70, 74, 83, 85, 86, 87, 90, 93, 96, 99, 101, 104, 106, 109, 111, 112, 113, 114, 115, 116, 117, 118, 120, 121, 123, 124, 126, 127, 128, 129, 130, 131, 132, 140, 142, 143, 144, 146, 147, 148, 149, 150, 151, 153, 154, 156, 157, 159, 160, 161, 162, 163, 164, 165, 166, 167, 169, 170, 172, 173, 174, 175, 176, 178};
    }

    private static char[] init__http_date_trans_keys_0() {
        return new char[]{'F', 'M', 'S', 'T', 'W', 'r', 'i', ' ', ',', ' ', 'A', 'D', 'F', 'J', 'M', 'N', 'O', 'S', 'p', 'u', 'r', ' ', ' ', '0', '9', ' ', '0', '9', ' ', '0', '9', ':', '0', '9', '0', '9', ':', '0', '9', '0', '9', ' ', '0', '9', ' ', '0', '9', 'g', 'e', 'c', 'e', 'b', 'a', 'u', 'n', 'l', 'n', 'a', 'r', 'y', 'o', 'v', 'c', 't', 'e', 'p', ' ', ' ', '0', '9', ' ', '-', '0', '9', ' ', 'A', 'D', 'F', 'J', 'M', 'N', 'O', 'S', 'p', 'u', 'r', ' ', ' ', '0', '9', ' ', '0', '9', ' ', '0', '9', ':', '0', '9', '0', '9', ':', '0', '9', '0', '9', ' ', '0', '9', ' ', 'G', 'M', 'T', 'g', 'e', 'c', 'e', 'b', 'a', 'u', 'n', 'l', 'n', 'a', 'r', 'y', 'o', 'v', 'c', 't', 'e', 'p', 'A', 'D', 'F', 'J', 'M', 'N', 'O', 'S', 'p', 'u', 'r', '-', '0', '9', 'g', 'e', 'c', 'e', 'b', 'a', 'u', 'n', 'l', 'n', 'a', 'r', 'y', 'o', 'v', 'c', 't', 'e', 'p', 'o', 'n', 'a', 'u', 't', 'h', 'u', 'u', 'e', 'e', 'd', '0', '9', '\u0000'};
    }

    private static byte[] init__http_date_single_lengths_0() {
        return new byte[]{0, 5, 1, 1, 2, 9, 2, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 9, 2, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 8, 2, 1, 1, 0, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 0, 0};
    }

    private static byte[] init__http_date_range_lengths_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0};
    }

    private static short[] init__http_date_index_offsets_0() {
        return new short[]{0, 0, 6, 8, 10, 13, 23, 26, 28, 30, 33, 36, 39, 42, 44, 47, 49, 52, 55, 57, 59, 61, 63, 65, 68, 70, 73, 75, 78, 80, 82, 84, 86, 88, 90, 92, 95, 99, 109, 112, 114, 116, 119, 122, 125, 128, 130, 133, 135, 138, 141, 143, 145, 147, 149, 151, 153, 155, 158, 160, 163, 165, 168, 170, 172, 174, 176, 178, 180, 189, 192, 194, 196, 198, 200, 202, 204, 206, 208, 211, 213, 216, 218, 221, 223, 225, 227, 229, 231, 233, 235, 237, 240, 242, 245, 247, 249, 251, 253, 255};
    }

    private static byte[] init__http_date_trans_targs_0() {
        return new byte[]{2, 89, 91, 93, 96, 0, 3, 0, 4, 0, 5, 34, 0, 5, 6, 19, 21, 23, 26, 28, 30, 32, 0, 7, 18, 0, 8, 0, 9, 0, 9, 10, 0, 11, 10, 0, 11, 12, 0, 13, 12, 0, 14, 0, 15, 14, 0, 16, 0, 17, 16, 0, 17, 98, 0, 8, 0, 20, 0, 8, 0, 22, 0, 8, 0, 24, 25, 0, 8, 0, 8, 8, 0, 27, 0, 8, 8, 0, 29, 0, 8, 0, 31, 0, 8, 0, 33, 0, 8, 0, 35, 0, 35, 36, 0, 37, 68, 36, 0, 37, 38, 53, 55, 57, 60, 62, 64, 66, 0, 39, 52, 0, 40, 0, 41, 0, 41, 42, 0, 43, 42, 0, 43, 44, 0, 45, 44, 0, 46, 0, 47, 46, 0, 48, 0, 49, 48, 0, 49, 50, 0, 51, 0, 99, 0, 40, 0, 54, 0, 40, 0, 56, 0, 40, 0, 58, 59, 0, 40, 0, 40, 40, 0, 61, 0, 40, 40, 0, 63, 0, 40, 0, 65, 0, 40, 0, 67, 0, 40, 0, 69, 74, 76, 78, 81, 83, 85, 87, 0, 70, 73, 0, 71, 0, 72, 0, 42, 0, 71, 0, 75, 0, 71, 0, 77, 0, 71, 0, 79, 80, 0, 71, 0, 71, 71, 0, 82, 0, 71, 71, 0, 84, 0, 71, 0, 86, 0, 71, 0, 88, 0, 71, 0, 90, 0, 4, 0, 92, 90, 0, 4, 0, 94, 95, 0, 4, 0, 4, 0, 97, 0, 4, 0, 98, 0, 0, 0};
    }

    private static byte[] init__http_date_trans_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 5, 0, 0, 5, 0, 7, 0, 0, 7, 0, 9, 0, 0, 9, 0, 0, 3, 0, 25, 0, 0, 0, 33, 0, 0, 0, 13, 0, 0, 0, 0, 11, 0, 23, 21, 0, 0, 0, 15, 19, 0, 0, 0, 31, 0, 0, 0, 29, 0, 0, 0, 27, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 5, 0, 0, 5, 0, 7, 0, 0, 7, 0, 9, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 33, 0, 0, 0, 13, 0, 0, 0, 0, 11, 0, 23, 21, 0, 0, 0, 15, 19, 0, 0, 0, 31, 0, 0, 0, 29, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 3, 0, 25, 0, 0, 0, 33, 0, 0, 0, 13, 0, 0, 0, 0, 11, 0, 23, 21, 0, 0, 0, 15, 19, 0, 0, 0, 31, 0, 0, 0, 29, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0};
    }

    /*
     * Unable to fully structure code
     */
    public static long parseDate(byte[] data, int pos, int len) {
        p = 0;
        pe = len;
        day = 0;
        month = 0;
        year = 0;
        hh = 0;
        mm = 0;
        ss = 0;
        cs = 1;
        _trans = 0;
        _goto_targ = 0;
        block24: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block24;
                    }
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block24;
                    }
                }
                case 1: {
                    _keys = HttpRequestParser._http_date_key_offsets[cs];
                    _trans = HttpRequestParser._http_date_index_offsets[cs];
                    _klen = HttpRequestParser._http_date_single_lengths[cs];
                    if (_klen <= 0) ** GOTO lbl40
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if (data[p] < HttpRequestParser._http_date_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if (data[p] > HttpRequestParser._http_date_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl54
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl40:
                    // 2 sources

                    if ((_klen = HttpRequestParser._http_date_range_lengths[cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if (data[p] < HttpRequestParser._http_date_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if (data[p] > HttpRequestParser._http_date_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl54
                        }
                        _trans += _klen;
                    }
lbl54:
                    // 5 sources

                    cs = HttpRequestParser._http_date_trans_targs[_trans];
                    if (HttpRequestParser._http_date_trans_actions[_trans] != 0) {
                        _acts = HttpRequestParser._http_date_trans_actions[_trans];
                        _nacts = HttpRequestParser._http_date_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (HttpRequestParser._http_date_actions[_acts++]) {
                                case 0: {
                                    day = day * 10 + (data[p] - 48);
                                    break;
                                }
                                case 1: {
                                    year = year * 10 + (data[p] - 48);
                                    break;
                                }
                                case 2: {
                                    hh = hh * 10 + (data[p] - 48);
                                    break;
                                }
                                case 3: {
                                    mm = mm * 10 + (data[p] - 48);
                                    break;
                                }
                                case 4: {
                                    ss = ss * 10 + (data[p] - 48);
                                    break;
                                }
                                case 5: {
                                    month = 0;
                                    break;
                                }
                                case 6: {
                                    month = 1;
                                    break;
                                }
                                case 7: {
                                    month = 2;
                                    break;
                                }
                                case 8: {
                                    month = 3;
                                    break;
                                }
                                case 9: {
                                    month = 4;
                                    break;
                                }
                                case 10: {
                                    month = 5;
                                    break;
                                }
                                case 11: {
                                    month = 6;
                                    break;
                                }
                                case 12: {
                                    month = 7;
                                    break;
                                }
                                case 13: {
                                    month = 8;
                                    break;
                                }
                                case 14: {
                                    month = 90;
                                    break;
                                }
                                case 15: {
                                    month = 10;
                                    break;
                                }
                                case 16: {
                                    month = 11;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block24;
                    }
                    if (++p == pe) break block24;
                    _goto_targ = 1;
                    continue block24;
                }
            }
            break;
        }
        if (year < 100) {
            year += 1900;
        }
        gc = new GregorianCalendar();
        gc.set(year, month, day, hh, mm, ss);
        gc.setTimeZone(HttpRequestParser.GMT);
        return gc.getTimeInMillis();
    }

    public static void main(String[] args) throws Exception {
        String s = "GET /favicon.ico#test HTTP/1.1\r\nHost: localhost:7262\r\nUser-Agent: Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.5; en-US; rv:1.9.0.10) Gecko/2009042315 Firefox/3.0.10 Ubiquity/0.1.5\r\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\r\nAccept-Language: en-us,en;q=0.5\r\nAccept-Encoding: gzip,deflate\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\n\r\n";
        System.out.println("Input Request: (" + s.length() + " bytes)");
        System.out.println(s);
        byte[] data = s.getBytes();
        int len = data.length;
        System.out.println("=============================================================");
        HttpRequest req = new HttpRequest();
        req.buffer = ByteBuffer.allocate(2048);
        req.buffer.put(data);
        HttpRequestParser.initHeader(req, len);
        System.out.println(req);
    }
}

