/*
 * Decompiled with CFR 0.152.
 */
package kilim.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kilim.Fiber;
import kilim.Pausable;
import kilim.S_O;
import kilim.State;
import kilim.Task;
import kilim.http.HttpMsg;
import kilim.http.KeyValues;
import kilim.http.Utils;
import kilim.nio.EndPoint;

public class HttpRequest
extends HttpMsg {
    public String method;
    public String uriPath;
    public int nFields;
    public String[] keys = new String[5];
    public int versionRange;
    public int uriFragmentRange;
    public int queryStringRange;
    public int[] valueRanges = new int[5];
    public int contentOffset;
    public int contentLength;
    public int iread;
    public static byte CR = (byte)13;
    public static byte LF = (byte)10;
    static final byte b0 = 48;
    static final byte b9 = 57;
    static final byte ba = 97;
    static final byte bf = 102;
    static final byte bA = 65;
    static final byte bF = 70;
    static final byte SEMI = 59;
    public static final boolean $isWoven = true;

    public String getHeader(String key) {
        for (int i = 0; i < this.nFields; ++i) {
            if (!key.equalsIgnoreCase(this.keys[i])) continue;
            return this.extractRange(this.valueRanges[i]);
        }
        return "";
    }

    public String getQuery() {
        return this.extractRange(this.queryStringRange);
    }

    public String version() {
        return this.extractRange(this.versionRange);
    }

    public boolean keepAlive() {
        return this.isOldHttp() ? "Keep-Alive".equals(this.getHeader("Connection")) : !"close".equals(this.getHeader("Connection"));
    }

    public KeyValues getQueryComponents() {
        String q = this.getQuery();
        return this.getQueryComponents(q);
    }

    public KeyValues getQueryComponents(String q) {
        int len = q.length();
        if (q == null || len == 0) {
            return new KeyValues(0);
        }
        int numPairs = 0;
        for (int i = 0; i < len; ++i) {
            if (q.charAt(i) != '=') continue;
            ++numPairs;
        }
        KeyValues components = new KeyValues(numPairs);
        int beg = 0;
        String key = null;
        boolean url_encoded = false;
        for (int i = 0; i <= len; ++i) {
            int c;
            int n = c = i == len ? 38 : (int)q.charAt(i);
            if (c == 43 || c == 37) {
                url_encoded = true;
            }
            if (c != 61 && c != 38) continue;
            String comp = q.substring(beg, i);
            if (url_encoded) {
                try {
                    comp = URLDecoder.decode(comp, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (key == null) {
                key = comp;
            } else {
                components.put(key, comp);
                key = null;
            }
            beg = i + 1;
            url_encoded = false;
        }
        return components;
    }

    public String uriFragment() {
        return this.extractRange(this.uriFragmentRange);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        sb.append("method: ").append(this.method).append('\n').append("version: ").append(this.version()).append('\n').append("path = ").append(this.uriPath).append('\n').append("uri_fragment = ").append(this.uriFragment()).append('\n').append("query = ").append(this.getQueryComponents()).append('\n');
        for (int i = 0; i < this.nFields; ++i) {
            sb.append(this.keys[i]).append(": ").append(this.extractRange(this.valueRanges[i])).append('\n');
        }
        return sb.toString();
    }

    public boolean isOldHttp() {
        int b1 = 49;
        int offset = this.versionRange >> 16;
        return this.buffer.get(offset) < 49 || this.buffer.get(offset + 2) < 49;
    }

    public void reuse() {
        this.method = null;
        this.uriPath = null;
        this.versionRange = 0;
        this.queryStringRange = 0;
        this.uriFragmentRange = 0;
        this.contentOffset = 0;
        this.contentLength = 0;
        if (this.buffer != null) {
            this.buffer.clear();
        }
        for (int i = 0; i < this.nFields; ++i) {
            this.keys[i] = null;
        }
        this.nFields = 0;
    }

    public void readFrom(EndPoint endPoint, Fiber fiber) throws Pausable, IOException {
        State state;
        EndPoint endPoint2;
        HttpRequest httpRequest;
        block14: {
            EndPoint endpoint;
            EndPoint endPoint3;
            HttpRequest httpRequest2;
            switch (fiber.pc) {
                default: {
                    fiber.wrongPC();
                }
                case 1: {
                    httpRequest2 = this;
                    endPoint3 = null;
                    break;
                }
                case 2: {
                    httpRequest = this;
                    endPoint2 = null;
                    break block14;
                }
                case 0: {
                    this.iread = 0;
                    httpRequest2 = this;
                    endPoint3 = endpoint;
                }
            }
            httpRequest2.readHeader(endPoint3, fiber.down());
            switch (fiber.up()) {
                case 2: {
                    S_O s_O = new S_O();
                    s_O.self = this;
                    s_O.pc = 1;
                    s_O.f0 = endpoint;
                    fiber.setState(s_O);
                    return;
                }
                case 3: {
                    return;
                }
                case 1: {
                    state = (S_O)fiber.curState;
                    endpoint = (EndPoint)state.f0;
                }
            }
            httpRequest = this;
            endPoint2 = endpoint;
        }
        httpRequest.readBody(endPoint2, fiber.down());
        switch (fiber.up()) {
            case 2: {
                state = new State();
                state.self = this;
                state.pc = 2;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public void readFrom(EndPoint endPoint) throws Pausable, IOException {
        Task.errNotWoven();
    }

    /*
     * Exception decompiling
     */
    public void readHeader(EndPoint var1_1, Fiber var2_2) throws Pausable, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[SWITCH], 4[CASE]], but top level block is 11[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void readHeader(EndPoint endPoint) throws Pausable, IOException {
        Task.errNotWoven();
    }

    public void dumpBuffer(ByteBuffer buffer) {
        byte[] ba = buffer.array();
        int len = buffer.position();
        for (int i = 0; i < len; ++i) {
            System.out.print((char)ba[i]);
        }
    }

    public void addField(String key, int valRange) {
        if (this.keys.length == this.nFields) {
            this.keys = (String[])Utils.growArray(this.keys, 5);
            this.valueRanges = Utils.growArray(this.valueRanges, 5);
        }
        this.keys[this.nFields] = key;
        this.valueRanges[this.nFields] = valRange;
        ++this.nFields;
    }

    public String extractRange(int range) {
        int beg = range >> 16;
        int end = range & 0xFFFF;
        return this.extractRange(beg, end);
    }

    public String extractRange(int beg, int end) {
        return new String(this.buffer.array(), beg, end - beg);
    }

    public byte[] extractBytes(int beg, int end) {
        return Arrays.copyOfRange(this.buffer.array(), beg, end);
    }

    public void readBody(EndPoint endPoint, Fiber fiber) throws Pausable, IOException {
        EndPoint endpoint;
        block19: {
            EndPoint endPoint2;
            HttpRequest httpRequest;
            block17: {
                block18: {
                    int n;
                    int n2;
                    EndPoint endPoint3;
                    HttpRequest httpRequest2;
                    switch (fiber.pc) {
                        default: {
                            fiber.wrongPC();
                        }
                        case 1: {
                            httpRequest2 = this;
                            endPoint3 = null;
                            n2 = 0;
                            n = 0;
                            break;
                        }
                        case 2: {
                            httpRequest = this;
                            endPoint2 = null;
                            break block17;
                        }
                        case 0: {
                            this.iread = this.contentOffset;
                            if (this.contentLength <= 0) break block18;
                            httpRequest2 = this;
                            endPoint3 = endpoint;
                            n2 = this.contentOffset;
                            n = this.contentLength;
                        }
                    }
                    httpRequest2.fill(endPoint3, n2, n, fiber.down());
                    switch (fiber.up()) {
                        case 2: {
                            S_O s_O = new S_O();
                            s_O.self = this;
                            s_O.pc = 1;
                            s_O.f0 = endpoint;
                            fiber.setState(s_O);
                            return;
                        }
                        case 3: {
                            return;
                        }
                        case 1: {
                            S_O s_O = (S_O)fiber.curState;
                            endpoint = (EndPoint)s_O.f0;
                        }
                    }
                    this.iread = this.contentOffset + this.contentLength;
                    break block19;
                }
                if (this.contentLength != -1) break block19;
                httpRequest = this;
                endPoint2 = endpoint;
            }
            httpRequest.readAllChunks(endPoint2, fiber.down());
            switch (fiber.up()) {
                case 2: {
                    S_O s_O = new S_O();
                    s_O.self = this;
                    s_O.pc = 2;
                    s_O.f0 = endpoint;
                    fiber.setState(s_O);
                    return;
                }
                case 3: {
                    return;
                }
                case 1: {
                    S_O s_O = (S_O)fiber.curState;
                    endpoint = (EndPoint)s_O.f0;
                }
            }
        }
        this.readTrailers(endpoint);
    }

    public void readBody(EndPoint endPoint) throws Pausable, IOException {
        Task.errNotWoven();
    }

    public void readTrailers(EndPoint endpoint) {
    }

    /*
     * Exception decompiling
     */
    public void readAllChunks(EndPoint var1_1, Fiber var2_2) throws IOException, Pausable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[SWITCH], 4[CASE]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void readAllChunks(EndPoint endPoint) throws IOException, Pausable {
        Task.errNotWoven();
    }

    public static int parseChunkSize(ByteBuffer buffer, int start, int end) throws IOException {
        byte[] bufa = buffer.array();
        int size = 0;
        for (int i = start; i < end; ++i) {
            byte b = bufa[i];
            if (b >= 48 && b <= 57) {
                size = size * 16 + (b - 48);
                continue;
            }
            if (b >= 97 && b <= 102) {
                size = size * 16 + (b - 97 + 10);
                continue;
            }
            if (b >= 65 && b <= 70) {
                size = size * 16 + (b - 65 + 10);
                continue;
            }
            if (b == CR || b == 59) break;
            throw new IOException("Error parsing chunk size; unexpected char " + b + " at offset " + i);
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    public void fill(EndPoint endPoint, int n, int n2, Fiber fiber) throws IOException, Pausable {
        block9: {
            int n3;
            ByteBuffer byteBuffer;
            EndPoint endPoint2;
            HttpRequest httpRequest;
            Fiber fiber2 = fiber;
            switch (fiber2.pc) {
                default: {
                    fiber2.wrongPC();
                }
                case 1: {
                    boolean bl = false;
                    boolean bl2 = false;
                    httpRequest = null;
                    endPoint2 = (EndPoint)fiber2.getCallee();
                    byteBuffer = null;
                    n3 = 0;
                    break;
                }
                case 0: {
                    void endpoint;
                    void size;
                    void offset;
                    void total = offset + size;
                    int currentPos = this.buffer.position();
                    if (total <= this.buffer.position()) break block9;
                    httpRequest = this;
                    endPoint2 = endpoint;
                    byteBuffer = this.buffer;
                    n3 = total - currentPos;
                }
            }
            ByteBuffer byteBuffer2 = endPoint2.fill(byteBuffer, n3, fiber2.down());
            switch (fiber2.up()) {
                case 2: {
                    S_O s_O = new S_O();
                    s_O.self = this;
                    s_O.pc = 1;
                    HttpRequest httpRequest2 = httpRequest;
                    s_O.f0 = httpRequest2;
                    fiber2.setState(s_O);
                    return;
                }
                case 3: {
                    return;
                }
                case 1: {
                    ByteBuffer byteBuffer3 = byteBuffer2;
                    S_O s_O = (S_O)fiber2.curState;
                    httpRequest = (HttpRequest)s_O.f0;
                    byteBuffer2 = byteBuffer3;
                }
            }
            httpRequest.buffer = byteBuffer2;
        }
    }

    public void fill(EndPoint endPoint, int n, int n2) throws IOException, Pausable {
        Task.errNotWoven();
    }

    /*
     * Exception decompiling
     */
    public int readLine(EndPoint var1_1, Fiber var2_2) throws IOException, Pausable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[SWITCH], 4[CASE]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int readLine(EndPoint endPoint) throws IOException, Pausable {
        Task.errNotWoven();
        return 0;
    }
}

