/*
 * Decompiled with CFR 0.152.
 */
package kilim.concurrent;

import kilim.concurrent.UnsafeAccess;
import kilim.concurrent.VolatileReferenceCellValue;

public class VolatileReferenceCell<V>
extends VolatileReferenceCellValue<V> {
    volatile long p10;
    volatile long p11;
    volatile long p12;
    volatile long p13;
    volatile long p14;
    volatile long p15;
    volatile long p16;
    private static final long valueOffset;

    public VolatileReferenceCell(V initialValue) {
        this.value = initialValue;
    }

    public VolatileReferenceCell() {
    }

    public final V get() {
        return (V)this.value;
    }

    public final void set(V newValue) {
        this.value = newValue;
    }

    public final void lazySet(V newValue) {
        UnsafeAccess.UNSAFE.putOrderedObject(this, valueOffset, newValue);
    }

    public final boolean compareAndSet(V expect, V update) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, valueOffset, expect, update);
    }

    public final boolean weakCompareAndSet(V expect, V update) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, valueOffset, expect, update);
    }

    public final V getAndSet(V newValue) {
        V x;
        while (!this.compareAndSet(x = this.get(), newValue)) {
        }
        return x;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    static {
        try {
            valueOffset = UnsafeAccess.UNSAFE.objectFieldOffset(VolatileReferenceCellValue.class.getDeclaredField("value"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

