/*
 * Decompiled with CFR 0.152.
 */
package kilim.concurrent;

import kilim.concurrent.UnsafeAccess;
import kilim.concurrent.VolatileBooleanValue;

public final class VolatileBoolean
extends VolatileBooleanValue {
    private static final long VALUE_OFFSET;

    public VolatileBoolean() {
        this(false);
    }

    public VolatileBoolean(boolean v) {
        this.lazySet(v);
    }

    public void lazySet(boolean newV) {
        int v = newV ? 1 : 0;
        UnsafeAccess.UNSAFE.putOrderedInt(this, VALUE_OFFSET, v);
    }

    public void set(boolean newV) {
        this.value = newV ? 1 : 0;
    }

    public boolean get() {
        return this.value != 0;
    }

    public final boolean compareAndSet(boolean expect, boolean update) {
        int e = expect ? 1 : 0;
        int u = update ? 1 : 0;
        return UnsafeAccess.UNSAFE.compareAndSwapInt(this, VALUE_OFFSET, e, u);
    }

    static {
        try {
            VALUE_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(VolatileBooleanValue.class.getDeclaredField("value"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

