/*
 * Decompiled with CFR 0.152.
 */
package kilim.concurrent;

import kilim.Fiber;
import kilim.MailboxSPSC;
import kilim.Pausable;
import kilim.Task;
import kilim.concurrent.VolatileLongCell;

public class SPSCQueue<T> {
    protected T[] buffer;
    public final VolatileLongCell tail = new VolatileLongCell(0L);
    public final VolatileLongCell head = new VolatileLongCell(0L);
    protected final int mask;
    protected final PaddedLong tailCache = new PaddedLong();
    protected final PaddedLong headCache = new PaddedLong();
    public static final boolean $isWoven = true;

    public SPSCQueue(int initialSize) {
        if (initialSize < 1) {
            throw new IllegalArgumentException("initialSize: " + initialSize + " cannot be less then 1");
        }
        initialSize = SPSCQueue.findNextPositivePowerOfTwo(initialSize);
        this.buffer = new Object[initialSize];
        this.mask = initialSize - 1;
    }

    public static int findNextPositivePowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public T poll() {
        T msg = null;
        long currentHead = this.head.get();
        boolean flag = false;
        if (currentHead >= this.tailCache.value) {
            this.tailCache.value = this.tail.get();
            if (currentHead >= this.tailCache.value) {
                return null;
            }
        }
        if (!flag) {
            int index = (int)currentHead & this.mask;
            msg = this.buffer[index];
            this.buffer[index] = null;
            this.head.lazySet(currentHead + 1L);
        }
        return msg;
    }

    public boolean offer(T msg) {
        if (msg == null) {
            throw new NullPointerException("Null is not a valid element");
        }
        long currentTail = this.tail.get();
        long wrapPoint = currentTail - (long)this.buffer.length;
        if (this.headCache.value <= wrapPoint) {
            this.headCache.value = this.head.get();
            if (this.headCache.value <= wrapPoint) {
                return false;
            }
        }
        this.buffer[(int)currentTail & this.mask] = msg;
        this.tail.lazySet(currentTail + 1L);
        return true;
    }

    /*
     * Exception decompiling
     */
    public void putMailbox(T[] var1_1, MailboxSPSC var2_2, Fiber var3_3) throws Pausable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CASE], 0[SWITCH]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void putMailbox(T[] TArray, MailboxSPSC mailboxSPSC) throws Pausable {
        Task.errNotWoven();
    }

    public boolean fillnb(T[] msg) {
        int n = msg.length;
        long currentHead = this.head.get();
        if (currentHead + (long)n > this.tailCache.value) {
            this.tailCache.value = this.tail.get();
        }
        if ((n = (int)Math.min(this.tailCache.value - currentHead, (long)n)) == 0) {
            return false;
        }
        int i = 0;
        do {
            int index = (int)currentHead++ & this.mask;
            msg[i++] = this.buffer[index];
            this.buffer[index] = null;
        } while (0 != --n);
        this.head.lazySet(currentHead);
        return true;
    }

    public boolean isEmpty() {
        this.headCache.value = this.head.get();
        return this.buffer[(int)this.headCache.value & this.mask] == null;
    }

    public boolean hasSpace() {
        this.tailCache.value = this.tail.get();
        return this.buffer[(int)this.tailCache.value & this.mask] == null;
    }

    public int size() {
        return (int)(this.tail.get() - this.head.get());
    }

    public static class PaddedLong {
        public volatile long p11;
        public volatile long p21;
        public volatile long p31;
        public volatile long p41;
        public volatile long p51;
        public volatile long p61;
        public long value = 0L;
        public volatile long p1;
        public volatile long p2;
        public volatile long p3;
        public volatile long p4;
        public volatile long p5;
        public volatile long p6;
    }
}

