/*
 * Decompiled with CFR 0.152.
 */
package kilim.concurrent;

import kilim.concurrent.MPSCQueueL0Pad;

abstract class MPSCQueueColdFields<E>
extends MPSCQueueL0Pad {
    protected static final int BUFFER_PAD = 64;
    protected static final int SPARSE_SHIFT = Integer.getInteger("sparse.shift", 0);
    protected final int capacity;
    protected final long mask;
    protected final E[] buffer;

    public MPSCQueueColdFields(int capacity) {
        this.capacity = MPSCQueueColdFields.isPowerOf2(capacity) ? capacity : MPSCQueueColdFields.findNextPositivePowerOfTwo(capacity);
        this.mask = this.capacity - 1;
        this.buffer = new Object[(this.capacity << SPARSE_SHIFT) + 128];
    }

    public static int findNextPositivePowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static boolean isPowerOf2(int value) {
        return (value & value - 1) == 0;
    }
}

