/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.ArrayList;
import java.util.BitSet;
import kilim.analysis.Handler;

public class Usage {
    private int nLocals;
    private BitSet in;
    private BitSet born;
    private BitSet use;
    private BitSet def;
    boolean firstBorn = true;

    public Usage(int numLocals) {
        this.nLocals = numLocals;
        this.in = new BitSet(numLocals);
        this.use = new BitSet(numLocals);
        this.def = new BitSet(numLocals);
        this.born = new BitSet(numLocals);
    }

    public void read(int var) {
        assert (var < this.nLocals) : "local var num=" + var + " exceeds nLocals = " + this.nLocals;
        if (!this.def.get(var)) {
            this.use.set(var);
        }
    }

    public void write(int var) {
        assert (var < this.nLocals) : "local var num=" + var + " exceeds nLocals = " + this.nLocals;
        this.def.set(var);
    }

    public void born(int var) {
        assert (var < this.nLocals) : "local var num=" + var + " exceeds nLocals = " + this.nLocals;
        this.born.set(var);
    }

    public boolean isLiveIn(int var) {
        return this.in.get(var);
    }

    public boolean evalLiveIn(ArrayList<Usage> succUsage, ArrayList<Handler> handUsage) {
        BitSet out = new BitSet(this.nLocals);
        BitSet old_in = (BitSet)this.in.clone();
        if (handUsage == null) {
            handUsage = new ArrayList();
        }
        if (succUsage.size() == 0) {
            this.in = this.use;
        } else {
            out = (BitSet)succUsage.get((int)0).in.clone();
            for (int i = 1; i < succUsage.size(); ++i) {
                out.or(succUsage.get((int)i).in);
            }
            BitSet def1 = (BitSet)this.def.clone();
            for (Handler handle : handUsage) {
                def1.and(handle.catchBB.usage.def);
            }
            def1.flip(0, this.nLocals);
            out.and(def1);
            for (Handler handler : handUsage) {
                out.or(handler.catchBB.usage.use);
            }
            out.and(this.born);
            out.or(this.use);
            this.in = out;
        }
        return !this.in.equals(old_in);
    }

    BitSet getCombo() {
        BitSet combo = (BitSet)this.born.clone();
        combo.or(this.def);
        return combo;
    }

    void mergeBorn() {
        this.born.or(this.def);
    }

    void initBorn(BitSet first) {
        this.born.or(first);
        this.firstBorn = false;
    }

    boolean evalBornIn(Usage pred, BitSet combo) {
        BitSet old = (BitSet)this.born.clone();
        if (combo == null) {
            combo = pred.born;
        }
        if (this.firstBorn) {
            this.born.or(combo);
        } else {
            this.born.and(combo);
        }
        this.firstBorn = false;
        return !old.equals(this.born);
    }

    void absorb(Usage succ) {
        BitSet b = (BitSet)this.def.clone();
        b.flip(0, this.nLocals);
        b.and(succ.use);
        this.use.or(b);
        this.def.or(succ.def);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("use");
        this.printBits(sb, this.use);
        sb.append("def");
        this.printBits(sb, this.def);
        sb.append("in");
        this.printBits(sb, this.in);
        sb.append("born");
        this.printBits(sb, this.born);
        return sb.toString();
    }

    public String toStringBits(String sep) {
        StringBuffer sb = new StringBuffer();
        this.printBitsFull(sb, this.use);
        sb.append("   ");
        this.printBitsFull(sb, this.def);
        sb.append("   ");
        this.printBitsFull(sb, this.in);
        sb.append("   ");
        this.printBitsFull(sb, this.born);
        return sb.toString();
    }

    private void printBits(StringBuffer sb, BitSet b) {
        int i;
        int numDefined = 0;
        for (i = 0; i < this.nLocals; ++i) {
            if (!b.get(i)) continue;
            ++numDefined;
        }
        sb.append('(').append(numDefined).append("): ");
        for (i = 0; i < this.nLocals; ++i) {
            if (!b.get(i)) continue;
            sb.append(i).append(' ');
        }
        sb.append('\n');
    }

    private String printBitsFull(BitSet b) {
        StringBuffer sb = new StringBuffer();
        this.printBitsFull(sb, b);
        return sb.toString();
    }

    private void printBitsFull(StringBuffer sb, BitSet b) {
        for (int i = 0; i < this.nLocals; ++i) {
            if (i > 0 && i % 10 == 0) {
                sb.append('.');
            }
            sb.append(b.get(i) ? (char)'1' : '0');
        }
    }

    public void setLiveIn(int var) {
        this.in.set(var);
    }

    public void setBornIn(int var) {
        this.born.set(var);
    }

    Usage copy() {
        Usage ret = new Usage(this.nLocals);
        ret.use = this.use;
        ret.def = this.def;
        return ret;
    }
}

