/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.ArrayList;
import java.util.Comparator;
import kilim.analysis.BasicBlock;

public class Handler {
    public int from;
    public int to;
    public String type;
    public BasicBlock catchBB;
    private static Comp comp = new Comp();

    public Handler(int aFrom, int aTo, String aType, BasicBlock aCatchBB) {
        this.from = aFrom;
        this.to = aTo;
        if (aType == null) {
            aType = "java/lang/Throwable";
        }
        this.type = aType;
        this.catchBB = aCatchBB;
    }

    private int comparePos(Handler h) {
        return this.from < h.from ? -1 : (this.from == h.from ? 0 : 1);
    }

    public static ArrayList<Handler> consolidate(ArrayList<Handler> list) {
        ArrayList<Handler> newList = new ArrayList<Handler>(list.size());
        block0: for (Handler c : list) {
            for (Handler h : newList) {
                if (!(c.type.equals(h.type) & c.catchBB == h.catchBB)) continue;
                if (h.from == c.to + 1) {
                    h.from = c.from;
                    continue block0;
                }
                if (c.from != h.to + 1) continue;
                h.to = c.to;
                continue block0;
            }
            newList.add(c);
        }
        return newList;
    }

    public static Comparator<Handler> startComparator() {
        return comp;
    }

    private static class Comp
    implements Comparator<Handler> {
        private Comp() {
        }

        @Override
        public int compare(Handler o1, Handler o2) {
            return o1.comparePos(o2);
        }
    }
}

