/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kilim.KilimException;
import kilim.analysis.ClassFlow;
import kilim.analysis.ClassInfo;
import kilim.analysis.ClassWriter;
import kilim.analysis.KilimContext;
import kilim.analysis.MethodFlow;
import kilim.analysis.MethodWeaver;
import kilim.analysis.SAMweaver;
import kilim.analysis.VMType;
import kilim.analysis.ValInfo;
import kilim.analysis.ValInfoList;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;

public class ClassWeaver {
    public ClassFlow classFlow;
    List<ClassInfo> classInfoList = new LinkedList<ClassInfo>();
    static ThreadLocal<HashMap<String, ClassInfo>> stateClasses_ = new ThreadLocal<HashMap<String, ClassInfo>>(){

        @Override
        protected HashMap<String, ClassInfo> initialValue() {
            return new HashMap<String, ClassInfo>();
        }
    };
    public KilimContext context;
    ArrayList<SAMweaver> samWeavers = new ArrayList();

    public static void reset() {
        stateClasses_.set(new HashMap());
    }

    public ClassWeaver(KilimContext context, InputStream is) throws IOException {
        this.context = context;
        this.classFlow = new ClassFlow(context, is);
    }

    public void weave() throws KilimException {
        this.classFlow.analyze(false);
        if (this.needsWeaving() && this.classFlow.isPausable()) {
            boolean computeFrames = (this.classFlow.version & 0xFF) >= 50;
            ClassWriter cw = new ClassWriter(computeFrames ? 2 : 0, this.context.detector);
            this.accept((ClassVisitor)cw);
            this.addClassInfo(new ClassInfo(this.classFlow.getClassName(), cw.toByteArray()));
        }
    }

    private void accept(ClassVisitor cv) {
        AnnotationNode an;
        int i;
        ClassFlow cf = this.classFlow;
        String[] interfaces = ClassWeaver.toStringArray(cf.interfaces);
        cv.visit(cf.version, cf.access, cf.name, cf.signature, cf.superName, interfaces);
        if (cf.sourceFile != null || cf.sourceDebug != null) {
            cv.visitSource(cf.sourceFile, cf.sourceDebug);
        }
        if (cf.nestHostClass != null) {
            cv.visitNestHost(cf.nestHostClass);
        }
        if (cf.outerClass != null) {
            cv.visitOuterClass(cf.outerClass, cf.outerMethod, cf.outerMethodDesc);
        }
        if (cf.nestMembers != null) {
            for (String member : cf.nestMembers) {
                cv.visitNestMember(member);
            }
        }
        int n = cf.visibleAnnotations == null ? 0 : cf.visibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an = (AnnotationNode)cf.visibleAnnotations.get(i);
            an.accept(cv.visitAnnotation(an.desc, true));
        }
        n = cf.invisibleAnnotations == null ? 0 : cf.invisibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an = (AnnotationNode)cf.invisibleAnnotations.get(i);
            an.accept(cv.visitAnnotation(an.desc, false));
        }
        n = cf.attrs == null ? 0 : cf.attrs.size();
        for (i = 0; i < n; ++i) {
            cv.visitAttribute((Attribute)cf.attrs.get(i));
        }
        for (i = 0; i < cf.innerClasses.size(); ++i) {
            ((InnerClassNode)cf.innerClasses.get(i)).accept(cv);
        }
        for (i = 0; i < cf.fields.size(); ++i) {
            ((FieldNode)cf.fields.get(i)).accept(cv);
        }
        cv.visitField(25, "$isWoven", "Z", "Z", (Object)Boolean.TRUE);
        MethodFlow sam = this.classFlow.getSAM();
        for (i = 0; i < cf.methods.size(); ++i) {
            MethodFlow m = (MethodFlow)((Object)cf.methods.get(i));
            if (this.needsWeaving(m)) {
                boolean isSAM = sam == m;
                MethodWeaver mw = new MethodWeaver(this, this.context.detector, m, isSAM);
                mw.accept(cv);
                if (!m.isPausable()) continue;
                mw.makeNotWovenMethod(cv, m, isSAM);
                continue;
            }
            m.restoreNonInstructionNodes();
            m.accept(cv);
        }
        for (SAMweaver sw : this.samWeavers) {
            sw.accept(cv);
        }
        cv.visitEnd();
    }

    static String[] toStringArray(List list) {
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    void addClassInfo(ClassInfo ci) {
        this.classInfoList.add(ci);
    }

    public List<ClassInfo> getClassInfos() {
        return this.classInfoList;
    }

    boolean needsWeaving(MethodFlow mf) {
        if (!mf.needsWeaving()) {
            return false;
        }
        String fdesc = mf.desc.replace(")", "Lkilim/Fiber;)");
        for (MethodFlow omf : this.classFlow.getMethodFlows()) {
            if (omf == mf || !mf.name.equals(omf.name) || !fdesc.equals(omf.desc)) continue;
            return false;
        }
        return true;
    }

    boolean needsWeaving() {
        if (this.classFlow.isWoven) {
            return false;
        }
        for (MethodFlow mf : this.classFlow.getMethodFlows()) {
            if (!this.needsWeaving(mf)) continue;
            return true;
        }
        return false;
    }

    String createStateClass(ValInfoList valInfoList) {
        int[] numByType = new int[]{0, 0, 0, 0, 0};
        for (ValInfo vi : valInfoList) {
            int n = vi.vmt;
            numByType[n] = numByType[n] + 1;
        }
        String className = this.makeClassName(numByType);
        ClassInfo classInfo = null;
        classInfo = stateClasses_.get().get(className);
        if (classInfo == null) {
            ClassWriter cw = new ClassWriter(2, this.context.detector);
            cw.visit(196653, 17, className, null, "kilim/State", null);
            MethodVisitor mw = cw.visitMethod(1, "<init>", "()V", null, null);
            mw.visitVarInsn(25, 0);
            mw.visitMethodInsn(183, "kilim/State", "<init>", "()V", false);
            mw.visitInsn(177);
            mw.visitMaxs(1, 1);
            mw.visitEnd();
            for (ValInfo vi : valInfoList) {
                cw.visitField(1, vi.fieldName, vi.fieldDesc(), null, null);
            }
            classInfo = new ClassInfo(className, cw.toByteArray());
            stateClasses_.get().put(className, classInfo);
        }
        if (!this.classInfoList.contains(classInfo)) {
            this.addClassInfo(classInfo);
        }
        return className;
    }

    private String makeClassName(int[] numByType) {
        StringBuilder sb = new StringBuilder(30);
        sb.append("kilim/S_");
        for (int t = 0; t < 5; ++t) {
            int c = numByType[t];
            if (c == 0) continue;
            sb.append(VMType.abbrev[t]);
            if (c <= 1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    boolean isInterface() {
        return this.classFlow.isInterface();
    }

    SAMweaver getSAMWeaver(String owner, String methodName, String desc, boolean itf) {
        SAMweaver sw = new SAMweaver(this.context, owner, methodName, desc, itf);
        for (SAMweaver s : this.samWeavers) {
            if (!s.equals(sw)) continue;
            return s;
        }
        this.samWeavers.add(sw);
        sw.setIndex(this.samWeavers.size());
        return sw;
    }

    String getName() {
        return this.classFlow.name;
    }
}

