/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import kilim.KilimException;
import kilim.analysis.KilimContext;
import kilim.analysis.MethodFlow;
import kilim.analysis.TypeDesc;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class ClassFlow
extends ClassNode {
    ArrayList<MethodFlow> methodFlows;
    public ClassReader cr;
    String classDesc;
    private boolean isPausable;
    public boolean isWoven = false;
    public KilimContext context;
    public byte[] code;

    public ClassFlow(KilimContext context, InputStream is) throws IOException {
        super(458752);
        this.context = context;
        this.cr = new ClassReader(is);
        this.code = this.cr.b;
    }

    public ClassFlow(KilimContext context, String aClassName) throws IOException {
        super(458752);
        this.context = context;
        this.cr = new ClassReader(aClassName);
        this.code = this.cr.b;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodFlow mn = new MethodFlow(this, access, name, desc, signature, exceptions, this.context.detector);
        this.methods.add(mn);
        return mn;
    }

    public ArrayList<MethodFlow> getMethodFlows() {
        assert (this.methodFlows != null) : "ClassFlow.analyze not called";
        return this.methodFlows;
    }

    public ArrayList<MethodFlow> analyze(boolean forceAnalysis) throws KilimException {
        this.cr.accept((ClassVisitor)this, 4);
        for (Object o : this.fields) {
            FieldNode fn = (FieldNode)o;
            if (!fn.name.equals("$isWoven")) continue;
            this.isWoven = true;
            break;
        }
        if (this.isWoven && !forceAnalysis) {
            return new ArrayList<MethodFlow>();
        }
        this.cr = null;
        this.classDesc = TypeDesc.getInterned("L" + this.name + ';');
        ArrayList<MethodFlow> flows = new ArrayList<MethodFlow>(this.methods.size());
        String msg = "";
        for (Object o : this.methods) {
            try {
                MethodFlow mmf;
                MethodFlow mf = (MethodFlow)((Object)o);
                if (mf.isBridge() && (mmf = this.getOrigWithSameSig(mf)) != null) {
                    mf.setPausable(mmf.isPausable());
                }
                mf.verifyPausables();
                if (mf.isPausable()) {
                    this.isPausable = true;
                }
                if ((mf.needsWeaving() || forceAnalysis) && !mf.isAbstract()) {
                    mf.analyze();
                }
                flows.add(mf);
            }
            catch (KilimException ke) {
                msg = msg + ke.getMessage() + "\n-------------------------------------------------\n";
            }
        }
        if (msg.length() > 0) {
            throw new KilimException(msg);
        }
        this.methodFlows = flows;
        return flows;
    }

    private MethodFlow getOrigWithSameSig(MethodFlow bridgeMethod) {
        for (Object o : this.methods) {
            String bmArgs;
            String mfArgs;
            MethodFlow mf = (MethodFlow)((Object)o);
            if (mf == bridgeMethod || !mf.name.equals(bridgeMethod.name) || !(mfArgs = mf.desc.substring(0, mf.desc.indexOf(41))).equals(bmArgs = bridgeMethod.desc.substring(0, bridgeMethod.desc.indexOf(41)))) continue;
            return mf;
        }
        return null;
    }

    public String getClassDescriptor() {
        return this.classDesc;
    }

    public String getClassName() {
        return this.name.replace('/', '.');
    }

    public boolean isPausable() {
        this.getMethodFlows();
        return this.isPausable;
    }

    boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    boolean isJava7() {
        return (this.version & 0xFF) < 52;
    }

    public MethodFlow getSAM() {
        if (!this.isInterface() || this.isJava7()) {
            return null;
        }
        MethodFlow sam = null;
        for (MethodFlow mf : this.methodFlows) {
            if (!mf.isAbstract()) continue;
            if (sam != null) {
                return null;
            }
            sam = mf;
        }
        return sam;
    }
}

