/*
 * Decompiled with CFR 0.152.
 */
package kilim.analysis;

import java.util.BitSet;
import java.util.Collections;
import kilim.analysis.BasicBlock;
import kilim.analysis.ClassWeaver;
import kilim.analysis.Frame;
import kilim.analysis.MethodWeaver;
import kilim.analysis.SAMweaver;
import kilim.analysis.TypeDesc;
import kilim.analysis.Usage;
import kilim.analysis.VMType;
import kilim.analysis.ValInfo;
import kilim.analysis.ValInfoList;
import kilim.analysis.Value;
import kilim.mirrors.CachedClassMirrors;
import kilim.mirrors.ClassMirrorNotFoundException;
import kilim.mirrors.Detector;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;

public class CallWeaver {
    private MethodWeaver methodWeaver;
    BasicBlock bb;
    private LabelNode resumeLabel;
    LabelNode callLabel;
    private ValInfoList valInfoList;
    BitSet varUsage;
    int numVars;
    private String stateClassName;
    int numArgs = -1;
    private Detector detector;

    public CallWeaver(MethodWeaver mw, Detector d, BasicBlock aBB) {
        this.detector = d;
        this.methodWeaver = mw;
        this.bb = aBB;
        this.callLabel = this.bb.startLabel;
        this.varUsage = new BitSet(2 * this.bb.flow.maxLocals);
        this.resumeLabel = this.bb.flow.getLabelAt(this.bb.startPos + 1);
        if (this.resumeLabel == null) {
            this.resumeLabel = new LabelNode();
        }
        this.assignRegisters();
        this.stateClassName = this.createStateClass();
        this.methodWeaver.ensureMaxStack(this.getNumBottom() + 3);
    }

    private void assignRegisters() {
        int i;
        Frame f = this.bb.startFrame;
        MethodWeaver mw = this.methodWeaver;
        this.varUsage.set(mw.getFiberVar());
        this.numVars = mw.getFiberVar() + 1;
        mw.ensureMaxVars(this.numVars);
        Usage u = this.bb.usage;
        this.valInfoList = new ValInfoList();
        this.varUsage.set(0, f.getMaxLocals());
        int n = i = this.bb.flow.isStatic() ? 0 : 1;
        while (i < f.getMaxLocals()) {
            Value v = f.getLocal(i);
            if (u.isLiveIn(i) && !v.isConstant() && !this.valInfoList.contains(v)) {
                ValInfo vi = new ValInfo(v);
                vi.var = i;
                this.valInfoList.add(vi);
            }
            ++i;
        }
        int numBottom = this.getNumBottom();
        for (i = 0; i < numBottom; ++i) {
            Value v = f.getStack(i);
            if (v.isConstant() || this.valInfoList.contains(v)) continue;
            ValInfo vi = new ValInfo(v);
            this.valInfoList.add(vi);
        }
        Collections.sort(this.valInfoList);
        int fieldNum = 0;
        for (ValInfo vi : this.valInfoList) {
            vi.fieldName = "f" + fieldNum++;
        }
    }

    int getStackLen() {
        return this.bb.startFrame.getStackLen();
    }

    int getNumArgs() {
        if (this.numArgs == -1) {
            this.numArgs = TypeDesc.getNumArgumentTypes(this.getMethodInsn().desc) + (this.isStaticCall() ? 0 : 1);
        }
        return this.numArgs;
    }

    final boolean isStaticCall() {
        return this.getMethodInsn().getOpcode() == 184;
    }

    final MethodInsnNode getMethodInsn() {
        return (MethodInsnNode)this.bb.getInstruction(this.bb.startPos);
    }

    int getNumBottom() {
        return this.getStackLen() - this.getNumArgs();
    }

    void genRewind(MethodVisitor mv) {
        int spos;
        Value v;
        Frame f = this.bb.startFrame;
        for (int i = this.methodWeaver.getNumWordsInArg(); i < f.getMaxLocals(); i += v.isCategory2() ? 2 : 1) {
            v = f.getLocal(i);
            if (v.getTypeDesc() == "UNDEFINED") continue;
            int vmt = VMType.toVmType(v.getTypeDesc());
            mv.visitInsn(VMType.constInsn[vmt]);
            VMType.storeVar(mv, vmt, i);
        }
        int numBottom = this.getNumBottom();
        for (spos = 0; spos < numBottom; ++spos) {
            Value v2 = f.getStack(spos);
            if (v2.isConstant()) {
                mv.visitInsn(VMType.constInsn[VMType.toVmType(v2.getTypeDesc())]);
                continue;
            }
            ValInfo vi = this.valInfoList.find(v2);
            mv.visitInsn(VMType.constInsn[vi.vmt]);
        }
        if (!this.isStaticCall()) {
            Value v3 = f.getStack(numBottom);
            if (!this.methodWeaver.isStatic() && f.getLocal(0) == v3) {
                mv.visitVarInsn(25, 0);
            } else {
                VMType.loadVar(mv, 0, this.methodWeaver.getFiberVar());
                mv.visitMethodInsn(182, "kilim/Fiber", "getCallee", "()Ljava/lang/Object;", false);
                mv.visitTypeInsn(192, this.getReceiverTypename());
            }
            ++spos;
        }
        int len = f.getStackLen();
        while (spos < len) {
            Value v4 = f.getStack(spos);
            int vmt = VMType.toVmType(v4.getTypeDesc());
            mv.visitInsn(VMType.constInsn[vmt]);
            ++spos;
        }
        mv.visitJumpInsn(167, this.callLabel.getLabel());
    }

    void genCall(MethodVisitor mv) {
        mv.visitLabel(this.callLabel.getLabel());
        VMType.loadVar(mv, 0, this.methodWeaver.getFiberVar());
        mv.visitMethodInsn(182, "kilim/Fiber", "down", "()Lkilim/Fiber;", false);
        MethodInsnNode mi = this.getMethodInsn();
        if (this.isSAM(mi)) {
            ClassWeaver cw = this.methodWeaver.getClassWeaver();
            SAMweaver sw = cw.getSAMWeaver(mi.owner, mi.name, mi.desc, mi.itf);
            mi = new MethodInsnNode(184, cw.getName(), sw.getShimMethodName(), sw.getShimDesc(), cw.isInterface());
        }
        if (mi.desc.indexOf("Lkilim/Fiber;)") == -1) {
            mi.desc = mi.desc.replace(")", "Lkilim/Fiber;)");
        }
        mi.accept(mv);
    }

    boolean isSAM(MethodInsnNode mi) {
        Detector det = this.detector;
        int count = 0;
        boolean match = false;
        try {
            CachedClassMirrors.ClassMirror cm = det.classForName(mi.owner);
            if (cm.version() < 52) {
                return false;
            }
            String fdesc = mi.desc.replace(")", "Lkilim/Fiber;)");
            for (CachedClassMirrors.MethodMirror m : cm.getDeclaredMethods()) {
                if (!(count < 2 & (m.getModifiers() & 0x400) > 0)) continue;
                ++count;
                String desc = m.getMethodDescriptor();
                if (!(m.getName().equals(mi.name) & (desc.equals(mi.desc) | desc.equals(fdesc)))) continue;
                match = true;
            }
        }
        catch (ClassMirrorNotFoundException classMirrorNotFoundException) {
            // empty catch block
        }
        return match && count == 1;
    }

    void genPostCall(MethodVisitor mv) {
        VMType.loadVar(mv, 0, this.methodWeaver.getFiberVar());
        mv.visitMethodInsn(182, "kilim/Fiber", "up", "()I", false);
        LabelNode restoreLabel = new LabelNode();
        LabelNode saveLabel = new LabelNode();
        LabelNode unwindLabel = new LabelNode();
        LabelNode[] labels = new LabelNode[]{this.resumeLabel, restoreLabel, saveLabel, unwindLabel};
        new TableSwitchInsnNode(0, 3, this.resumeLabel, labels).accept(mv);
        this.genSave(mv, saveLabel);
        this.genUnwind(mv, unwindLabel);
        this.genRestore(mv, restoreLabel);
        this.resumeLabel.accept(mv);
    }

    private void genUnwind(MethodVisitor mv, LabelNode unwindLabel) {
        unwindLabel.accept(mv);
        String rdesc = this.getReturnType();
        if (rdesc != "V") {
            mv.visitInsn(TypeDesc.isDoubleWord(rdesc) ? 88 : 87);
        }
        Frame f = this.bb.startFrame;
        for (int i = this.getNumBottom() - 1; i >= 0; --i) {
            mv.visitInsn(f.getStack(i).isCategory1() ? 87 : 88);
        }
        rdesc = TypeDesc.getReturnTypeDesc(this.bb.flow.desc);
        if (rdesc != "V") {
            int vmt = VMType.toVmType(rdesc);
            mv.visitInsn(VMType.constInsn[vmt]);
            mv.visitInsn(VMType.retInsn[vmt]);
        } else {
            mv.visitInsn(177);
        }
    }

    private String getReturnType() {
        return TypeDesc.getReturnTypeDesc(this.getMethodInsn().desc);
    }

    private void genSave(MethodVisitor mv, LabelNode saveLabel) {
        saveLabel.accept(mv);
        Frame f = this.bb.startFrame;
        String retType = this.getReturnType();
        if (retType != "V") {
            mv.visitInsn(TypeDesc.isDoubleWord(retType) ? 88 : 87);
        }
        mv.visitTypeInsn(187, this.stateClassName);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, this.stateClassName, "<init>", "()V", false);
        int stateVar = this.allocVar(1);
        VMType.storeVar(mv, 0, stateVar);
        if (!this.bb.flow.isStatic()) {
            VMType.loadVar(mv, 0, stateVar);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(181, "kilim/State", "self", "Ljava/lang/Object;");
        }
        int pc = this.methodWeaver.getPC(this);
        VMType.loadVar(mv, 0, stateVar);
        if (pc < 6) {
            mv.visitInsn(3 + pc);
        } else {
            mv.visitIntInsn(16, pc);
        }
        mv.visitFieldInsn(181, "kilim/State", "pc", "I");
        for (int i = this.getNumBottom() - 1; i >= 0; --i) {
            Value v = f.getStack(i);
            ValInfo vi = this.valInfoList.find(v);
            if (vi == null) {
                mv.visitInsn(v.category() == 2 ? 88 : 87);
                continue;
            }
            int var = this.allocVar(vi.val.category());
            VMType.storeVar(mv, vi.vmt, var);
            VMType.loadVar(mv, 0, stateVar);
            VMType.loadVar(mv, vi.vmt, var);
            mv.visitFieldInsn(181, this.stateClassName, vi.fieldName, vi.fieldDesc());
            this.releaseVar(var, vi.val.category());
        }
        for (ValInfo vi : this.valInfoList) {
            if (vi.var == -1) continue;
            VMType.loadVar(mv, 0, stateVar);
            VMType.loadVar(mv, vi.vmt, vi.var);
            mv.visitFieldInsn(181, this.stateClassName, vi.fieldName, vi.fieldDesc());
        }
        VMType.loadVar(mv, 0, this.methodWeaver.getFiberVar());
        VMType.loadVar(mv, 0, stateVar);
        mv.visitMethodInsn(182, "kilim/Fiber", "setState", "(Lkilim/State;)V", false);
        this.releaseVar(stateVar, 1);
        retType = TypeDesc.getReturnTypeDesc(this.bb.flow.desc);
        if (retType == "V") {
            mv.visitInsn(177);
        } else {
            int vmt = VMType.toVmType(retType);
            mv.visitInsn(VMType.constInsn[vmt]);
            mv.visitInsn(VMType.retInsn[vmt]);
        }
    }

    private void genRestore(MethodVisitor mv, LabelNode restoreLabel) {
        Value v;
        int i;
        restoreLabel.accept(mv);
        Frame f = this.bb.startFrame;
        int numBottom = this.getNumBottom();
        int retVar = -1;
        int retctype = -1;
        if (numBottom > 0) {
            String retType = this.getReturnType();
            if (retType != "V") {
                retctype = VMType.toVmType(retType);
                retVar = this.allocVar(VMType.category[retctype]);
                VMType.storeVar(mv, retctype, retVar);
            }
            for (i = numBottom - 1; i >= 0; --i) {
                v = f.getStack(i);
                int insn = v.isCategory1() ? 87 : 88;
                mv.visitInsn(insn);
            }
        }
        int stateVar = -1;
        if (this.valInfoList.size() > 0) {
            stateVar = this.allocVar(1);
        }
        this.genRestoreVars(mv, stateVar);
        for (i = 0; i < numBottom; ++i) {
            v = f.getStack(i);
            if (v.isConstant()) {
                this.loadConstant(mv, v);
                continue;
            }
            ValInfo vi = this.valInfoList.find(v);
            if (vi.var == -1) {
                VMType.loadVar(mv, 0, stateVar);
                mv.visitFieldInsn(180, this.stateClassName, vi.fieldName, vi.fieldDesc());
                this.checkcast(mv, v);
                continue;
            }
            VMType.loadVar(mv, vi.vmt, vi.var);
        }
        if (numBottom > 0 && retVar != -1) {
            VMType.loadVar(mv, retctype, retVar);
        }
        this.releaseVar(stateVar, 1);
        if (retctype != -1) {
            this.releaseVar(retVar, VMType.category[retctype]);
        }
    }

    void genRestoreEx(MethodVisitor mv, LabelNode restoreLabel) {
        restoreLabel.accept(mv);
        int stateVar = -1;
        if (this.valInfoList.size() > 0) {
            stateVar = this.allocVar(1);
        }
        this.genRestoreVars(mv, stateVar);
        this.releaseVar(stateVar, 1);
    }

    private void genRestoreVars(MethodVisitor mv, int stateVar) {
        int i;
        Frame f = this.bb.startFrame;
        if (this.valInfoList.size() > 0) {
            VMType.loadVar(mv, 0, this.methodWeaver.getFiberVar());
            mv.visitFieldInsn(180, "kilim/Fiber", "curState", "Lkilim/State;");
            if (!this.stateClassName.equals("kilim/State")) {
                mv.visitTypeInsn(192, this.stateClassName);
            }
            VMType.storeVar(mv, 0, stateVar);
        }
        Usage u = this.bb.usage;
        int len = f.getMaxLocals();
        int n = i = this.bb.flow.isStatic() ? 0 : 1;
        while (i < len) {
            if (u.isLiveIn(i)) {
                Value v = f.getLocal(i);
                int vmt = VMType.toVmType(v.getTypeDesc());
                if (v.isConstant()) {
                    this.loadConstant(mv, v);
                } else {
                    ValInfo vi = this.valInfoList.find(v);
                    if (vi.var == i) {
                        VMType.loadVar(mv, 0, stateVar);
                        mv.visitFieldInsn(180, this.stateClassName, vi.fieldName, vi.fieldDesc());
                        this.checkcast(mv, v);
                    } else {
                        assert (vi.var < i);
                        VMType.loadVar(mv, vi.vmt, vi.var);
                    }
                }
                VMType.storeVar(mv, vmt, i);
            }
            ++i;
        }
        this.releaseVar(stateVar, 1);
    }

    private String getReceiverTypename() {
        MethodInsnNode min = this.getMethodInsn();
        return min.owner;
    }

    private void checkcast(MethodVisitor mv, Value v) {
        String valType = v.getTypeDesc();
        int vmt = VMType.toVmType(valType);
        switch (vmt) {
            case 0: {
                if (valType == "Ljava/lang/Object;" || valType == "NULL") {
                    return;
                }
                mv.visitTypeInsn(192, TypeDesc.getInternalName(valType));
                break;
            }
            case 1: {
                if (valType == "I") {
                    return;
                }
                int insn = 0;
                if (valType == "S") {
                    insn = 147;
                } else if (valType == "B") {
                    insn = 145;
                } else if (valType == "C") {
                    insn = 146;
                } else assert (valType == "Z");
                mv.visitInsn(insn);
                break;
            }
        }
    }

    private void loadConstant(MethodVisitor mv, Value v) {
        if (v.getTypeDesc() == "NULL") {
            mv.visitInsn(1);
            return;
        }
        Object c = v.getConstVal();
        if (c instanceof Integer) {
            int i = (Integer)c;
            if (i > -1 && i <= 5) {
                mv.visitInsn(i + 1 + 2);
                return;
            }
            if (i >= -128 && i <= 127) {
                mv.visitIntInsn(16, i);
                return;
            }
            if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
                mv.visitIntInsn(17, i);
                return;
            }
        } else if (c instanceof Float) {
            Float f = Float.valueOf(((Float)c).floatValue());
            int insn = 0;
            if ((double)f.floatValue() == 0.0) {
                insn = 11;
            } else if ((double)f.floatValue() == 1.0) {
                insn = 12;
            } else if ((double)f.floatValue() == 2.0) {
                insn = 13;
            }
            if (insn != 0) {
                mv.visitInsn(insn);
                return;
            }
        } else if (c instanceof Long) {
            Long l = (long)((Long)c);
            int insn = 0;
            if (l == 0L) {
                insn = 9;
            } else if (l == 1L) {
                insn = 10;
            }
            if (insn != 0) {
                mv.visitInsn(insn);
                return;
            }
        } else if (c instanceof Double) {
            Double d = (double)((Double)c);
            int insn = 0;
            if (d == 0.0) {
                insn = 14;
            } else if (d == 1.0) {
                insn = 15;
            }
            if (insn != 0) {
                mv.visitInsn(insn);
                return;
            }
        }
        mv.visitLdcInsn(c);
    }

    private String createStateClass() {
        return this.valInfoList.size() == 0 ? "kilim/State" : this.methodWeaver.createStateClass(this.valInfoList);
    }

    private int allocVar(int size) {
        int var = 0;
        while (this.varUsage.get(var) || size != 1 && this.varUsage.get(var + 1)) {
            ++var;
        }
        this.varUsage.set(var);
        if (size == 2) {
            this.varUsage.set(var + 1);
            this.methodWeaver.ensureMaxVars(var + 2);
        } else {
            this.methodWeaver.ensureMaxVars(var + 1);
        }
        return var;
    }

    private void releaseVar(int var, int size) {
        if (var == -1) {
            return;
        }
        this.varUsage.clear(var);
        if (size == 2) {
            this.varUsage.clear(var + 1);
        }
    }

    BasicBlock getBasicBlock() {
        return this.bb;
    }
}

