/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kilim.Constants;
import kilim.Continuation;
import kilim.Event;
import kilim.EventPublisher;
import kilim.EventSubscriber;
import kilim.ExitMsg;
import kilim.Fiber;
import kilim.Mailbox;
import kilim.NotPausable;
import kilim.Pausable;
import kilim.PauseReason;
import kilim.Scheduler;
import kilim.State;
import kilim.TaskDoneReason;
import kilim.YieldReason;
import kilim.timerservice.Timer;

public abstract class Task<TT>
implements Runnable,
EventSubscriber,
Fiber.Worker {
    static PauseReason yieldReason = new YieldReason();
    public final int id;
    static final AtomicInteger idSource = new AtomicInteger();
    protected Fiber fiber;
    protected PauseReason pauseReason;
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected volatile boolean done = false;
    volatile int preferredResumeThread = -1;
    private int tid;
    int numActivePins;
    private LinkedList<Mailbox<ExitMsg<TT>>> exitMBs;
    protected Scheduler scheduler;
    public volatile Object exitResult = "OK";
    public Timer timer;
    private static boolean debugRunning = false;
    private static Fiber.MethodRef runnerInfo = new Fiber.MethodRef("kilim.Task", "run");
    public static final boolean $isWoven = true;

    public Task() {
        this.id = idSource.incrementAndGet();
        this.fiber = new Fiber(this);
        this.timer = new Timer(this);
    }

    Task(boolean dummy) {
        this.id = idSource.incrementAndGet();
    }

    public int id() {
        return this.id;
    }

    public synchronized Task<TT> setScheduler(Scheduler s) {
        this.scheduler = s;
        return this;
    }

    public synchronized Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * WARNING - void declaration
     */
    public void resumeOnScheduler(Scheduler scheduler, Fiber fiber) throws Pausable {
        switch (fiber.pc) {
            default: {
                fiber.wrongPC();
            }
            case 1: {
                break;
            }
            case 0: {
                void s;
                if (this.scheduler == s) {
                    return;
                }
                this.scheduler = s;
            }
        }
        Task.yield(fiber.down());
        switch (fiber.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public void resumeOnScheduler(Scheduler scheduler) throws Pausable {
        Task.errNotWoven();
    }

    public Task<TT> start() {
        if (this.scheduler == null) {
            this.setScheduler(Scheduler.getDefaultScheduler());
        }
        this.resume();
        return this;
    }

    Fiber.MethodRef getRunnerInfo() {
        return runnerInfo;
    }

    private static boolean skipInvoke(String klass, String name) {
        return klass.startsWith("sun.reflect.") | klass.startsWith("jdk.internal.reflect.") | "java.lang.reflect.Method".equals(klass) & "invoke".equals(name);
    }

    public static int getStackDepth(Task task) {
        Fiber.MethodRef mr = task.getRunnerInfo();
        StackTraceElement[] stes = new Exception().getStackTrace();
        int len = stes.length;
        int num = 0;
        for (int i = 0; i < len; ++i) {
            StackTraceElement ste = stes[i];
            String name = ste.getMethodName();
            String klass = ste.getClassName();
            if (ste.getLineNumber() < 0 & Constants.Util.isSamShim(name) || Task.skipInvoke(klass, name)) continue;
            ++num;
            if (!(name.equals(mr.methodname) & klass.equals(mr.classname))) continue;
            return num - 2;
        }
        throw new AssertionError((Object)"Expected task to be run by WorkerThread");
    }

    boolean checkTimeout() {
        return this.timer.getExecutionTime() == -2L;
    }

    @Override
    public void onEvent(EventPublisher ep, Event e) {
        if (e == Timer.timedOut) {
            this.timer.setLiteral(-2L);
        }
        boolean sched = this.resume();
    }

    public Thread getExecutionThread() {
        return Thread.currentThread();
    }

    public boolean resume() {
        if (this.scheduler == null) {
            return false;
        }
        boolean doSchedule = false;
        if (!this.done) {
            if (this.running.compareAndSet(false, true)) {
                doSchedule = true;
            } else if (debugRunning) {
                System.out.println("Task.pause.running: " + this);
            }
        }
        if (doSchedule) {
            if (this.preferredResumeThread == -1) {
                this.scheduler.schedule(this);
            } else {
                this.scheduler.schedule(this.preferredResumeThread, this);
            }
        }
        return doSchedule;
    }

    public synchronized void informOnExit(Mailbox<ExitMsg<TT>> exit) {
        if (this.done) {
            exit.putnb(new ExitMsg<Object>(this, this.exitResult));
            return;
        }
        if (this.exitMBs == null) {
            this.exitMBs = new LinkedList();
        }
        this.exitMBs.add(exit);
    }

    public static Task getCurrentTask(Fiber fiber) throws Pausable {
        return null;
    }

    public static Task getCurrentTask() throws Pausable {
        Task.errNotWoven();
        return null;
    }

    public static void exit(Object aExitValue) throws Pausable {
    }

    public static void exit(Object aExitValue, Fiber f) {
        assert (f.pc == 0) : "f.pc != 0";
        f.task.setPauseReason(new TaskDoneReason(aExitValue));
        f.togglePause();
    }

    public static void errorExit(Throwable ex) throws Pausable {
    }

    public static void errorExit(Throwable ex, Fiber f) {
        assert (f.pc == 0) : "fc.pc != 0";
        f.task.setPauseReason(new TaskDoneReason(ex));
        f.togglePause();
    }

    public static void errNotWoven() {
        System.err.println("############################################################");
        System.err.println("Task has either not been woven or the classpath is incorrect");
        System.err.println("############################################################");
        Thread.dumpStack();
        System.exit(0);
    }

    public static void errNotWoven(Task t) {
        System.err.println("############################################################");
        System.err.println("Task " + t.getClass() + " has either not been woven or the classpath is incorrect");
        System.err.println("############################################################");
        Thread.dumpStack();
        System.exit(0);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invoke(Method method, Object object, Object[] objectArray, Fiber fiber) throws Pausable, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object obj;
        Object[] fargs;
        Method method2;
        Fiber fiber2 = fiber;
        Fiber f = fiber2.task.fiber;
        if (f.pc == 0) {
            void args;
            method2 = Task.getWovenMethod(method2);
            if (args == null) {
                fargs = new Object[1];
            } else {
                fargs = new Object[((void)args).length + 1];
                System.arraycopy(args, 0, fargs, 0, ((void)args).length);
            }
            fargs[fargs.length - 1] = f;
        } else {
            ArgState as = (ArgState)f.getState();
            method2 = (Method)as.mthd;
            obj = as.obj;
            fargs = as.fargs;
        }
        f.down();
        Object ret = method2.invoke(obj, fargs);
        switch (f.up()) {
            case 0: 
            case 1: {
                return ret;
            }
            case 2: {
                ArgState as = new ArgState();
                as.obj = obj;
                as.fargs = fargs;
                as.pc = 1;
                as.mthd = method2;
                f.setState(as);
                return null;
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalAccessException("Internal Error");
    }

    public static Object invoke(Method method, Object object, Object ... objectArray) throws Pausable, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Task.errNotWoven();
        return null;
    }

    private static Method getWovenMethod(Method m) {
        Class<?>[] ptypes = m.getParameterTypes();
        if (ptypes.length <= 0 || !ptypes[ptypes.length - 1].getName().equals("kilim.Fiber")) {
            boolean found = false;
            block0: for (Method wm : m.getDeclaringClass().getDeclaredMethods()) {
                Class<?>[] wptypes;
                if (wm == m || !wm.getName().equals(m.getName()) || (wptypes = wm.getParameterTypes()).length != ptypes.length + 1 || !wptypes[wptypes.length - 1].getName().equals("kilim.Fiber")) continue;
                for (int i = 0; i < ptypes.length; ++i) {
                    if (ptypes[i] != wptypes[i]) continue block0;
                }
                m = wm;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Found no pausable method corresponding to supplied method: " + m);
            }
        }
        return m;
    }

    public static void sleep(long l, Fiber fiber) throws Pausable {
        long l2;
        Mailbox mailbox;
        Fiber fiber2 = fiber;
        switch (fiber2.pc) {
            default: {
                fiber2.wrongPC();
            }
            case 1: {
                fiber = null;
                mailbox = (Mailbox)fiber2.getCallee();
                l2 = 0L;
                break;
            }
            case 0: {
                long millis;
                Mailbox sleepmb;
                mailbox = sleepmb = new Mailbox(1);
                l2 = millis;
            }
        }
        Object t = mailbox.get(l2, fiber2.down());
        switch (fiber2.up()) {
            case 2: {
                State state = new State();
                state.pc = 1;
                fiber2.setState(state);
                return;
            }
            case 3: {
                return;
            }
        }
    }

    public static void sleep(long l) throws Pausable {
        Task.errNotWoven();
    }

    public static void shutdown() {
    }

    public static void yield() throws Pausable {
        Task.errNotWoven();
    }

    public static void yield(Fiber f) {
        if (f.task instanceof Continuation.FakeTask) {
            f.togglePause();
            return;
        }
        if (f.pc == 0) {
            f.task.setPauseReason(yieldReason);
        } else {
            f.task.setPauseReason(null);
        }
        f.togglePause();
        f.task.checkKill();
    }

    public static void pause(PauseReason pauseReason) throws Pausable {
        Task.errNotWoven();
    }

    public static void pause(PauseReason pauseReason, Fiber f) {
        if (f.pc == 0) {
            f.task.setPauseReason(pauseReason);
        } else {
            f.task.setPauseReason(null);
        }
        f.togglePause();
        f.task.checkKill();
    }

    @Override
    public void execute() throws Pausable, Exception {
        Task.errNotWoven(this);
    }

    @Override
    public void execute(Fiber f) throws Exception {
        Task.errNotWoven(this);
    }

    public String toString() {
        return "" + this.id + "(running=" + this.running + ",pr=" + this.pauseReason + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        Task task = this;
        synchronized (task) {
            return "" + this.id + "(running=" + this.running + ", pr=" + this.pauseReason + ")";
        }
    }

    public void pinToThread() {
        ++this.numActivePins;
    }

    public void unpinFromThread() {
        --this.numActivePins;
    }

    protected final void setPauseReason(PauseReason pr) {
        this.pauseReason = pr;
    }

    public final PauseReason getPauseReason() {
        return this.pauseReason;
    }

    public boolean isDone() {
        return this.done;
    }

    protected void setTid(int tid) {
        this.tid = tid;
    }

    public int getTid() {
        return this.tid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws NotPausable {
        Scheduler.setCurrentTask(this);
        Fiber f = this.fiber;
        boolean isDone = false;
        try {
            assert (this.preferredResumeThread == -1 || this.preferredResumeThread == this.tid) : "Resumed " + this.id + " in incorrect thread. ";
            this.execute(f.begin());
            isDone = f.end() || this.pauseReason instanceof TaskDoneReason;
        }
        catch (Throwable th) {
            this.getScheduler().log(th);
            this.setPauseReason(new TaskDoneReason(th));
            isDone = true;
        }
        if (isDone) {
            if (this.numActivePins > 0) {
                throw new AssertionError((Object)"Task ended but has active locks");
            }
            if (this.pauseReason instanceof TaskDoneReason) {
                this.exitResult = ((TaskDoneReason)this.pauseReason).exitObj;
            }
            this.preferredResumeThread = -1;
            Task th = this;
            synchronized (th) {
                this.done = true;
                if (this.exitMBs != null) {
                    ExitMsg<Object> msg = new ExitMsg<Object>(this, this.exitResult);
                    for (Mailbox mailbox : this.exitMBs) {
                        mailbox.putnb(msg);
                    }
                }
            }
        } else {
            if (this.tid >= 0) {
                if (this.numActivePins > 0) {
                    this.preferredResumeThread = this.tid;
                } else {
                    assert (this.numActivePins == 0) : "numActivePins == " + this.numActivePins;
                    this.preferredResumeThread = -1;
                }
            }
            PauseReason pr = this.pauseReason;
            this.running.set(false);
            if (!pr.isValid(this)) {
                this.resume();
            }
        }
    }

    public ExitMsg<TT> joinb() {
        Mailbox<ExitMsg<TT>> mb = new Mailbox<ExitMsg<TT>>();
        this.informOnExit(mb);
        return mb.getb();
    }

    public ExitMsg<TT> join(Fiber fiber) throws Pausable {
        Mailbox<ExitMsg<TT>> mailbox;
        Fiber fiber2 = fiber;
        switch (fiber2.pc) {
            default: {
                fiber2.wrongPC();
            }
            case 1: {
                fiber = null;
                mailbox = (Mailbox<ExitMsg<TT>>)fiber2.getCallee();
                break;
            }
            case 0: {
                Mailbox<ExitMsg<TT>> mb = new Mailbox<ExitMsg<TT>>();
                this.informOnExit(mb);
                mailbox = mb;
            }
        }
        switch (fiber2.up()) {
            case 2: {
                State state = new State();
                state.self = this;
                state.pc = 1;
                fiber2.setState(state);
                return null;
            }
            case 3: {
                return null;
            }
        }
        return mailbox.get(fiber2.down());
    }

    public ExitMsg<TT> join() throws Pausable {
        Task.errNotWoven();
        return null;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.id;
    }

    public void checkKill() {
    }

    public boolean getState() {
        return this.running.get();
    }

    public static Task fork(Pausable.Fork body) {
        return new Fork(body).start();
    }

    public static Task fork(Pausable.Fork10 body) {
        return new Fork(body).start();
    }

    public static <TT> Spawn<TT> spawn(Pausable.Spawn<TT> body) {
        Spawn<TT> spawn = new Spawn<TT>(body);
        spawn.start();
        return spawn;
    }

    public static <TT> Spawn<TT> spawn(Pausable.Spawn10<TT> body) {
        Spawn<TT> spawn = new Spawn<TT>(body);
        spawn.start();
        return spawn;
    }

    public static Invoke spawn(Method method, Object obj, Object ... args) {
        Invoke spawn = new Invoke(method, obj, args);
        spawn.start();
        return spawn;
    }

    public static void idledown() {
        if (Scheduler.defaultScheduler != null) {
            Scheduler.defaultScheduler.idledown();
        }
    }

    public static class Invoke<TT>
    extends Task<TT> {
        Method method;
        Object obj;
        Object[] args;
        public static final boolean $isWoven = true;

        public Invoke(Method method, Object obj, Object ... args) {
            this.method = method;
            this.obj = obj;
            this.args = args;
        }

        @Override
        public void execute(Fiber fiber) throws Pausable, Exception {
            Object object;
            Fiber fiber2;
            block13: {
                Object val;
                Object[] objectArray;
                Object object2;
                Method method;
                fiber2 = fiber;
                switch (fiber2.pc) {
                    default: {
                        fiber2.wrongPC();
                    }
                    case 1: {
                        method = null;
                        object2 = null;
                        objectArray = null;
                        break;
                    }
                    case 2: {
                        fiber = null;
                        object = null;
                        break block13;
                    }
                    case 0: {
                        method = this.method;
                        object2 = this.obj;
                        objectArray = this.args;
                    }
                }
                switch (fiber2.up()) {
                    case 2: {
                        State state = new State();
                        state.self = this;
                        state.pc = 1;
                        fiber2.setState(state);
                        return;
                    }
                    case 3: {
                        return;
                    }
                }
                object = val = Task.invoke(method, object2, objectArray, fiber2.down());
            }
            Invoke.exit(object, fiber2.down());
            switch (fiber2.up()) {
                case 2: {
                    State state = new State();
                    state.self = this;
                    state.pc = 2;
                    fiber2.setState(state);
                    return;
                }
                case 3: {
                    return;
                }
            }
        }

        @Override
        public void execute() throws Pausable, Exception {
            Task.errNotWoven();
        }
    }

    public static class Fork
    extends Task {
        Pausable.Fork body;
        public static final boolean $isWoven = true;

        public Fork(Pausable.Fork body) {
            this.body = body;
        }

        public Fork(Pausable.Fork10 body) {
            this.body = body;
        }

        @Override
        public void execute(Fiber fiber) throws Pausable, Exception {
            Pausable.Fork fork;
            switch (fiber.pc) {
                default: {
                    fiber.wrongPC();
                }
                case 1: {
                    fork = (Pausable.Fork)fiber.getCallee();
                    break;
                }
                case 0: {
                    fork = this.body;
                }
            }
            Fork.$shim$1(fork, fiber.down());
            switch (fiber.up()) {
                case 2: {
                    State state = new State();
                    state.self = this;
                    state.pc = 1;
                    fiber.setState(state);
                    return;
                }
                case 3: {
                    return;
                }
            }
        }

        @Override
        public void execute() throws Pausable, Exception {
            Task.errNotWoven();
        }

        private static void $shim$1(Pausable.Fork fork, Fiber fiber) throws Pausable, Exception {
            fork.execute(fiber);
            fiber.setCallee(fork);
        }
    }

    public static class Spawn<TT>
    extends Task<TT> {
        Pausable.Spawn<TT> body;
        public static final boolean $isWoven = true;

        public Spawn() {
        }

        public Spawn(Pausable.Spawn<TT> body) {
            this.body = body;
        }

        public Spawn(Pausable.Spawn10<TT> body) {
            this.body = body;
        }

        @Override
        public void execute(Fiber fiber) throws Pausable, Exception {
            Object object;
            Fiber fiber2;
            block13: {
                Object val;
                Pausable.Spawn spawn;
                fiber2 = fiber;
                switch (fiber2.pc) {
                    default: {
                        fiber2.wrongPC();
                    }
                    case 1: {
                        spawn = (Pausable.Spawn)fiber2.getCallee();
                        break;
                    }
                    case 2: {
                        fiber = null;
                        object = null;
                        break block13;
                    }
                    case 0: {
                        spawn = this.body;
                    }
                }
                switch (fiber2.up()) {
                    case 2: {
                        State state = new State();
                        state.self = this;
                        state.pc = 1;
                        fiber2.setState(state);
                        return;
                    }
                    case 3: {
                        return;
                    }
                }
                object = val = Spawn.$shim$1(spawn, fiber2.down());
            }
            Spawn.exit(object, fiber2.down());
            switch (fiber2.up()) {
                case 2: {
                    State state = new State();
                    state.self = this;
                    state.pc = 2;
                    fiber2.setState(state);
                    return;
                }
                case 3: {
                    return;
                }
            }
        }

        @Override
        public void execute() throws Pausable, Exception {
            Task.errNotWoven();
        }

        private static Object $shim$1(Pausable.Spawn spawn, Fiber fiber) throws Pausable, Exception {
            Object TT = spawn.execute(fiber);
            fiber.setCallee(spawn);
            return TT;
        }
    }

    static class ArgState
    extends State {
        Object mthd;
        Object obj;
        Object[] fargs;

        ArgState() {
        }
    }
}

