/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.util.concurrent.atomic.AtomicBoolean;
import kilim.AffineThreadPool;
import kilim.Task;
import kilim.nio.NioSelectorScheduler;
import kilim.timerservice.Timer;
import kilim.timerservice.TimerService;

public class Scheduler {
    private static final int defaultQueueSize_ = Integer.MAX_VALUE;
    public static volatile Scheduler defaultScheduler = null;
    public static int defaultNumberThreads;
    private static final ThreadLocal<Task> taskMgr_;
    private int numThreads;
    private AffineThreadPool affinePool_;
    protected AtomicBoolean shutdown = new AtomicBoolean(false);
    public boolean enableExceptionLog = true;
    private TimerService timerService;

    protected static Task getCurrentTask() {
        return taskMgr_.get();
    }

    protected static void setCurrentTask(Task t) {
        taskMgr_.set(t);
    }

    protected Scheduler() {
    }

    public Scheduler(int numThreads) {
        this(numThreads, Integer.MAX_VALUE);
    }

    public Scheduler(int numThreads, int queueSize) {
        if (numThreads < 0) {
            numThreads = defaultNumberThreads;
        }
        this.timerService = new TimerService();
        this.affinePool_ = new AffineThreadPool(numThreads, queueSize, this.timerService);
        this.numThreads = numThreads;
    }

    public boolean isEmptyish() {
        return this.affinePool_.isEmptyish();
    }

    public int numThreads() {
        return this.numThreads;
    }

    public void schedule(Task t) {
        if (t instanceof NioSelectorScheduler.RegistrationTask) {
            ((NioSelectorScheduler.RegistrationTask)t).wake();
        } else {
            this.schedule(-1, t);
        }
    }

    public void schedule(int index, Task t) {
        if (t instanceof NioSelectorScheduler.RegistrationTask) {
            assert (false);
        } else {
            this.affinePool_.publish(index, t);
        }
    }

    public void scheduleTimer(Timer t) {
        this.timerService.submit(t);
    }

    public void idledown() {
        if (this.affinePool_ != null && this.affinePool_.waitIdle(this.timerService, 100)) {
            this.shutdown();
        }
    }

    public void shutdown() {
        this.shutdown.set(true);
        if (defaultScheduler == this) {
            defaultScheduler = null;
        }
        if (this.affinePool_ != null) {
            this.affinePool_.shutdown();
        }
        this.timerService.shutdown();
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    protected static void logRelay(Scheduler sched, Object obj) {
        sched.log(obj);
    }

    protected void log(Object obj) {
        if (!this.enableExceptionLog) {
            return;
        }
        if (obj instanceof Throwable) {
            ((Throwable)obj).printStackTrace();
        } else {
            System.out.println(obj);
        }
    }

    public static synchronized Scheduler getDefaultScheduler() {
        if (defaultScheduler == null) {
            defaultScheduler = new Scheduler(defaultNumberThreads);
        }
        return defaultScheduler;
    }

    public static void setDefaultScheduler(Scheduler s) {
        defaultScheduler = s;
    }

    static {
        taskMgr_ = new ThreadLocal();
        String s = System.getProperty("kilim.Scheduler.numThreads");
        if (s != null) {
            try {
                defaultNumberThreads = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defaultNumberThreads == 0) {
            defaultNumberThreads = Runtime.getRuntime().availableProcessors();
        }
    }
}

