/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.util.concurrent.TimeUnit;
import kilim.Scheduler;
import kilim.Task;

public class ReentrantLock
extends java.util.concurrent.locks.ReentrantLock {
    private static final long serialVersionUID = 1L;
    Thread locker = null;

    public ReentrantLock() {
        super(false);
    }

    public ReentrantLock(boolean fair) {
        super(fair);
    }

    @Override
    public Thread getOwner() {
        return super.getOwner();
    }

    @Override
    public void lock() {
        Task tsk;
        Thread t;
        super.lock();
        this.locker = t = Thread.currentThread();
        if (t != null && (tsk = Scheduler.getCurrentTask()) != null) {
            tsk.pinToThread();
        }
    }

    @Override
    public boolean tryLock() {
        boolean ret = super.tryLock();
        Thread t = Thread.currentThread();
        if (ret && t != null) {
            this.locker = t;
            Task tsk = Scheduler.getCurrentTask();
            if (tsk != null) {
                tsk.pinToThread();
            }
        }
        return ret;
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        boolean ret = super.tryLock(timeout, unit);
        Thread t = Thread.currentThread();
        if (ret && t != null) {
            this.locker = t;
            Task tsk = Scheduler.getCurrentTask();
            if (tsk != null) {
                tsk.pinToThread();
            }
        }
        return ret;
    }

    @Override
    public void unlock() {
        Task tsk;
        try {
            super.unlock();
        }
        catch (IllegalMonitorStateException ims) {
            System.err.println("Locking thread: " + this.locker.getName() + ", unlocking thread: " + Thread.currentThread().getName());
            ims.printStackTrace();
            System.exit(1);
        }
        Thread t = Thread.currentThread();
        if (t != null && (tsk = Scheduler.getCurrentTask()) != null) {
            tsk.unpinFromThread();
        }
    }
}

