/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kilim.Task;
import kilim.timerservice.TimerService;

public class AffineThreadPool {
    Executor[] exes;
    AtomicInteger index = new AtomicInteger(-1);
    private AtomicInteger count = new AtomicInteger(0);

    public AffineThreadPool(int numThreads, int queueSize, TimerService ts) {
        this.exes = new Executor[numThreads];
        for (int ii = 0; ii < numThreads; ++ii) {
            this.exes[ii] = new Executor(new LinkedBlockingQueue(queueSize), ts);
        }
        ts.defaultExec = this.exes[0];
    }

    private int next() {
        int value = 0;
        int newValue = 0;
        while (!this.index.compareAndSet(value, newValue = (value = this.index.get()) == this.exes.length - 1 ? 0 : value + 1)) {
        }
        return newValue;
    }

    void publish(int index, Task task) {
        if (index < 0) {
            index = this.next();
        }
        this.count.incrementAndGet();
        task.setTid(index);
        this.exes[index].publish(task);
    }

    public static void publish(ThreadPoolExecutor executor, Runnable payload) {
        Executor exe = (Executor)executor;
        exe.count().incrementAndGet();
        executor.getQueue().add(payload);
    }

    void shutdown() {
        for (int ii = 0; ii < this.exes.length; ++ii) {
            this.exes[ii].shutdown();
        }
    }

    public boolean waitIdle(TimerService ts, int delay) {
        while (!Thread.interrupted()) {
            if (this.resolved(ts)) {
                return true;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        return false;
    }

    private boolean resolved(TimerService ts) {
        if (this.count.get() > 0) {
            return false;
        }
        return ts.isEmptyLazy(this.exes[0]);
    }

    public boolean isEmptyish() {
        for (Executor exe : this.exes) {
            if (exe.que.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyProxy(ThreadPoolExecutor executor) {
        Executor exe = (Executor)executor;
        return exe.count().get() == 0;
    }

    class Executor
    extends ThreadPoolExecutor {
        LinkedBlockingQueue<Task> que;
        AtomicInteger pending;
        private TimerService timerService;

        private AtomicInteger count() {
            return AffineThreadPool.this.count;
        }

        void publish(Task task) {
            this.pending.incrementAndGet();
            this.submit(task);
        }

        public Executor(LinkedBlockingQueue que, TimerService ts) {
            super(1, 1, Integer.MAX_VALUE, TimeUnit.DAYS, que);
            this.pending = new AtomicInteger();
            this.que = que;
            this.timerService = ts;
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            this.pending.decrementAndGet();
            this.timerService.trigger(this);
            AffineThreadPool.this.count.decrementAndGet();
        }
    }
}

