/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.text;

import org.sonar.squid.text.Line;
import org.sonar.squid.text.LineContextHandler;

public class LiteralValueHandler
extends LineContextHandler {
    private final char delimiter;

    public LiteralValueHandler(char delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    boolean matchToEnd(Line line, StringBuilder pendingLine) {
        return LiteralValueHandler.matchEndOfString(pendingLine, this.delimiter) && this.evenNumberOfBackSlashBeforeDelimiter(pendingLine);
    }

    private boolean evenNumberOfBackSlashBeforeDelimiter(StringBuilder pendingLine) {
        int numberOfBackSlashChar = 0;
        for (int index = pendingLine.length() - 2; index >= 0 && pendingLine.charAt(index) == '\\'; --index) {
            ++numberOfBackSlashChar;
        }
        return numberOfBackSlashChar % 2 == 0;
    }

    @Override
    boolean matchToBegin(Line line, StringBuilder pendingLine) {
        return LiteralValueHandler.matchEndOfString(pendingLine, this.delimiter);
    }

    @Override
    boolean matchWithEndOfLine(Line line, StringBuilder pendingLine) {
        return true;
    }
}

