/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon.shared;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.shared.WagonUpload;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.StringUtils;

public class DefaultWagonUpload
implements WagonUpload {
    private ArchiverManager archiverManager;

    public void upload(Wagon wagon, FileSet fileset, Log logger) throws WagonException {
        FileSetManager fileSetManager = new FileSetManager(logger, logger.isDebugEnabled());
        String[] files = fileSetManager.getIncludedFiles(fileset);
        String url = wagon.getRepository().getUrl() + "/";
        if (files.length == 0) {
            logger.info((CharSequence)"Nothing to upload.");
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String relativeDestPath = StringUtils.replace((String)files[i], (String)"\\", (String)"/");
            if (!StringUtils.isBlank((String)fileset.getOutputDirectory())) {
                relativeDestPath = fileset.getOutputDirectory() + "/" + relativeDestPath;
            }
            File source = new File(fileset.getDirectory(), files[i]);
            logger.info((CharSequence)("Uploading " + source + " to " + url + relativeDestPath + " ..."));
            wagon.put(source, relativeDestPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Wagon wagon, FileSet fileset, boolean optimize, Log logger) throws WagonException, IOException {
        if (!optimize) {
            this.upload(wagon, fileset, logger);
            return;
        }
        if (!(wagon instanceof CommandExecutor)) {
            throw new UnsupportedProtocolException("Wagon " + wagon.getRepository().getProtocol() + " does not support optimize upload");
        }
        logger.info((CharSequence)("Uploading " + fileset));
        File zipFile = File.createTempFile("wagon", ".zip");
        try {
            FileSetManager fileSetManager = new FileSetManager(logger, logger.isDebugEnabled());
            String[] files = fileSetManager.getIncludedFiles(fileset);
            if (files.length == 0) {
                logger.info((CharSequence)"Nothing to upload.");
                return;
            }
            logger.info((CharSequence)("Creating " + zipFile + " ..."));
            this.createZip(files, zipFile, fileset.getDirectory());
            String remoteFile = zipFile.getName();
            String remoteDir = fileset.getOutputDirectory();
            if (!StringUtils.isBlank((String)remoteDir)) {
                remoteFile = remoteDir + "/" + remoteFile;
            }
            logger.info((CharSequence)("Uploading " + zipFile + " to " + wagon.getRepository().getUrl() + "/" + remoteFile + " ..."));
            wagon.put(zipFile, remoteFile);
            String command = "unzip -o -qq -d " + remoteDir + " " + remoteFile;
            if (StringUtils.isBlank((String)remoteDir)) {
                command = "unzip -o -qq " + remoteFile;
            }
            try {
                logger.info((CharSequence)("Remote: " + command));
                ((CommandExecutor)wagon).executeCommand(command);
            }
            finally {
                command = "rm -f " + remoteFile;
                logger.info((CharSequence)("Remote: " + command));
                ((CommandExecutor)wagon).executeCommand(command);
            }
        }
        finally {
            zipFile.delete();
        }
    }

    private void createZip(String[] files, File zipFile, String basedir) throws IOException {
        try {
            ZipArchiver archiver = (ZipArchiver)this.archiverManager.getArchiver(zipFile);
            archiver.setDestFile(zipFile);
            for (String file : files) {
                archiver.addFile(new File(basedir, file), file);
            }
            archiver.createArchive();
        }
        catch (NoSuchArchiverException e) {
            // empty catch block
        }
    }
}

