/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.msvc;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.msvc.AbstractMSVCEnvFactory;
import org.codehaus.mojo.natives.util.EnvUtil;

public class MSVC6EnvFactory
extends AbstractMSVCEnvFactory {
    private static final String MSVS6_INSTALL_ENV_KEY = "MSVS6_INSTALL_DIR";
    private static final String DEFAULT_MSVS6_INSTALL_DIR = MSVC6EnvFactory.getProgramFilesX86() + "/Microsoft Visual Studio";

    protected Map<String, String> createEnvs() throws NativeBuildException {
        File vsDir = new File(EnvUtil.getEnv((String)MSVS6_INSTALL_ENV_KEY, (String)MSVS6_INSTALL_ENV_KEY, (String)DEFAULT_MSVS6_INSTALL_DIR));
        if (!vsDir.isDirectory()) {
            throw new NativeBuildException(vsDir.getPath() + " is not a directory.");
        }
        HashMap<String, String> envs = new HashMap<String, String>();
        String vcOsDir = "WINNT";
        String winDir = EnvUtil.getEnv((String)"windir");
        File vsCommonDir = new File(vsDir + "/Common");
        File vsCommonToolDir = new File(vsCommonDir + "/TOOLS");
        File msDevDir = new File(vsCommonDir + "/msdev98");
        File msvcDir = new File(vsDir + "/VC98");
        envs.put("MSVCDir", msvcDir.getPath());
        String currentPath = System.getProperty("java.library.path");
        String newPath = msDevDir.getPath() + "\\BIN;" + msvcDir.getPath() + "\\BIN;" + vsCommonToolDir.getPath() + "\\" + vcOsDir + ";" + vsCommonToolDir.getPath() + ";" + winDir + ";" + currentPath;
        envs.put("PATH", newPath);
        String currentIncludePath = EnvUtil.getEnv((String)"INCLUDE");
        String newIncludePath = msvcDir.getPath() + "\\ATL\\INCLUDE;" + msvcDir.getPath() + "\\INCLUDE;" + msvcDir.getPath() + "\\MFC\\INCLUDE;" + vsCommonToolDir.getPath() + vcOsDir + ";" + vsCommonToolDir.getPath() + ";" + currentIncludePath;
        envs.put("INCLUDE", newIncludePath);
        String currentLibPath = EnvUtil.getEnv((String)"LIB");
        String newLibPath = msvcDir.getPath() + "\\LIB;" + msvcDir.getPath() + "\\MFC\\LIB;" + currentLibPath;
        envs.put("LIB", newLibPath);
        return envs;
    }
}

