/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.msvc;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.msvc.AbstractMSVCEnvFactory;
import org.codehaus.mojo.natives.util.EnvUtil;

public class MSVC2003EnvFactory
extends AbstractMSVCEnvFactory {
    private static final String MSVS2003_INSTALL_ENV_KEY = "MSVS2003_INSTALL_DIR";
    private static final String DEFAULT_MSVS2003_INSTALL_DIR = MSVC2003EnvFactory.getProgramFiles() + "/Microsoft Visual Studio .NET 2003";

    protected Map<String, String> createEnvs() throws NativeBuildException {
        File vcInstallDir = new File(EnvUtil.getEnv((String)MSVS2003_INSTALL_ENV_KEY, (String)MSVS2003_INSTALL_ENV_KEY, (String)DEFAULT_MSVS2003_INSTALL_DIR));
        if (!vcInstallDir.isDirectory()) {
            throw new NativeBuildException(vcInstallDir.getPath() + " is not a directory.");
        }
        HashMap<String, String> envs = new HashMap<String, String>();
        File vsInstallDir = new File(vcInstallDir.getPath() + "/Common7/IDE");
        File frameworkDir = new File(MSVC2003EnvFactory.getSystemRoot() + "/Microsoft.NET/Framework");
        envs.put("FrameworkDir", frameworkDir.getPath());
        File frameworkSDKDir = new File(vcInstallDir.getPath() + "/SDK/v1.1");
        envs.put("FrameworkSDKDir", frameworkSDKDir.getPath());
        String frameworkVersion = "v1.1.4322";
        envs.put("frameworkVersion", frameworkVersion);
        File devEnvDir = vsInstallDir;
        File msvcDir = new File(vcInstallDir.getPath() + "/VC7");
        String currentPath = System.getProperty("java.library.path");
        String newPath = devEnvDir.getPath() + ";" + msvcDir.getPath() + "\\BIN;" + vcInstallDir.getPath() + "\\Common7\\Tools;" + vcInstallDir.getPath() + "\\Common7\\Tools\\bin\\prerelease;" + vcInstallDir.getPath() + "\\Common7\\Tools\\bin;" + frameworkSDKDir.getPath() + "\\bin;" + frameworkDir.getPath() + "\\" + frameworkVersion + ";" + currentPath;
        envs.put("PATH", newPath);
        String currentIncludePath = EnvUtil.getEnv((String)"INCLUDE");
        String newIncludePath = msvcDir.getPath() + "\\ATLMFC\\INCLUDE;" + msvcDir.getPath() + "\\INCLUDE;" + msvcDir.getPath() + "\\PlatformSDK\\include\\prerelease;" + msvcDir.getPath() + "\\PlatformSDK\\include;" + frameworkSDKDir.getPath() + "\\include;" + currentIncludePath;
        envs.put("INCLUDE", newIncludePath);
        String currentLibPath = EnvUtil.getEnv((String)"LIB");
        String newLibPath = msvcDir.getPath() + "\\ATLMFC\\LIB;" + msvcDir.getPath() + "\\LIB;" + msvcDir.getPath() + "\\PlatformSDK\\lib\\prerelease;" + msvcDir.getPath() + "\\PlatformSDK\\lib;" + currentLibPath;
        envs.put("LIB", newLibPath);
        return envs;
    }
}

