/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.helper;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Opaque;
import org.bytedeco.javacpp.annotation.ValueGetter;
import org.bytedeco.javacpp.opencv_core;

public class opencv_core
extends org.bytedeco.javacpp.presets.opencv_core {
    public static opencv_core.CvScalar CV_RGB(double r, double g, double b) {
        return org.bytedeco.javacpp.opencv_core.cvScalar(b, g, r, 0.0);
    }

    public static int cvInitNArrayIterator(int count, CvArr[] arrs, CvArr mask, opencv_core.CvMatND stubs, opencv_core.CvNArrayIterator array_iterator, int flags) {
        return org.bytedeco.javacpp.opencv_core.cvInitNArrayIterator(count, new CvArrArray(arrs), mask, stubs, array_iterator, flags);
    }

    public static void cvMixChannels(CvArr[] src, int src_count, CvArr[] dst, int dst_count, int[] from_to, int pair_count) {
        org.bytedeco.javacpp.opencv_core.cvMixChannels(new CvArrArray(src), src_count, new CvArrArray(dst), dst_count, new IntPointer(from_to), pair_count);
    }

    public static void cvCalcCovarMatrix(CvArr[] vects, int count, CvArr cov_mat, CvArr avg, int flags) {
        org.bytedeco.javacpp.opencv_core.cvCalcCovarMatrix(new CvArrArray(vects), count, cov_mat, avg, flags);
    }

    public static double cvNorm(CvArr arr1, CvArr arr2) {
        return org.bytedeco.javacpp.opencv_core.cvNorm(arr1, arr2, 4, null);
    }

    public static void cvFillPoly(CvArr img, opencv_core.CvPoint[] pts, int[] npts, int contours, opencv_core.CvScalar color, int line_type, int shift) {
        org.bytedeco.javacpp.opencv_core.cvFillPoly(img, new PointerPointer((Pointer[])pts), new IntPointer(npts), contours, color, line_type, shift);
    }

    public static void cvPolyLine(CvArr img, opencv_core.CvPoint[] pts, int[] npts, int contours, int is_closed, opencv_core.CvScalar color, int thickness, int line_type, int shift) {
        org.bytedeco.javacpp.opencv_core.cvPolyLine(img, new PointerPointer((Pointer[])pts), new IntPointer(npts), contours, is_closed, color, thickness, line_type, shift);
    }

    public static void cvDrawPolyLine(CvArr img, opencv_core.CvPoint[] pts, int[] npts, int contours, int is_closed, opencv_core.CvScalar color, int thickness, int line_type, int shift) {
        opencv_core.cvPolyLine(img, pts, npts, contours, is_closed, color, thickness, line_type, shift);
    }

    public static void cvDrawContours(CvArr img, opencv_core.CvSeq contour, opencv_core.CvScalar external_color, opencv_core.CvScalar hole_color, int max_level, int thickness, int line_type) {
        org.bytedeco.javacpp.opencv_core.cvDrawContours(img, contour, external_color, hole_color, max_level, thickness, line_type, opencv_core.CvPoint.ZERO);
    }

    public static abstract class AbstractMat
    extends AbstractArray {
        public static final opencv_core.Mat EMPTY = new opencv_core.Mat();

        public AbstractMat() {
        }

        public AbstractMat(Pointer p) {
            super(p);
        }

        public void createFrom(BufferedImage image) {
            this.createFrom(image, 1.0);
        }

        public void createFrom(BufferedImage image, double gamma) {
            this.createFrom(image, gamma, false);
        }

        public void createFrom(BufferedImage image, double gamma, boolean flipChannels) {
            if (image == null) {
                this.release();
                return;
            }
            SampleModel sm = image.getSampleModel();
            int depth = 0;
            int numChannels = sm.getNumBands();
            switch (image.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    depth = 0;
                    numChannels = 4;
                }
            }
            if (depth == 0 || numChannels == 0) {
                switch (sm.getDataType()) {
                    case 0: {
                        depth = 0;
                        break;
                    }
                    case 1: {
                        depth = 2;
                        break;
                    }
                    case 2: {
                        depth = 3;
                        break;
                    }
                    case 3: {
                        depth = 4;
                        break;
                    }
                    case 4: {
                        depth = 5;
                        break;
                    }
                    case 5: {
                        depth = 6;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            this.create(image.getWidth(), image.getHeight(), org.bytedeco.javacpp.opencv_core.CV_MAKETYPE(depth, numChannels));
            this.copyFrom(image, gamma, flipChannels);
        }

        public abstract void create(int var1, int var2, int var3);

        public abstract void release();

        public abstract int type();

        public abstract int depth();

        public abstract int channels();

        public abstract int rows();

        public abstract int cols();

        public abstract BytePointer data();

        public abstract int size(int var1);

        public abstract int step(int var1);

        @Override
        public int arrayChannels() {
            return this.channels();
        }

        @Override
        public int arrayDepth() {
            switch (this.depth()) {
                case 0: {
                    return 8;
                }
                case 1: {
                    return -2147483640;
                }
                case 2: {
                    return 16;
                }
                case 3: {
                    return -2147483632;
                }
                case 4: {
                    return -2147483616;
                }
                case 5: {
                    return 32;
                }
                case 6: {
                    return 64;
                }
            }
            assert (false);
            return -1;
        }

        @Override
        public int arrayOrigin() {
            return 0;
        }

        @Override
        public void arrayOrigin(int origin) {
        }

        @Override
        public int arrayWidth() {
            return this.cols();
        }

        @Override
        public int arrayHeight() {
            return this.rows();
        }

        @Override
        public opencv_core.IplROI arrayROI() {
            return null;
        }

        @Override
        public int arraySize() {
            return this.step(0) * this.size(0);
        }

        @Override
        public BytePointer arrayData() {
            return this.data();
        }

        @Override
        public int arrayStep() {
            return this.step(0);
        }
    }

    public static abstract class AbstractCvFont
    extends Pointer {
        public AbstractCvFont() {
        }

        public AbstractCvFont(Pointer p) {
            super(p);
        }
    }

    public static abstract class AbstractCvGraphScanner
    extends Pointer {
        public AbstractCvGraphScanner() {
        }

        public AbstractCvGraphScanner(Pointer p) {
            super(p);
        }

        public static opencv_core.CvGraphScanner create(opencv_core.CvGraph graph, opencv_core.CvGraphVtx vtx, int mask) {
            opencv_core.CvGraphScanner g = org.bytedeco.javacpp.opencv_core.cvCreateGraphScanner(graph, vtx, mask);
            if (g != null) {
                g.deallocator(new ReleaseDeallocator(g));
            }
            return g;
        }

        public void release() {
            this.deallocate();
        }

        protected static class ReleaseDeallocator
        extends opencv_core.CvGraphScanner
        implements Pointer.Deallocator {
            ReleaseDeallocator(opencv_core.CvGraphScanner p) {
                super(p);
            }

            public void deallocate() {
                org.bytedeco.javacpp.opencv_core.cvReleaseGraphScanner(this);
            }
        }
    }

    public static abstract class AbstractCvFileStorage
    extends Pointer {
        public AbstractCvFileStorage() {
        }

        public AbstractCvFileStorage(Pointer p) {
            super(p);
        }

        public static opencv_core.CvFileStorage open(String filename, opencv_core.CvMemStorage memstorage, int flags) {
            return AbstractCvFileStorage.open(filename, memstorage, flags, null);
        }

        public static opencv_core.CvFileStorage open(String filename, opencv_core.CvMemStorage memstorage, int flags, String encoding) {
            opencv_core.CvFileStorage f = org.bytedeco.javacpp.opencv_core.cvOpenFileStorage(filename, memstorage, flags, encoding);
            if (f != null) {
                f.deallocator(new ReleaseDeallocator(f));
            }
            return f;
        }

        public void release() {
            this.deallocate();
        }

        protected static class ReleaseDeallocator
        extends opencv_core.CvFileStorage
        implements Pointer.Deallocator {
            ReleaseDeallocator(opencv_core.CvFileStorage p) {
                super(p);
            }

            public void deallocate() {
                org.bytedeco.javacpp.opencv_core.cvReleaseFileStorage(this);
            }
        }
    }

    public static abstract class AbstractCvGraph
    extends opencv_core.CvSet {
        public AbstractCvGraph() {
        }

        public AbstractCvGraph(Pointer p) {
            super(p);
        }

        public static opencv_core.CvGraph create(int graph_flags, int header_size, int vtx_size, int edge_size, opencv_core.CvMemStorage storage) {
            return org.bytedeco.javacpp.opencv_core.cvCreateGraph(graph_flags, header_size, vtx_size, edge_size, storage);
        }
    }

    public static abstract class AbstractCvSet
    extends opencv_core.CvSeq {
        public AbstractCvSet() {
        }

        public AbstractCvSet(Pointer p) {
            super(p);
        }

        public static opencv_core.CvSet create(int set_flags, int header_size, int elem_size, opencv_core.CvMemStorage storage) {
            return org.bytedeco.javacpp.opencv_core.cvCreateSet(set_flags, header_size, elem_size, storage);
        }
    }

    public static abstract class AbstractCvSeq
    extends CvArr {
        public AbstractCvSeq() {
        }

        public AbstractCvSeq(Pointer p) {
            super(p);
        }

        public static opencv_core.CvSeq create(int seq_flags, int header_size, int elem_size, opencv_core.CvMemStorage storage) {
            return org.bytedeco.javacpp.opencv_core.cvCreateSeq(seq_flags, header_size, elem_size, storage);
        }
    }

    public static abstract class AbstractCvMemStorage
    extends Pointer {
        public AbstractCvMemStorage() {
        }

        public AbstractCvMemStorage(Pointer p) {
            super(p);
        }

        public static opencv_core.CvMemStorage create(int block_size) {
            opencv_core.CvMemStorage m = org.bytedeco.javacpp.opencv_core.cvCreateMemStorage(block_size);
            if (m != null) {
                m.deallocator(new ReleaseDeallocator(m));
            }
            return m;
        }

        public static opencv_core.CvMemStorage create() {
            return AbstractCvMemStorage.create(0);
        }

        public void release() {
            this.deallocate();
        }

        protected static class ReleaseDeallocator
        extends opencv_core.CvMemStorage
        implements Pointer.Deallocator {
            ReleaseDeallocator(opencv_core.CvMemStorage p) {
                super(p);
            }

            public void deallocate() {
                org.bytedeco.javacpp.opencv_core.cvReleaseMemStorage(this);
            }
        }
    }

    public static abstract class AbstractCvScalar
    extends DoublePointer {
        public static final opencv_core.CvScalar ZERO = new opencv_core.CvScalar().val(0, 0.0).val(1, 0.0).val(2, 0.0).val(3, 0.0);
        public static final opencv_core.CvScalar ONE = new opencv_core.CvScalar().val(0, 1.0).val(1, 1.0).val(2, 1.0).val(3, 1.0);
        public static final opencv_core.CvScalar ONEHALF = new opencv_core.CvScalar().val(0, 0.5).val(1, 0.5).val(2, 0.5).val(3, 0.5);
        public static final opencv_core.CvScalar ALPHA1 = new opencv_core.CvScalar().val(0, 0.0).val(1, 0.0).val(2, 0.0).val(3, 1.0);
        public static final opencv_core.CvScalar ALPHA255 = new opencv_core.CvScalar().val(0, 0.0).val(1, 0.0).val(2, 0.0).val(3, 255.0);
        public static final opencv_core.CvScalar WHITE = opencv_core.CV_RGB(255.0, 255.0, 255.0);
        public static final opencv_core.CvScalar GRAY = opencv_core.CV_RGB(128.0, 128.0, 128.0);
        public static final opencv_core.CvScalar BLACK = opencv_core.CV_RGB(0.0, 0.0, 0.0);
        public static final opencv_core.CvScalar RED = opencv_core.CV_RGB(255.0, 0.0, 0.0);
        public static final opencv_core.CvScalar GREEN = opencv_core.CV_RGB(0.0, 255.0, 0.0);
        public static final opencv_core.CvScalar BLUE = opencv_core.CV_RGB(0.0, 0.0, 255.0);
        public static final opencv_core.CvScalar CYAN = opencv_core.CV_RGB(0.0, 255.0, 255.0);
        public static final opencv_core.CvScalar MAGENTA = opencv_core.CV_RGB(255.0, 0.0, 255.0);
        public static final opencv_core.CvScalar YELLOW = opencv_core.CV_RGB(255.0, 255.0, 0.0);

        public AbstractCvScalar() {
        }

        public AbstractCvScalar(Pointer p) {
            super(p);
        }

        public abstract double val(int var1);

        public abstract opencv_core.CvScalar val(int var1, double var2);

        public double getVal(int i) {
            return this.val(i);
        }

        public opencv_core.CvScalar setVal(int i, double val) {
            return this.val(i, val);
        }

        public abstract DoublePointer val();

        public DoublePointer getDoublePointerVal() {
            return this.val();
        }

        public LongPointer getLongPointerVal() {
            return new LongPointer((Pointer)this.val());
        }

        public void scale(double s) {
            for (int i = 0; i < 4; ++i) {
                this.val(i, this.val(i) * s);
            }
        }

        public double red() {
            return this.val(2);
        }

        public double green() {
            return this.val(1);
        }

        public double blue() {
            return this.val(0);
        }

        public opencv_core.CvScalar red(double r) {
            this.val(2, r);
            return (opencv_core.CvScalar)this;
        }

        public opencv_core.CvScalar green(double g) {
            this.val(1, g);
            return (opencv_core.CvScalar)this;
        }

        public opencv_core.CvScalar blue(double b) {
            this.val(0, b);
            return (opencv_core.CvScalar)this;
        }

        public double magnitude() {
            return Math.sqrt(this.val(0) * this.val(0) + this.val(1) * this.val(1) + this.val(2) * this.val(2) + this.val(3) * this.val(3));
        }

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            if (this.capacity() == 0) {
                return "(" + (float)this.val(0) + ", " + (float)this.val(1) + ", " + (float)this.val(2) + ", " + (float)this.val(3) + ")";
            }
            String s = "";
            int p = this.position();
            for (int i = 0; i < this.capacity(); ++i) {
                this.position(i);
                s = s + (i == 0 ? "(" : " (") + (float)this.val(0) + ", " + (float)this.val(1) + ", " + (float)this.val(2) + ", " + (float)this.val(3) + ")";
            }
            this.position(p);
            return s;
        }
    }

    public static abstract class AbstractCvBox2D
    extends FloatPointer {
        public AbstractCvBox2D() {
        }

        public AbstractCvBox2D(Pointer p) {
            super(p);
        }

        public abstract opencv_core.CvPoint2D32f center();

        public abstract opencv_core.CvBox2D center(opencv_core.CvPoint2D32f var1);

        public abstract opencv_core.CvSize2D32f size();

        public abstract opencv_core.CvBox2D size(opencv_core.CvSize2D32f var1);

        public abstract float angle();

        public abstract opencv_core.CvBox2D angle(float var1);

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            if (this.capacity() == 0) {
                return "(" + (Object)((Object)this.center()) + ", " + (Object)((Object)this.size()) + ", " + this.angle() + ")";
            }
            String s = "";
            int p = this.position();
            for (int i = 0; i < this.capacity(); ++i) {
                this.position(i);
                s = s + (i == 0 ? "(" : " (") + (Object)((Object)this.center()) + ", " + (Object)((Object)this.size()) + ", " + this.angle() + ")";
            }
            this.position(p);
            return s;
        }
    }

    public static abstract class AbstractCvSize2D32f
    extends FloatPointer {
        public AbstractCvSize2D32f() {
        }

        public AbstractCvSize2D32f(Pointer p) {
            super(p);
        }

        public abstract float width();

        public abstract opencv_core.CvSize2D32f width(float var1);

        public abstract float height();

        public abstract opencv_core.CvSize2D32f height(float var1);

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            if (this.capacity() == 0) {
                return "(" + this.width() + ", " + this.height() + ")";
            }
            String s = "";
            int p = this.position();
            for (int i = 0; i < this.capacity(); ++i) {
                this.position(i);
                s = s + (i == 0 ? "(" : " (") + this.width() + ", " + this.height() + ")";
            }
            this.position(p);
            return s;
        }
    }

    public static abstract class AbstractCvSize
    extends IntPointer {
        public static final opencv_core.CvSize ZERO = new opencv_core.CvSize().width(0).height(0);

        public AbstractCvSize() {
        }

        public AbstractCvSize(Pointer p) {
            super(p);
        }

        public abstract int width();

        public abstract opencv_core.CvSize width(int var1);

        public abstract int height();

        public abstract opencv_core.CvSize height(int var1);

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            if (this.capacity() == 0) {
                return "(" + this.width() + ", " + this.height() + ")";
            }
            String s = "";
            int p = this.position();
            for (int i = 0; i < this.capacity(); ++i) {
                this.position(i);
                s = s + (i == 0 ? "(" : " (") + this.width() + ", " + this.height() + ")";
            }
            this.position(p);
            return s;
        }
    }

    public static abstract class AbstractCvPoint3D64f
    extends DoublePointer {
        public AbstractCvPoint3D64f() {
        }

        public AbstractCvPoint3D64f(Pointer p) {
            super(p);
        }

        public abstract double x();

        public abstract opencv_core.CvPoint3D64f x(double var1);

        public abstract double y();

        public abstract opencv_core.CvPoint3D64f y(double var1);

        public abstract double z();

        public abstract opencv_core.CvPoint3D64f z(double var1);

        public opencv_core.CvPoint3D64f get(double[] pts) {
            return this.get(pts, 0, pts.length);
        }

        public opencv_core.CvPoint3D64f get(double[] pts, int offset, int length) {
            for (int i = 0; i < length / 3; ++i) {
                this.position(i);
                pts[offset + i * 3] = this.x();
                pts[offset + i * 3 + 1] = this.y();
                pts[offset + i * 3 + 2] = this.z();
            }
            return (opencv_core.CvPoint3D64f)this.position(0);
        }

        public final opencv_core.CvPoint3D64f put(double[] pts, int offset, int length) {
            for (int i = 0; i < length / 3; ++i) {
                this.position(i);
                this.put(pts[offset + i * 3], pts[offset + i * 3 + 1], pts[offset + i * 3 + 2]);
            }
            return (opencv_core.CvPoint3D64f)this.position(0);
        }

        public final opencv_core.CvPoint3D64f put(double ... pts) {
            return this.put(pts, 0, pts.length);
        }

        public opencv_core.CvPoint3D64f put(double x, double y, double z) {
            return this.x(this.x()).y(this.y()).z(this.z());
        }

        public opencv_core.CvPoint3D64f put(opencv_core.CvPoint o) {
            return this.x(o.x()).y(o.y()).z(0.0);
        }

        public opencv_core.CvPoint3D64f put(opencv_core.CvPoint2D32f o) {
            return this.x(o.x()).y(o.y()).z(0.0);
        }

        public opencv_core.CvPoint3D64f put(opencv_core.CvPoint2D64f o) {
            return this.x(o.x()).y(o.y()).z(0.0);
        }

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            if (this.capacity() == 0) {
                return "(" + (float)this.x() + ", " + (float)this.y() + ", " + (float)this.z() + ")";
            }
            String s = "";
            int p = this.position();
            for (int i = 0; i < this.capacity(); ++i) {
                this.position(i);
                s = s + (i == 0 ? "(" : " (") + (float)this.x() + ", " + (float)this.y() + ", " + (float)this.z() + ")";
            }
            this.position(p);
            return s;
        }
    }

    public static abstract class AbstractCvPoint2D64f
    extends DoublePointer {
        public AbstractCvPoint2D64f() {
        }

        public AbstractCvPoint2D64f(Pointer p) {
            super(p);
        }

        public abstract double x();

        public abstract opencv_core.CvPoint2D64f x(double var1);

        public abstract double y();

        public abstract opencv_core.CvPoint2D64f y(double var1);

        public opencv_core.CvPoint2D64f get(double[] pts) {
            return this.get(pts, 0, pts.length);
        }

        public opencv_core.CvPoint2D64f get(double[] pts, int offset, int length) {
            for (int i = 0; i < length / 2; ++i) {
                this.position(i);
                pts[offset + i * 2] = this.x();
                pts[offset + i * 2 + 1] = this.y();
            }
            return (opencv_core.CvPoint2D64f)this.position(0);
        }

        public final opencv_core.CvPoint2D64f put(double[] pts, int offset, int length) {
            for (int i = 0; i < length / 2; ++i) {
                this.position(i);
                this.put(pts[offset + i * 2], pts[offset + i * 2 + 1]);
            }
            return (opencv_core.CvPoint2D64f)this.position(0);
        }

        public final opencv_core.CvPoint2D64f put(double ... pts) {
            return this.put(pts, 0, pts.length);
        }

        public opencv_core.CvPoint2D64f put(double x, double y) {
            return this.x(x).y(y);
        }

        public opencv_core.CvPoint2D64f put(opencv_core.CvPoint o) {
            return this.x(o.x()).y(o.y());
        }

        public opencv_core.CvPoint2D64f put(opencv_core.CvPoint2D32f o) {
            return this.x(o.x()).y(o.y());
        }

        public opencv_core.CvPoint2D64f put(opencv_core.CvPoint2D64f o) {
            return this.x(o.x()).y(o.y());
        }

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            if (this.capacity() == 0) {
                return "(" + (float)this.x() + ", " + (float)this.y() + ")";
            }
            String s = "";
            int p = this.position();
            for (int i = 0; i < this.capacity(); ++i) {
                this.position(i);
                s = s + (i == 0 ? "(" : " (") + (float)this.x() + ", " + (float)this.y() + ")";
            }
            this.position(p);
            return s;
        }
    }

    public static abstract class AbstractCvPoint3D32f
    extends FloatPointer {
        public AbstractCvPoint3D32f() {
        }

        public AbstractCvPoint3D32f(Pointer p) {
            super(p);
        }

        public abstract float x();

        public abstract opencv_core.CvPoint3D32f x(float var1);

        public abstract float y();

        public abstract opencv_core.CvPoint3D32f y(float var1);

        public abstract float z();

        public abstract opencv_core.CvPoint3D32f z(float var1);

        public opencv_core.CvPoint3D32f get(double[] pts) {
            return this.get(pts, 0, pts.length);
        }

        public opencv_core.CvPoint3D32f get(double[] pts, int offset, int length) {
            for (int i = 0; i < length / 3; ++i) {
                this.position(i);
                pts[offset + i * 3] = this.x();
                pts[offset + i * 3 + 1] = this.y();
                pts[offset + i * 3 + 2] = this.z();
            }
            return (opencv_core.CvPoint3D32f)this.position(0);
        }

        public final opencv_core.CvPoint3D32f put(double[] pts, int offset, int length) {
            for (int i = 0; i < length / 3; ++i) {
                this.position(i);
                this.put(pts[offset + i * 3], pts[offset + i * 3 + 1], pts[offset + i * 3 + 2]);
            }
            return (opencv_core.CvPoint3D32f)this.position(0);
        }

        public final opencv_core.CvPoint3D32f put(double ... pts) {
            return this.put(pts, 0, pts.length);
        }

        public opencv_core.CvPoint3D32f put(double x, double y, double z) {
            return this.x((float)x).y((float)y).z((float)z);
        }

        public opencv_core.CvPoint3D32f put(opencv_core.CvPoint o) {
            return this.x(o.x()).y(o.y()).z(0.0f);
        }

        public opencv_core.CvPoint3D32f put(opencv_core.CvPoint2D32f o) {
            return this.x(o.x()).y(o.y()).z(0.0f);
        }

        public opencv_core.CvPoint3D32f put(opencv_core.CvPoint2D64f o) {
            return this.x((float)o.x()).y((float)o.y()).z(0.0f);
        }

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            if (this.capacity() == 0) {
                return "(" + this.x() + ", " + this.y() + ", " + this.z() + ")";
            }
            String s = "";
            int p = this.position();
            for (int i = 0; i < this.capacity(); ++i) {
                this.position(i);
                s = s + (i == 0 ? "(" : " (") + this.x() + ", " + this.y() + ", " + this.z() + ")";
            }
            this.position(p);
            return s;
        }
    }

    public static abstract class AbstractCvPoint2D32f
    extends FloatPointer {
        public AbstractCvPoint2D32f() {
        }

        public AbstractCvPoint2D32f(Pointer p) {
            super(p);
        }

        public abstract float x();

        public abstract opencv_core.CvPoint2D32f x(float var1);

        public abstract float y();

        public abstract opencv_core.CvPoint2D32f y(float var1);

        public opencv_core.CvPoint2D32f get(double[] pts) {
            return this.get(pts, 0, pts.length);
        }

        public opencv_core.CvPoint2D32f get(double[] pts, int offset, int length) {
            for (int i = 0; i < length / 2; ++i) {
                this.position(i);
                pts[offset + i * 2] = this.x();
                pts[offset + i * 2 + 1] = this.y();
            }
            return (opencv_core.CvPoint2D32f)this.position(0);
        }

        public final opencv_core.CvPoint2D32f put(double[] pts, int offset, int length) {
            for (int i = 0; i < length / 2; ++i) {
                this.position(i);
                this.put(pts[offset + i * 2], pts[offset + i * 2 + 1]);
            }
            return (opencv_core.CvPoint2D32f)this.position(0);
        }

        public final opencv_core.CvPoint2D32f put(double ... pts) {
            return this.put(pts, 0, pts.length);
        }

        public opencv_core.CvPoint2D32f put(double x, double y) {
            return this.x((float)x).y((float)y);
        }

        public opencv_core.CvPoint2D32f put(opencv_core.CvPoint o) {
            return this.x(o.x()).y(o.y());
        }

        public opencv_core.CvPoint2D32f put(opencv_core.CvPoint2D32f o) {
            return this.x(o.x()).y(o.y());
        }

        public opencv_core.CvPoint2D32f put(opencv_core.CvPoint2D64f o) {
            return this.x((float)o.x()).y((float)o.y());
        }

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            if (this.capacity() == 0) {
                return "(" + this.x() + ", " + this.y() + ")";
            }
            String s = "";
            int p = this.position();
            for (int i = 0; i < this.capacity(); ++i) {
                this.position(i);
                s = s + (i == 0 ? "(" : " (") + this.x() + ", " + this.y() + ")";
            }
            this.position(p);
            return s;
        }
    }

    public static abstract class AbstractCvPoint
    extends IntPointer {
        public static final opencv_core.CvPoint ZERO = new opencv_core.CvPoint().x(0).y(0);

        public AbstractCvPoint() {
        }

        public AbstractCvPoint(Pointer p) {
            super(p);
        }

        public abstract int x();

        public abstract opencv_core.CvPoint x(int var1);

        public abstract int y();

        public abstract opencv_core.CvPoint y(int var1);

        public opencv_core.CvPoint get(int[] pts) {
            return this.get(pts, 0, pts.length);
        }

        public opencv_core.CvPoint get(int[] pts, int offset, int length) {
            for (int i = 0; i < length / 2; ++i) {
                this.position(i);
                pts[offset + i * 2] = this.x();
                pts[offset + i * 2 + 1] = this.y();
            }
            return (opencv_core.CvPoint)this.position(0);
        }

        public final opencv_core.CvPoint put(int[] pts, int offset, int length) {
            for (int i = 0; i < length / 2; ++i) {
                this.position(i);
                this.put(pts[offset + i * 2], pts[offset + i * 2 + 1]);
            }
            return (opencv_core.CvPoint)this.position(0);
        }

        public final opencv_core.CvPoint put(int ... pts) {
            return this.put(pts, 0, pts.length);
        }

        public final opencv_core.CvPoint put(byte shift, double[] pts, int offset, int length) {
            int[] a = new int[length];
            for (int i = 0; i < length; ++i) {
                a[i] = (int)Math.round(pts[offset + i] * (double)(1 << shift));
            }
            return this.put(a, 0, length);
        }

        public final opencv_core.CvPoint put(byte shift, double ... pts) {
            return this.put(shift, pts, 0, pts.length);
        }

        public opencv_core.CvPoint put(int x, int y) {
            return this.x(x).y(y);
        }

        public opencv_core.CvPoint put(opencv_core.CvPoint o) {
            return this.x(o.x()).y(o.y());
        }

        public opencv_core.CvPoint put(byte shift, opencv_core.CvPoint2D32f o) {
            this.x(Math.round(o.x() * (float)(1 << shift)));
            this.y(Math.round(o.y() * (float)(1 << shift)));
            return (opencv_core.CvPoint)this;
        }

        public opencv_core.CvPoint put(byte shift, opencv_core.CvPoint2D64f o) {
            this.x((int)Math.round(o.x() * (double)(1 << shift)));
            this.y((int)Math.round(o.y() * (double)(1 << shift)));
            return (opencv_core.CvPoint)this;
        }

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            if (this.capacity() == 0) {
                return "(" + this.x() + ", " + this.y() + ")";
            }
            String s = "";
            int p = this.position();
            for (int i = 0; i < this.capacity(); ++i) {
                this.position(i);
                s = s + (i == 0 ? "(" : " (") + this.x() + ", " + this.y() + ")";
            }
            this.position(p);
            return s;
        }
    }

    public static abstract class AbstractCvRect
    extends IntPointer {
        public AbstractCvRect() {
        }

        public AbstractCvRect(Pointer p) {
            super(p);
        }

        public abstract int x();

        public abstract int y();

        public abstract int width();

        public abstract int height();

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            if (this.capacity() == 0) {
                return "(" + this.x() + ", " + this.y() + "; " + this.width() + ", " + this.height() + ")";
            }
            String s = "";
            int p = this.position();
            for (int i = 0; i < this.capacity(); ++i) {
                this.position(i);
                s = s + (i == 0 ? "(" : " (") + this.x() + ", " + this.y() + "; " + this.width() + ", " + this.height() + ")";
            }
            this.position(p);
            return s;
        }
    }

    public static abstract class AbstractCvSparseMat
    extends CvArr {
        public AbstractCvSparseMat() {
        }

        public AbstractCvSparseMat(Pointer p) {
            super(p);
        }

        public static opencv_core.CvSparseMat create(int dims, int[] sizes, int type) {
            opencv_core.CvSparseMat m = org.bytedeco.javacpp.opencv_core.cvCreateSparseMat(dims, sizes, type);
            if (m != null) {
                m.deallocator(new ReleaseDeallocator(m));
            }
            return m;
        }

        public opencv_core.CvSparseMat clone() {
            opencv_core.CvSparseMat m = org.bytedeco.javacpp.opencv_core.cvCloneSparseMat((opencv_core.CvSparseMat)this);
            if (m != null) {
                m.deallocator(new ReleaseDeallocator(m));
            }
            return m;
        }

        public void release() {
            this.deallocate();
        }

        protected static class ReleaseDeallocator
        extends opencv_core.CvSparseMat
        implements Pointer.Deallocator {
            ReleaseDeallocator(opencv_core.CvSparseMat p) {
                super(p);
            }

            public void deallocate() {
                org.bytedeco.javacpp.opencv_core.cvReleaseSparseMat(this);
            }
        }
    }

    public static abstract class AbstractCvMatND
    extends CvArr {
        public AbstractCvMatND() {
        }

        public AbstractCvMatND(Pointer p) {
            super(p);
        }

        public static opencv_core.CvMatND create(int dims, int[] sizes, int type) {
            opencv_core.CvMatND m = org.bytedeco.javacpp.opencv_core.cvCreateMatND(dims, sizes, type);
            if (m != null) {
                m.deallocator(new ReleaseDeallocator(m));
            }
            return m;
        }

        public opencv_core.CvMatND clone() {
            opencv_core.CvMatND m = org.bytedeco.javacpp.opencv_core.cvCloneMatND((opencv_core.CvMatND)this);
            if (m != null) {
                m.deallocator(new ReleaseDeallocator(m));
            }
            return m;
        }

        public void release() {
            this.deallocate();
        }

        protected static class ReleaseDeallocator
        extends opencv_core.CvMatND
        implements Pointer.Deallocator {
            ReleaseDeallocator(opencv_core.CvMatND p) {
                super(p);
            }

            public void deallocate() {
                org.bytedeco.javacpp.opencv_core.cvReleaseMatND(this);
            }
        }
    }

    public static abstract class AbstractCvMat
    extends CvArr {
        private int fullSize = 0;
        private ByteBuffer byteBuffer = null;
        private ShortBuffer shortBuffer = null;
        private IntBuffer intBuffer = null;
        private FloatBuffer floatBuffer = null;
        private DoubleBuffer doubleBuffer = null;

        public AbstractCvMat() {
        }

        public AbstractCvMat(Pointer p) {
            super(p);
        }

        public static opencv_core.CvMat create(int rows, int cols, int type) {
            opencv_core.CvMat m = org.bytedeco.javacpp.opencv_core.cvCreateMat(rows, cols, type);
            if (m != null) {
                m.fullSize = m.size();
                m.deallocator(new ReleaseDeallocator(m));
            }
            return m;
        }

        public static opencv_core.CvMat create(int rows, int cols, int depth, int channels) {
            return AbstractCvMat.create(rows, cols, org.bytedeco.javacpp.opencv_core.CV_MAKETYPE(depth, channels));
        }

        public static opencv_core.CvMat create(int rows, int cols) {
            return AbstractCvMat.create(rows, cols, 6, 1);
        }

        public static opencv_core.CvMat createHeader(int rows, int cols, int type) {
            opencv_core.CvMat m = org.bytedeco.javacpp.opencv_core.cvCreateMatHeader(rows, cols, type);
            if (m != null) {
                m.fullSize = m.size();
                m.deallocator(new ReleaseDeallocator(m));
            }
            return m;
        }

        public static opencv_core.CvMat createHeader(int rows, int cols, int depth, int channels) {
            return AbstractCvMat.createHeader(rows, cols, org.bytedeco.javacpp.opencv_core.CV_MAKETYPE(depth, channels));
        }

        public static opencv_core.CvMat createHeader(int rows, int cols) {
            return AbstractCvMat.createHeader(rows, cols, 6, 1);
        }

        public static ThreadLocal<opencv_core.CvMat> createThreadLocal(final int rows, final int cols, final int type) {
            return new ThreadLocal<opencv_core.CvMat>(){

                @Override
                protected opencv_core.CvMat initialValue() {
                    return AbstractCvMat.create(rows, cols, type);
                }
            };
        }

        public static ThreadLocal<opencv_core.CvMat> createThreadLocal(int rows, int cols, int depth, int channels) {
            return AbstractCvMat.createThreadLocal(rows, cols, org.bytedeco.javacpp.opencv_core.CV_MAKETYPE(depth, channels));
        }

        public static ThreadLocal<opencv_core.CvMat> createThreadLocal(int rows, int cols) {
            return AbstractCvMat.createThreadLocal(rows, cols, 6, 1);
        }

        public static ThreadLocal<opencv_core.CvMat> createHeaderThreadLocal(final int rows, final int cols, final int type) {
            return new ThreadLocal<opencv_core.CvMat>(){

                @Override
                protected opencv_core.CvMat initialValue() {
                    return AbstractCvMat.createHeader(rows, cols, type);
                }
            };
        }

        public static ThreadLocal<opencv_core.CvMat> createHeaderThreadLocal(int rows, int cols, int depth, int channels) {
            return AbstractCvMat.createHeaderThreadLocal(rows, cols, org.bytedeco.javacpp.opencv_core.CV_MAKETYPE(depth, channels));
        }

        public static ThreadLocal<opencv_core.CvMat> createHeaderThreadLocal(int rows, int cols) {
            return AbstractCvMat.createHeaderThreadLocal(rows, cols, 6, 1);
        }

        public opencv_core.CvMat clone() {
            opencv_core.CvMat m = org.bytedeco.javacpp.opencv_core.cvCloneMat((opencv_core.CvMat)this);
            if (m != null) {
                m.deallocator(new ReleaseDeallocator(m));
            }
            return m;
        }

        public void release() {
            this.deallocate();
        }

        public abstract int type();

        public abstract opencv_core.CvMat type(int var1);

        public abstract int step();

        public abstract BytePointer data_ptr();

        public abstract FloatPointer data_fl();

        public abstract DoublePointer data_db();

        public abstract IntPointer data_i();

        public abstract ShortPointer data_s();

        public abstract int rows();

        public abstract int cols();

        public int matType() {
            return org.bytedeco.javacpp.opencv_core.CV_MAT_TYPE(this.type());
        }

        public void type(int depth, int cn) {
            this.type(org.bytedeco.javacpp.opencv_core.CV_MAKETYPE(depth, cn) | 0x42420000);
        }

        public int depth() {
            return org.bytedeco.javacpp.opencv_core.CV_MAT_DEPTH(this.type());
        }

        public int channels() {
            return org.bytedeco.javacpp.opencv_core.CV_MAT_CN(this.type());
        }

        public int nChannels() {
            return org.bytedeco.javacpp.opencv_core.CV_MAT_CN(this.type());
        }

        public boolean isContinuous() {
            return org.bytedeco.javacpp.opencv_core.CV_IS_MAT_CONT(this.type()) != 0;
        }

        public int elemSize() {
            switch (this.depth()) {
                case 0: 
                case 1: {
                    return 1;
                }
                case 2: 
                case 3: {
                    return 2;
                }
                case 4: 
                case 5: {
                    return 4;
                }
                case 6: {
                    return 8;
                }
            }
            assert (false);
            return 0;
        }

        public int length() {
            return this.rows() * this.cols();
        }

        public int total() {
            return this.rows() * this.cols();
        }

        public boolean empty() {
            return this.length() == 0;
        }

        public int size() {
            int rows = this.rows();
            return this.cols() * this.elemSize() * this.channels() + (rows > 1 ? this.step() * (rows - 1) : 0);
        }

        @Override
        public int arrayChannels() {
            return this.channels();
        }

        @Override
        public int arrayDepth() {
            switch (this.depth()) {
                case 0: {
                    return 8;
                }
                case 1: {
                    return -2147483640;
                }
                case 2: {
                    return 16;
                }
                case 3: {
                    return -2147483632;
                }
                case 4: {
                    return -2147483616;
                }
                case 5: {
                    return 32;
                }
                case 6: {
                    return 64;
                }
            }
            assert (false);
            return -1;
        }

        @Override
        public int arrayOrigin() {
            return 0;
        }

        @Override
        public void arrayOrigin(int origin) {
        }

        @Override
        public int arrayWidth() {
            return this.cols();
        }

        @Override
        public int arrayHeight() {
            return this.rows();
        }

        @Override
        public opencv_core.IplROI arrayROI() {
            return null;
        }

        @Override
        public int arraySize() {
            return this.size();
        }

        @Override
        public BytePointer arrayData() {
            return this.data_ptr();
        }

        @Override
        public int arrayStep() {
            return this.step();
        }

        public void reset() {
            this.fullSize = 0;
            this.byteBuffer = null;
            this.shortBuffer = null;
            this.intBuffer = null;
            this.floatBuffer = null;
            this.doubleBuffer = null;
        }

        private int fullSize() {
            return this.fullSize > 0 ? this.fullSize : (this.fullSize = this.size());
        }

        @Override
        public ByteBuffer getByteBuffer() {
            if (this.byteBuffer == null) {
                this.byteBuffer = this.data_ptr().capacity(this.fullSize()).asBuffer();
            }
            this.byteBuffer.position(0);
            return this.byteBuffer;
        }

        @Override
        public ShortBuffer getShortBuffer() {
            if (this.shortBuffer == null) {
                this.shortBuffer = this.data_s().capacity(this.fullSize() / 2).asBuffer();
            }
            this.shortBuffer.position(0);
            return this.shortBuffer;
        }

        @Override
        public IntBuffer getIntBuffer() {
            if (this.intBuffer == null) {
                this.intBuffer = this.data_i().capacity(this.fullSize() / 4).asBuffer();
            }
            this.intBuffer.position(0);
            return this.intBuffer;
        }

        @Override
        public FloatBuffer getFloatBuffer() {
            if (this.floatBuffer == null) {
                this.floatBuffer = this.data_fl().capacity(this.fullSize() / 4).asBuffer();
            }
            this.floatBuffer.position(0);
            return this.floatBuffer;
        }

        @Override
        public DoubleBuffer getDoubleBuffer() {
            if (this.doubleBuffer == null) {
                this.doubleBuffer = this.data_db().capacity(this.fullSize() / 8).asBuffer();
            }
            this.doubleBuffer.position(0);
            return this.doubleBuffer;
        }

        public double get(int i) {
            switch (this.depth()) {
                case 0: {
                    return this.getByteBuffer().get(i) & 0xFF;
                }
                case 1: {
                    return this.getByteBuffer().get(i);
                }
                case 2: {
                    return this.getShortBuffer().get(i) & 0xFFFF;
                }
                case 3: {
                    return this.getShortBuffer().get(i);
                }
                case 4: {
                    return this.getIntBuffer().get(i);
                }
                case 5: {
                    return this.getFloatBuffer().get(i);
                }
                case 6: {
                    return this.getDoubleBuffer().get(i);
                }
            }
            assert (false);
            return Double.NaN;
        }

        public double get(int i, int j) {
            return this.get(i * this.step() / this.elemSize() + j * this.channels());
        }

        public double get(int i, int j, int k) {
            return this.get(i * this.step() / this.elemSize() + j * this.channels() + k);
        }

        public synchronized opencv_core.CvMat get(int index, double[] vv, int offset, int length) {
            int d = this.depth();
            switch (d) {
                case 0: 
                case 1: {
                    ByteBuffer bb = this.getByteBuffer();
                    bb.position(index);
                    for (int i = 0; i < length; ++i) {
                        vv[i + offset] = d == 0 ? (double)(bb.get(i) & 0xFF) : (double)bb.get(i);
                    }
                    break;
                }
                case 2: 
                case 3: {
                    ShortBuffer sb = this.getShortBuffer();
                    sb.position(index);
                    for (int i = 0; i < length; ++i) {
                        vv[i + offset] = d == 2 ? (double)(sb.get() & 0xFFFF) : (double)sb.get();
                    }
                    break;
                }
                case 4: {
                    IntBuffer ib = this.getIntBuffer();
                    ib.position(index);
                    for (int i = 0; i < length; ++i) {
                        vv[i + offset] = ib.get();
                    }
                    break;
                }
                case 5: {
                    FloatBuffer fb = this.getFloatBuffer();
                    fb.position(index);
                    for (int i = 0; i < length; ++i) {
                        vv[i + offset] = fb.get();
                    }
                    break;
                }
                case 6: {
                    this.getDoubleBuffer().position(index);
                    this.getDoubleBuffer().get(vv, offset, length);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return (opencv_core.CvMat)this;
        }

        public opencv_core.CvMat get(int index, double[] vv) {
            return this.get(index, vv, 0, vv.length);
        }

        public opencv_core.CvMat get(double[] vv) {
            return this.get(0, vv);
        }

        public double[] get() {
            double[] vv = new double[this.fullSize() / this.elemSize()];
            this.get(vv);
            return vv;
        }

        public opencv_core.CvMat put(int i, double v) {
            switch (this.depth()) {
                case 0: 
                case 1: {
                    this.getByteBuffer().put(i, (byte)v);
                    break;
                }
                case 2: 
                case 3: {
                    this.getShortBuffer().put(i, (short)v);
                    break;
                }
                case 4: {
                    this.getIntBuffer().put(i, (int)v);
                    break;
                }
                case 5: {
                    this.getFloatBuffer().put(i, (float)v);
                    break;
                }
                case 6: {
                    this.getDoubleBuffer().put(i, v);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return (opencv_core.CvMat)this;
        }

        public opencv_core.CvMat put(int i, int j, double v) {
            return this.put(i * this.step() / this.elemSize() + j * this.channels(), v);
        }

        public opencv_core.CvMat put(int i, int j, int k, double v) {
            return this.put(i * this.step() / this.elemSize() + j * this.channels() + k, v);
        }

        public synchronized opencv_core.CvMat put(int index, double[] vv, int offset, int length) {
            switch (this.depth()) {
                case 0: 
                case 1: {
                    ByteBuffer bb = this.getByteBuffer();
                    bb.position(index);
                    for (int i = 0; i < length; ++i) {
                        bb.put((byte)vv[i + offset]);
                    }
                    break;
                }
                case 2: 
                case 3: {
                    ShortBuffer sb = this.getShortBuffer();
                    sb.position(index);
                    for (int i = 0; i < length; ++i) {
                        sb.put((short)vv[i + offset]);
                    }
                    break;
                }
                case 4: {
                    IntBuffer ib = this.getIntBuffer();
                    ib.position(index);
                    for (int i = 0; i < length; ++i) {
                        ib.put((int)vv[i + offset]);
                    }
                    break;
                }
                case 5: {
                    FloatBuffer fb = this.getFloatBuffer();
                    fb.position(index);
                    for (int i = 0; i < length; ++i) {
                        fb.put((float)vv[i + offset]);
                    }
                    break;
                }
                case 6: {
                    DoubleBuffer db = this.getDoubleBuffer();
                    db.position(index);
                    db.put(vv, offset, length);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return (opencv_core.CvMat)this;
        }

        public opencv_core.CvMat put(int index, double ... vv) {
            return this.put(index, vv, 0, vv.length);
        }

        public opencv_core.CvMat put(double ... vv) {
            return this.put(0, vv);
        }

        public opencv_core.CvMat put(opencv_core.CvMat mat) {
            return this.put(0, 0, 0, mat, 0, 0, 0);
        }

        public synchronized opencv_core.CvMat put(int dsti, int dstj, int dstk, opencv_core.CvMat mat, int srci, int srcj, int srck) {
            if (this.rows() == mat.rows() && this.cols() == mat.cols() && this.step() == mat.step() && this.type() == mat.type() && dsti == 0 && dstj == 0 && dstk == 0 && srci == 0 && srcj == 0 && srck == 0) {
                this.getByteBuffer().clear();
                mat.getByteBuffer().clear();
                this.getByteBuffer().put(mat.getByteBuffer());
            } else {
                int w = Math.min(this.rows() - dsti, mat.rows() - srci);
                int h = Math.min(this.cols() - dstj, mat.cols() - srcj);
                int d = Math.min(this.channels() - dstk, mat.channels() - srck);
                for (int i = 0; i < w; ++i) {
                    for (int j = 0; j < h; ++j) {
                        for (int k = 0; k < d; ++k) {
                            this.put(i + dsti, j + dstj, k + dstk, mat.get(i + srci, j + srcj, k + srck));
                        }
                    }
                }
            }
            return (opencv_core.CvMat)this;
        }

        public opencv_core.IplImage asIplImage() {
            opencv_core.IplImage image = new opencv_core.IplImage();
            org.bytedeco.javacpp.opencv_core.cvGetImage(this, image);
            return image;
        }

        @Override
        public String toString() {
            return this.toString(0);
        }

        public String toString(int indent) {
            StringBuilder s = new StringBuilder("[ ");
            int channels = this.channels();
            for (int i = 0; i < this.rows(); ++i) {
                int j;
                for (j = 0; j < this.cols(); ++j) {
                    opencv_core.CvScalar v = org.bytedeco.javacpp.opencv_core.cvGet2D(this, i, j);
                    if (channels > 1) {
                        s.append("(");
                    }
                    for (int k = 0; k < channels; ++k) {
                        s.append((float)v.val(k));
                        if (k >= channels - 1) continue;
                        s.append(", ");
                    }
                    if (channels > 1) {
                        s.append(")");
                    }
                    if (j >= this.cols() - 1) continue;
                    s.append(", ");
                }
                if (i >= this.rows() - 1) continue;
                s.append("\n  ");
                for (j = 0; j < indent; ++j) {
                    s.append(' ');
                }
            }
            s.append(" ]");
            return s.toString();
        }

        protected static class ReleaseDeallocator
        extends opencv_core.CvMat
        implements Pointer.Deallocator {
            ReleaseDeallocator(opencv_core.CvMat m) {
                super(m);
            }

            public void deallocate() {
                org.bytedeco.javacpp.opencv_core.cvReleaseMat(this);
            }
        }
    }

    public static abstract class AbstractIplImage
    extends CvArr {
        public AbstractIplImage() {
        }

        public AbstractIplImage(Pointer p) {
            super(p);
        }

        public static opencv_core.IplImage create(opencv_core.CvSize size, int depth, int channels) {
            opencv_core.IplImage i = org.bytedeco.javacpp.opencv_core.cvCreateImage(size, depth, channels);
            if (i != null) {
                i.deallocator(new ReleaseDeallocator(i));
            }
            return i;
        }

        public static opencv_core.IplImage create(int width, int height, int depth, int channels) {
            return AbstractIplImage.create(org.bytedeco.javacpp.opencv_core.cvSize(width, height), depth, channels);
        }

        public static opencv_core.IplImage create(opencv_core.CvSize size, int depth, int channels, int origin) {
            opencv_core.IplImage i = AbstractIplImage.create(size, depth, channels);
            if (i != null) {
                i.origin(origin);
            }
            return i;
        }

        public static opencv_core.IplImage create(int width, int height, int depth, int channels, int origin) {
            opencv_core.IplImage i = AbstractIplImage.create(width, height, depth, channels);
            if (i != null) {
                i.origin(origin);
            }
            return i;
        }

        public static opencv_core.IplImage createHeader(opencv_core.CvSize size, int depth, int channels) {
            opencv_core.IplImage i = org.bytedeco.javacpp.opencv_core.cvCreateImageHeader(size, depth, channels);
            if (i != null) {
                i.deallocator(new HeaderReleaseDeallocator(i));
            }
            return i;
        }

        public static opencv_core.IplImage createHeader(int width, int height, int depth, int channels) {
            return AbstractIplImage.createHeader(org.bytedeco.javacpp.opencv_core.cvSize(width, height), depth, channels);
        }

        public static opencv_core.IplImage createHeader(opencv_core.CvSize size, int depth, int channels, int origin) {
            opencv_core.IplImage i = AbstractIplImage.createHeader(size, depth, channels);
            if (i != null) {
                i.origin(origin);
            }
            return i;
        }

        public static opencv_core.IplImage createHeader(int width, int height, int depth, int channels, int origin) {
            opencv_core.IplImage i = AbstractIplImage.createHeader(width, height, depth, channels);
            if (i != null) {
                i.origin(origin);
            }
            return i;
        }

        public static opencv_core.IplImage createCompatible(opencv_core.IplImage template) {
            return AbstractIplImage.createIfNotCompatible(null, template);
        }

        public static opencv_core.IplImage createIfNotCompatible(opencv_core.IplImage image, opencv_core.IplImage template) {
            if (image == null || image.width() != template.width() || image.height() != template.height() || image.depth() != template.depth() || image.nChannels() != template.nChannels()) {
                image = AbstractIplImage.create(template.width(), template.height(), template.depth(), template.nChannels(), template.origin());
                if (template.bufferedImage != null) {
                    template.bufferedImage = template.cloneBufferedImage();
                }
            }
            image.origin(template.origin());
            return image;
        }

        public static opencv_core.IplImage createFrom(BufferedImage image) {
            return AbstractIplImage.createFrom(image, 1.0);
        }

        public static opencv_core.IplImage createFrom(BufferedImage image, double gamma) {
            return AbstractIplImage.createFrom(image, gamma, false);
        }

        public static opencv_core.IplImage createFrom(BufferedImage image, double gamma, boolean flipChannels) {
            if (image == null) {
                return null;
            }
            SampleModel sm = image.getSampleModel();
            int depth = 0;
            int numChannels = sm.getNumBands();
            switch (image.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    depth = 8;
                    numChannels = 4;
                }
            }
            if (depth == 0 || numChannels == 0) {
                switch (sm.getDataType()) {
                    case 0: {
                        depth = 8;
                        break;
                    }
                    case 1: {
                        depth = 16;
                        break;
                    }
                    case 2: {
                        depth = -2147483632;
                        break;
                    }
                    case 3: {
                        depth = -2147483616;
                        break;
                    }
                    case 4: {
                        depth = 32;
                        break;
                    }
                    case 5: {
                        depth = 64;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            opencv_core.IplImage i = AbstractIplImage.create(image.getWidth(), image.getHeight(), depth, numChannels);
            i.copyFrom(image, gamma, flipChannels);
            return i;
        }

        public opencv_core.IplImage clone() {
            opencv_core.IplImage i = org.bytedeco.javacpp.opencv_core.cvCloneImage((opencv_core.IplImage)this);
            if (i != null) {
                i.deallocator(new ReleaseDeallocator(i));
            }
            if (i != null && this.bufferedImage != null) {
                i.bufferedImage = this.cloneBufferedImage();
            }
            return i;
        }

        public void release() {
            this.deallocate();
        }

        public abstract int nChannels();

        public abstract int depth();

        public abstract int origin();

        public abstract opencv_core.IplImage origin(int var1);

        public abstract int width();

        public abstract int height();

        public abstract opencv_core.IplROI roi();

        public abstract int imageSize();

        public abstract BytePointer imageData();

        public abstract int widthStep();

        @Override
        public int arrayChannels() {
            return this.nChannels();
        }

        @Override
        public int arrayDepth() {
            return this.depth();
        }

        @Override
        public int arrayOrigin() {
            return this.origin();
        }

        @Override
        public void arrayOrigin(int origin) {
            this.origin(origin);
        }

        @Override
        public int arrayWidth() {
            return this.width();
        }

        @Override
        public int arrayHeight() {
            return this.height();
        }

        @Override
        public opencv_core.IplROI arrayROI() {
            return this.roi();
        }

        @Override
        public int arraySize() {
            return this.imageSize();
        }

        @Override
        public BytePointer arrayData() {
            return this.imageData();
        }

        @Override
        public int arrayStep() {
            return this.widthStep();
        }

        public opencv_core.CvMat asCvMat() {
            opencv_core.CvMat mat = new opencv_core.CvMat();
            org.bytedeco.javacpp.opencv_core.cvGetMat((CvArr)this, mat, (IntPointer)null, 0);
            return mat;
        }

        @Override
        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            return "IplImage[width=" + this.width() + ",height=" + this.height() + ",depth=" + this.depth() + ",nChannels=" + this.nChannels() + "]";
        }

        protected static class HeaderReleaseDeallocator
        extends opencv_core.IplImage
        implements Pointer.Deallocator {
            HeaderReleaseDeallocator(opencv_core.IplImage p) {
                super(p);
            }

            public void deallocate() {
                org.bytedeco.javacpp.opencv_core.cvReleaseImageHeader(this);
            }
        }

        protected static class ReleaseDeallocator
        extends opencv_core.IplImage
        implements Pointer.Deallocator {
            ReleaseDeallocator(opencv_core.IplImage p) {
                super(p);
            }

            public void deallocate() {
                org.bytedeco.javacpp.opencv_core.cvReleaseImage(this);
            }
        }
    }

    @Name(value={"IplImage*"})
    public static class IplImageArray
    extends CvArrArray {
        public IplImageArray(opencv_core.IplImage ... array) {
            this(array.length);
            this.put(array);
            this.position(0);
        }

        public IplImageArray(int size) {
            super(new CvArr[0]);
            this.allocateArray(size);
        }

        public IplImageArray(Pointer p) {
            super(p);
        }

        private native void allocateArray(int var1);

        @Override
        public IplImageArray position(int position) {
            return (IplImageArray)super.position(position);
        }

        @Override
        public IplImageArray put(CvArr ... array) {
            return (IplImageArray)super.put(array);
        }

        @Override
        @ValueGetter
        public native opencv_core.IplImage get();

        @Override
        public IplImageArray put(CvArr p) {
            if (p instanceof opencv_core.IplImage) {
                return (IplImageArray)super.put(p);
            }
            throw new ArrayStoreException(((Object)((Object)p)).getClass().getName());
        }
    }

    @Name(value={"CvMatND*"})
    public static class CvMatNDArray
    extends CvArrArray {
        public CvMatNDArray(opencv_core.CvMatND ... array) {
            this(array.length);
            this.put(array);
            this.position(0);
        }

        public CvMatNDArray(int size) {
            super(new CvArr[0]);
            this.allocateArray(size);
        }

        public CvMatNDArray(Pointer p) {
            super(p);
        }

        private native void allocateArray(int var1);

        @Override
        public CvMatNDArray position(int position) {
            return (CvMatNDArray)super.position(position);
        }

        @Override
        public CvMatNDArray put(CvArr ... array) {
            return (CvMatNDArray)super.put(array);
        }

        @Override
        @ValueGetter
        public native opencv_core.CvMatND get();

        @Override
        public CvMatNDArray put(CvArr p) {
            if (p instanceof opencv_core.CvMatND) {
                return (CvMatNDArray)super.put(p);
            }
            throw new ArrayStoreException(((Object)((Object)p)).getClass().getName());
        }
    }

    @Name(value={"CvMat*"})
    public static class CvMatArray
    extends CvArrArray {
        public CvMatArray(opencv_core.CvMat ... array) {
            this(array.length);
            this.put(array);
            this.position(0);
        }

        public CvMatArray(int size) {
            super(new CvArr[0]);
            this.allocateArray(size);
        }

        public CvMatArray(Pointer p) {
            super(p);
        }

        private native void allocateArray(int var1);

        @Override
        public CvMatArray position(int position) {
            return (CvMatArray)super.position(position);
        }

        @Override
        public CvMatArray put(CvArr ... array) {
            return (CvMatArray)super.put(array);
        }

        @Override
        @ValueGetter
        public native opencv_core.CvMat get();

        @Override
        public CvMatArray put(CvArr p) {
            if (p instanceof opencv_core.CvMat) {
                return (CvMatArray)super.put(p);
            }
            throw new ArrayStoreException(((Object)((Object)p)).getClass().getName());
        }
    }

    @Name(value={"CvArr*"})
    public static class CvArrArray
    extends PointerPointer<CvArr> {
        public CvArrArray(CvArr ... array) {
            this(array.length);
            this.put(array);
            this.position(0);
        }

        public CvArrArray(int size) {
            super(size);
            this.allocateArray(size);
        }

        public CvArrArray(Pointer p) {
            super(p);
        }

        private native void allocateArray(int var1);

        public CvArrArray position(int position) {
            return (CvArrArray)super.position(position);
        }

        public CvArrArray put(CvArr ... array) {
            for (int i = 0; i < array.length; ++i) {
                this.position(i).put(array[i]);
            }
            return this;
        }

        public native CvArr get();

        public native CvArrArray put(CvArr var1);

        static {
            Loader.load();
        }
    }

    @Opaque
    public static class CvArr
    extends AbstractArray {
        public CvArr() {
        }

        public CvArr(Pointer p) {
            super(p);
        }

        @Override
        public int arrayChannels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int arrayDepth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int arrayOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void arrayOrigin(int origin) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int arrayWidth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int arrayHeight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public opencv_core.IplROI arrayROI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int arraySize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytePointer arrayData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int arrayStep() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class AbstractArray
    extends Pointer {
        public static final byte[] gamma22 = new byte[256];
        public static final byte[] gamma22inv = new byte[256];
        protected Object bufferedImage = null;

        public AbstractArray() {
        }

        public AbstractArray(Pointer p) {
            super(p);
        }

        public abstract int arrayChannels();

        public abstract int arrayDepth();

        public abstract int arrayOrigin();

        public abstract void arrayOrigin(int var1);

        public abstract int arrayWidth();

        public abstract int arrayHeight();

        public abstract opencv_core.IplROI arrayROI();

        public abstract int arraySize();

        public abstract BytePointer arrayData();

        public abstract int arrayStep();

        protected BufferedImage cloneBufferedImage() {
            if (this.bufferedImage == null) {
                return null;
            }
            BufferedImage bi = (BufferedImage)this.bufferedImage;
            int type = bi.getType();
            if (type == 0) {
                return new BufferedImage(bi.getColorModel(), bi.copyData(null), bi.isAlphaPremultiplied(), null);
            }
            return new BufferedImage(bi.getWidth(), bi.getHeight(), type);
        }

        public double highValue() {
            double highValue = 0.0;
            switch (this.arrayDepth()) {
                case 8: {
                    highValue = 255.0;
                    break;
                }
                case 16: {
                    highValue = 65535.0;
                    break;
                }
                case -2147483640: {
                    highValue = 127.0;
                    break;
                }
                case -2147483632: {
                    highValue = 32767.0;
                    break;
                }
                case -2147483616: {
                    highValue = 2.147483647E9;
                    break;
                }
                case 1: 
                case 32: 
                case 64: {
                    highValue = 1.0;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return highValue;
        }

        public opencv_core.CvSize cvSize() {
            return org.bytedeco.javacpp.opencv_core.cvSize(this.arrayWidth(), this.arrayHeight());
        }

        public ByteBuffer getByteBuffer(int index) {
            return this.arrayData().position(index).capacity(this.arraySize()).asByteBuffer();
        }

        public ShortBuffer getShortBuffer(int index) {
            return this.getByteBuffer(index * 2).asShortBuffer();
        }

        public IntBuffer getIntBuffer(int index) {
            return this.getByteBuffer(index * 4).asIntBuffer();
        }

        public FloatBuffer getFloatBuffer(int index) {
            return this.getByteBuffer(index * 4).asFloatBuffer();
        }

        public DoubleBuffer getDoubleBuffer(int index) {
            return this.getByteBuffer(index * 8).asDoubleBuffer();
        }

        public ByteBuffer getByteBuffer() {
            return this.getByteBuffer(0);
        }

        public ShortBuffer getShortBuffer() {
            return this.getShortBuffer(0);
        }

        public IntBuffer getIntBuffer() {
            return this.getIntBuffer(0);
        }

        public FloatBuffer getFloatBuffer() {
            return this.getFloatBuffer(0);
        }

        public DoubleBuffer getDoubleBuffer() {
            return this.getDoubleBuffer(0);
        }

        public static int decodeGamma22(int value) {
            return gamma22[value & 0xFF] & 0xFF;
        }

        public static int encodeGamma22(int value) {
            return gamma22inv[value & 0xFF] & 0xFF;
        }

        public static void flipCopyWithGamma(ByteBuffer srcBuf, int srcStep, ByteBuffer dstBuf, int dstStep, boolean signed, double gamma, boolean flip, int channels) {
            assert (srcBuf != dstBuf);
            int w = Math.min(srcStep, dstStep);
            int srcLine = srcBuf.position();
            byte[] buffer = new byte[channels];
            for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
                byte out;
                int in;
                int z;
                int x;
                if (flip) {
                    srcBuf.position(srcBuf.capacity() - srcLine - srcStep);
                } else {
                    srcBuf.position(srcLine);
                }
                dstBuf.position(dstLine);
                w = Math.min(Math.min(w, srcBuf.remaining()), dstBuf.remaining());
                if (signed) {
                    if (channels > 1) {
                        for (x = 0; x < w; x += channels) {
                            for (z = 0; z < channels; ++z) {
                                in = srcBuf.get();
                                byte out2 = gamma == 1.0 ? (byte)in : (byte)Math.round(Math.pow((double)in / 127.0, gamma) * 127.0);
                                buffer[z] = out2;
                            }
                            for (z = channels - 1; z >= 0; --z) {
                                dstBuf.put(buffer[z]);
                            }
                        }
                        continue;
                    }
                    for (x = 0; x < w; ++x) {
                        byte in2 = srcBuf.get();
                        out = gamma == 1.0 ? (byte)in2 : (byte)Math.round(Math.pow((double)in2 / 127.0, gamma) * 127.0);
                        dstBuf.put(out);
                    }
                    continue;
                }
                if (channels > 1) {
                    for (x = 0; x < w; x += channels) {
                        for (z = 0; z < channels; ++z) {
                            int in3 = srcBuf.get() & 0xFF;
                            out = gamma == 1.0 ? (byte)in3 : (gamma == 2.2 ? gamma22[in3] : (gamma == 0.45454545454545453 ? gamma22inv[in3] : (byte)Math.round(Math.pow((double)in3 / 255.0, gamma) * 255.0)));
                            buffer[z] = out;
                        }
                        for (z = channels - 1; z >= 0; --z) {
                            dstBuf.put(buffer[z]);
                        }
                    }
                    continue;
                }
                for (x = 0; x < w; ++x) {
                    in = srcBuf.get() & 0xFF;
                    byte out3 = gamma == 1.0 ? (byte)in : (gamma == 2.2 ? gamma22[in] : (gamma == 0.45454545454545453 ? gamma22inv[in] : (byte)Math.round(Math.pow((double)in / 255.0, gamma) * 255.0)));
                    dstBuf.put(out3);
                }
            }
        }

        public static void flipCopyWithGamma(ShortBuffer srcBuf, int srcStep, ShortBuffer dstBuf, int dstStep, boolean signed, double gamma, boolean flip, int channels) {
            assert (srcBuf != dstBuf);
            int w = Math.min(srcStep, dstStep);
            int srcLine = srcBuf.position();
            short[] buffer = new short[channels];
            for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
                short out;
                int in;
                short out2;
                short in2;
                int z;
                int x;
                if (flip) {
                    srcBuf.position(srcBuf.capacity() - srcLine - srcStep);
                } else {
                    srcBuf.position(srcLine);
                }
                dstBuf.position(dstLine);
                w = Math.min(Math.min(w, srcBuf.remaining()), dstBuf.remaining());
                if (signed) {
                    if (channels > 1) {
                        for (x = 0; x < w; x += channels) {
                            for (z = 0; z < channels; ++z) {
                                in2 = srcBuf.get();
                                out2 = gamma == 1.0 ? (short)in2 : (short)Math.round(Math.pow((double)in2 / 32767.0, gamma) * 32767.0);
                                buffer[z] = out2;
                            }
                            for (z = channels - 1; z >= 0; --z) {
                                dstBuf.put(buffer[z]);
                            }
                        }
                        continue;
                    }
                    for (x = 0; x < w; ++x) {
                        in = srcBuf.get();
                        out = gamma == 1.0 ? (short)in : (short)Math.round(Math.pow((double)in / 32767.0, gamma) * 32767.0);
                        dstBuf.put(out);
                    }
                    continue;
                }
                if (channels > 1) {
                    for (x = 0; x < w; x += channels) {
                        for (z = 0; z < channels; ++z) {
                            in2 = srcBuf.get();
                            out2 = gamma == 1.0 ? (short)in2 : (short)Math.round(Math.pow((double)in2 / 65535.0, gamma) * 65535.0);
                            buffer[z] = out2;
                        }
                        for (z = channels - 1; z >= 0; --z) {
                            dstBuf.put(buffer[z]);
                        }
                    }
                    continue;
                }
                for (x = 0; x < w; ++x) {
                    in = srcBuf.get() & 0xFFFF;
                    out = gamma == 1.0 ? (short)in : (short)Math.round(Math.pow((double)in / 65535.0, gamma) * 65535.0);
                    dstBuf.put(out);
                }
            }
        }

        public static void flipCopyWithGamma(IntBuffer srcBuf, int srcStep, IntBuffer dstBuf, int dstStep, double gamma, boolean flip, int channels) {
            assert (srcBuf != dstBuf);
            int w = Math.min(srcStep, dstStep);
            int srcLine = srcBuf.position();
            int[] buffer = new int[channels];
            for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
                int x;
                if (flip) {
                    srcBuf.position(srcBuf.capacity() - srcLine - srcStep);
                } else {
                    srcBuf.position(srcLine);
                }
                dstBuf.position(dstLine);
                w = Math.min(Math.min(w, srcBuf.remaining()), dstBuf.remaining());
                if (channels > 1) {
                    for (x = 0; x < w; x += channels) {
                        int z;
                        for (z = 0; z < channels; ++z) {
                            int in = srcBuf.get();
                            int out = gamma == 1.0 ? in : (int)Math.round(Math.pow((double)in / 2.147483647E9, gamma) * 2.147483647E9);
                            buffer[z] = out;
                        }
                        for (z = channels - 1; z >= 0; --z) {
                            dstBuf.put(buffer[z]);
                        }
                    }
                    continue;
                }
                for (x = 0; x < w; ++x) {
                    int in = srcBuf.get();
                    int out = gamma == 1.0 ? in : (int)Math.round(Math.pow((double)in / 2.147483647E9, gamma) * 2.147483647E9);
                    dstBuf.put(out);
                }
            }
        }

        public static void flipCopyWithGamma(FloatBuffer srcBuf, int srcStep, FloatBuffer dstBuf, int dstStep, double gamma, boolean flip, int channels) {
            assert (srcBuf != dstBuf);
            int w = Math.min(srcStep, dstStep);
            int srcLine = srcBuf.position();
            float[] buffer = new float[channels];
            for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
                int x;
                if (flip) {
                    srcBuf.position(srcBuf.capacity() - srcLine - srcStep);
                } else {
                    srcBuf.position(srcLine);
                }
                dstBuf.position(dstLine);
                w = Math.min(Math.min(w, srcBuf.remaining()), dstBuf.remaining());
                if (channels > 1) {
                    for (x = 0; x < w; x += channels) {
                        int z;
                        for (z = 0; z < channels; ++z) {
                            float in = srcBuf.get();
                            float out = gamma == 1.0 ? in : (float)Math.pow(in, gamma);
                            buffer[z] = out;
                        }
                        for (z = channels - 1; z >= 0; --z) {
                            dstBuf.put(buffer[z]);
                        }
                    }
                    continue;
                }
                for (x = 0; x < w; ++x) {
                    float in = srcBuf.get();
                    float out = gamma == 1.0 ? in : (float)Math.pow(in, gamma);
                    dstBuf.put(out);
                }
            }
        }

        public static void flipCopyWithGamma(DoubleBuffer srcBuf, int srcStep, DoubleBuffer dstBuf, int dstStep, double gamma, boolean flip, int channels) {
            assert (srcBuf != dstBuf);
            int w = Math.min(srcStep, dstStep);
            int srcLine = srcBuf.position();
            double[] buffer = new double[channels];
            for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
                int x;
                if (flip) {
                    srcBuf.position(srcBuf.capacity() - srcLine - srcStep);
                } else {
                    srcBuf.position(srcLine);
                }
                dstBuf.position(dstLine);
                w = Math.min(Math.min(w, srcBuf.remaining()), dstBuf.remaining());
                if (channels > 1) {
                    for (x = 0; x < w; x += channels) {
                        int z;
                        for (z = 0; z < channels; ++z) {
                            double in = srcBuf.get();
                            double out = gamma == 1.0 ? in : Math.pow(in, gamma);
                            buffer[z] = out;
                        }
                        for (z = channels - 1; z >= 0; --z) {
                            dstBuf.put(buffer[z]);
                        }
                    }
                    continue;
                }
                for (x = 0; x < w; ++x) {
                    double in = srcBuf.get();
                    double out = gamma == 1.0 ? in : Math.pow(in, gamma);
                    dstBuf.put(out);
                }
            }
        }

        public void applyGamma(double gamma) {
            if (gamma == 1.0) {
                return;
            }
            switch (this.arrayDepth()) {
                case 8: {
                    AbstractArray.flipCopyWithGamma(this.getByteBuffer(), this.arrayStep(), this.getByteBuffer(), this.arrayStep(), false, gamma, false, 0);
                    break;
                }
                case -2147483640: {
                    AbstractArray.flipCopyWithGamma(this.getByteBuffer(), this.arrayStep(), this.getByteBuffer(), this.arrayStep(), true, gamma, false, 0);
                    break;
                }
                case 16: {
                    AbstractArray.flipCopyWithGamma(this.getShortBuffer(), this.arrayStep() / 2, this.getShortBuffer(), this.arrayStep() / 2, false, gamma, false, 0);
                    break;
                }
                case -2147483632: {
                    AbstractArray.flipCopyWithGamma(this.getShortBuffer(), this.arrayStep() / 2, this.getShortBuffer(), this.arrayStep() / 2, true, gamma, false, 0);
                    break;
                }
                case -2147483616: {
                    AbstractArray.flipCopyWithGamma(this.getFloatBuffer(), this.arrayStep() / 4, this.getFloatBuffer(), this.arrayStep() / 4, gamma, false, 0);
                    break;
                }
                case 32: {
                    AbstractArray.flipCopyWithGamma(this.getFloatBuffer(), this.arrayStep() / 4, this.getFloatBuffer(), this.arrayStep() / 4, gamma, false, 0);
                    break;
                }
                case 64: {
                    AbstractArray.flipCopyWithGamma(this.getDoubleBuffer(), this.arrayStep() / 8, this.getDoubleBuffer(), this.arrayStep() / 8, gamma, false, 0);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public void copyTo(BufferedImage image) {
            this.copyTo(image, 1.0);
        }

        public void copyTo(BufferedImage image, double gamma) {
            this.copyTo(image, gamma, false);
        }

        public void copyTo(BufferedImage image, double gamma, boolean flipChannels) {
            Rectangle r = null;
            opencv_core.IplROI roi = this.arrayROI();
            if (roi != null) {
                r = new Rectangle(roi.xOffset(), roi.yOffset(), roi.width(), roi.height());
            }
            this.copyTo(image, gamma, flipChannels, r);
        }

        public void copyTo(BufferedImage image, double gamma, boolean flipChannels, Rectangle roi) {
            boolean flip = this.arrayOrigin() == 1;
            ByteBuffer in = this.getByteBuffer(roi == null ? 0 : roi.y * this.arrayStep() + roi.x * this.arrayChannels());
            SampleModel sm = image.getSampleModel();
            WritableRaster r = image.getRaster();
            DataBuffer out = r.getDataBuffer();
            int x = -r.getSampleModelTranslateX();
            int y = -r.getSampleModelTranslateY();
            int step = sm.getWidth() * sm.getNumBands();
            int channels = sm.getNumBands();
            if (sm instanceof ComponentSampleModel) {
                step = ((ComponentSampleModel)sm).getScanlineStride();
                channels = ((ComponentSampleModel)sm).getPixelStride();
            } else if (sm instanceof SinglePixelPackedSampleModel) {
                step = ((SinglePixelPackedSampleModel)sm).getScanlineStride();
                channels = 1;
            } else if (sm instanceof MultiPixelPackedSampleModel) {
                step = ((MultiPixelPackedSampleModel)sm).getScanlineStride();
                channels = ((MultiPixelPackedSampleModel)sm).getPixelBitStride() / 8;
            }
            int start = y * step + x * channels;
            if (out instanceof DataBufferByte) {
                byte[] a = ((DataBufferByte)out).getData();
                AbstractArray.flipCopyWithGamma(in, this.arrayStep(), ByteBuffer.wrap(a, start, a.length - start), step, false, gamma, flip, flipChannels ? channels : 0);
            } else if (out instanceof DataBufferDouble) {
                double[] a = ((DataBufferDouble)out).getData();
                AbstractArray.flipCopyWithGamma(in.asDoubleBuffer(), this.arrayStep() / 8, DoubleBuffer.wrap(a, start, a.length - start), step, gamma, flip, flipChannels ? channels : 0);
            } else if (out instanceof DataBufferFloat) {
                float[] a = ((DataBufferFloat)out).getData();
                AbstractArray.flipCopyWithGamma(in.asFloatBuffer(), this.arrayStep() / 4, FloatBuffer.wrap(a, start, a.length - start), step, gamma, flip, flipChannels ? channels : 0);
            } else if (out instanceof DataBufferInt) {
                int[] a = ((DataBufferInt)out).getData();
                AbstractArray.flipCopyWithGamma(in.asIntBuffer(), this.arrayStep() / 4, IntBuffer.wrap(a, start, a.length - start), step, gamma, flip, flipChannels ? channels : 0);
            } else if (out instanceof DataBufferShort) {
                short[] a = ((DataBufferShort)out).getData();
                AbstractArray.flipCopyWithGamma(in.asShortBuffer(), this.arrayStep() / 2, ShortBuffer.wrap(a, start, a.length - start), step, true, gamma, flip, flipChannels ? channels : 0);
            } else if (out instanceof DataBufferUShort) {
                short[] a = ((DataBufferUShort)out).getData();
                AbstractArray.flipCopyWithGamma(in.asShortBuffer(), this.arrayStep() / 2, ShortBuffer.wrap(a, start, a.length - start), step, false, gamma, flip, flipChannels ? channels : 0);
            } else assert (false);
        }

        public void copyFrom(BufferedImage image) {
            this.copyFrom(image, 1.0);
        }

        public void copyFrom(BufferedImage image, double gamma) {
            this.copyFrom(image, gamma, false);
        }

        public void copyFrom(BufferedImage image, double gamma, boolean flipChannels) {
            Rectangle r = null;
            opencv_core.IplROI roi = this.arrayROI();
            if (roi != null) {
                r = new Rectangle(roi.xOffset(), roi.yOffset(), roi.width(), roi.height());
            }
            this.copyFrom(image, gamma, flipChannels, r);
        }

        public void copyFrom(BufferedImage image, double gamma, boolean flipChannels, Rectangle roi) {
            this.arrayOrigin(0);
            ByteBuffer out = this.getByteBuffer(roi == null ? 0 : roi.y * this.arrayStep() + roi.x);
            SampleModel sm = image.getSampleModel();
            WritableRaster r = image.getRaster();
            DataBuffer in = r.getDataBuffer();
            int x = -r.getSampleModelTranslateX();
            int y = -r.getSampleModelTranslateY();
            int step = sm.getWidth() * sm.getNumBands();
            int channels = sm.getNumBands();
            if (sm instanceof ComponentSampleModel) {
                step = ((ComponentSampleModel)sm).getScanlineStride();
                channels = ((ComponentSampleModel)sm).getPixelStride();
            } else if (sm instanceof SinglePixelPackedSampleModel) {
                step = ((SinglePixelPackedSampleModel)sm).getScanlineStride();
                channels = 1;
            } else if (sm instanceof MultiPixelPackedSampleModel) {
                step = ((MultiPixelPackedSampleModel)sm).getScanlineStride();
                channels = ((MultiPixelPackedSampleModel)sm).getPixelBitStride() / 8;
            }
            int start = y * step + x * channels;
            if (in instanceof DataBufferByte) {
                byte[] a = ((DataBufferByte)in).getData();
                AbstractArray.flipCopyWithGamma(ByteBuffer.wrap(a, start, a.length - start), step, out, this.arrayStep(), false, gamma, false, flipChannels ? channels : 0);
            } else if (in instanceof DataBufferDouble) {
                double[] a = ((DataBufferDouble)in).getData();
                AbstractArray.flipCopyWithGamma(DoubleBuffer.wrap(a, start, a.length - start), step, out.asDoubleBuffer(), this.arrayStep() / 8, gamma, false, flipChannels ? channels : 0);
            } else if (in instanceof DataBufferFloat) {
                float[] a = ((DataBufferFloat)in).getData();
                AbstractArray.flipCopyWithGamma(FloatBuffer.wrap(a, start, a.length - start), step, out.asFloatBuffer(), this.arrayStep() / 4, gamma, false, flipChannels ? channels : 0);
            } else if (in instanceof DataBufferInt) {
                int[] a = ((DataBufferInt)in).getData();
                AbstractArray.flipCopyWithGamma(IntBuffer.wrap(a, start, a.length - start), step, out.asIntBuffer(), this.arrayStep() / 4, gamma, false, flipChannels ? channels : 0);
            } else if (in instanceof DataBufferShort) {
                short[] a = ((DataBufferShort)in).getData();
                AbstractArray.flipCopyWithGamma(ShortBuffer.wrap(a, start, a.length - start), step, out.asShortBuffer(), this.arrayStep() / 2, true, gamma, false, flipChannels ? channels : 0);
            } else if (in instanceof DataBufferUShort) {
                short[] a = ((DataBufferUShort)in).getData();
                AbstractArray.flipCopyWithGamma(ShortBuffer.wrap(a, start, a.length - start), step, out.asShortBuffer(), this.arrayStep() / 2, false, gamma, false, flipChannels ? channels : 0);
            } else assert (false);
            if (this.bufferedImage == null && roi == null && image.getWidth() == this.arrayWidth() && image.getHeight() == this.arrayHeight()) {
                this.bufferedImage = image;
            }
        }

        public int getBufferedImageType() {
            int type = 0;
            if (this.arrayChannels() == 1) {
                if (this.arrayDepth() == 8 || this.arrayDepth() == -2147483640) {
                    type = 10;
                } else if (this.arrayDepth() == 16) {
                    type = 11;
                }
            } else if (this.arrayChannels() == 3) {
                if (this.arrayDepth() == 8 || this.arrayDepth() == -2147483640) {
                    type = 5;
                }
            } else if (this.arrayChannels() == 4 && (this.arrayDepth() == 8 || this.arrayDepth() == -2147483640)) {
                type = 6;
            }
            return type;
        }

        public BufferedImage getBufferedImage() {
            return this.getBufferedImage(1.0);
        }

        public BufferedImage getBufferedImage(double gamma) {
            return this.getBufferedImage(gamma, false);
        }

        public BufferedImage getBufferedImage(double gamma, boolean flipChannels) {
            return this.getBufferedImage(gamma, flipChannels, null);
        }

        public BufferedImage getBufferedImage(double gamma, boolean flipChannels, ColorSpace cs) {
            int type = this.getBufferedImageType();
            if (this.bufferedImage == null && type != 0 && cs == null) {
                this.bufferedImage = new BufferedImage(this.arrayWidth(), this.arrayHeight(), type);
            }
            if (this.bufferedImage == null) {
                boolean alpha = false;
                int[] offsets = null;
                if (this.arrayChannels() == 1) {
                    alpha = false;
                    if (cs == null) {
                        cs = ColorSpace.getInstance(1003);
                    }
                    offsets = new int[]{0};
                } else if (this.arrayChannels() == 3) {
                    alpha = false;
                    if (cs == null) {
                        cs = ColorSpace.getInstance(1004);
                    }
                    offsets = new int[]{2, 1, 0};
                } else if (this.arrayChannels() == 4) {
                    alpha = true;
                    if (cs == null) {
                        cs = ColorSpace.getInstance(1004);
                    }
                    offsets = new int[]{0, 1, 2, 3};
                } else assert (false);
                ComponentColorModel cm = null;
                WritableRaster wr = null;
                if (this.arrayDepth() == 8 || this.arrayDepth() == -2147483640) {
                    cm = new ComponentColorModel(cs, alpha, false, 1, 0);
                    wr = Raster.createWritableRaster(new ComponentSampleModel(0, this.arrayWidth(), this.arrayHeight(), this.arrayChannels(), this.arrayStep(), offsets), null);
                } else if (this.arrayDepth() == 16) {
                    cm = new ComponentColorModel(cs, alpha, false, 1, 1);
                    wr = Raster.createWritableRaster(new ComponentSampleModel(1, this.arrayWidth(), this.arrayHeight(), this.arrayChannels(), this.arrayStep() / 2, offsets), null);
                } else if (this.arrayDepth() == -2147483632) {
                    cm = new ComponentColorModel(cs, alpha, false, 1, 2);
                    wr = Raster.createWritableRaster(new ComponentSampleModel(2, this.arrayWidth(), this.arrayHeight(), this.arrayChannels(), this.arrayStep() / 2, offsets), null);
                } else if (this.arrayDepth() == -2147483616) {
                    cm = new ComponentColorModel(cs, alpha, false, 1, 3);
                    wr = Raster.createWritableRaster(new ComponentSampleModel(3, this.arrayWidth(), this.arrayHeight(), this.arrayChannels(), this.arrayStep() / 4, offsets), null);
                } else if (this.arrayDepth() == 32) {
                    cm = new ComponentColorModel(cs, alpha, false, 1, 4);
                    wr = Raster.createWritableRaster(new ComponentSampleModel(4, this.arrayWidth(), this.arrayHeight(), this.arrayChannels(), this.arrayStep() / 4, offsets), null);
                } else if (this.arrayDepth() == 64) {
                    cm = new ComponentColorModel(cs, alpha, false, 1, 5);
                    wr = Raster.createWritableRaster(new ComponentSampleModel(5, this.arrayWidth(), this.arrayHeight(), this.arrayChannels(), this.arrayStep() / 8, offsets), null);
                } else assert (false);
                this.bufferedImage = new BufferedImage(cm, wr, false, null);
            }
            if (this.bufferedImage != null) {
                opencv_core.IplROI roi = this.arrayROI();
                if (roi != null) {
                    this.copyTo(((BufferedImage)this.bufferedImage).getSubimage(roi.xOffset(), roi.yOffset(), roi.width(), roi.height()), gamma, flipChannels);
                } else {
                    this.copyTo((BufferedImage)this.bufferedImage, gamma, flipChannels);
                }
            }
            return (BufferedImage)this.bufferedImage;
        }

        public String toString() {
            if (this.isNull()) {
                return super.toString();
            }
            try {
                return "AbstractArray[width=" + this.arrayWidth() + ",height=" + this.arrayHeight() + ",depth=" + this.arrayDepth() + ",channels=" + this.arrayChannels() + "]";
            }
            catch (Exception e) {
                return super.toString();
            }
        }

        static {
            for (int i = 0; i < 256; ++i) {
                AbstractArray.gamma22[i] = (byte)Math.round(Math.pow((double)i / 255.0, 2.2) * 255.0);
                AbstractArray.gamma22inv[i] = (byte)Math.round(Math.pow((double)i / 255.0, 0.45454545454545453) * 255.0);
            }
        }
    }
}

