/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.studio.springboot;

import jakarta.servlet.Servlet;
import org.bsc.langgraph4j.studio.LangGraphStreamingServer;
import org.bsc.langgraph4j.studio.springboot.LangGraphFlow;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

public abstract class AbstractLangGraphStudioConfig {
    public abstract LangGraphFlow getFlow();

    @Bean
    public ServletRegistrationBean<LangGraphStreamingServer.GraphInitServlet> initServletBean() {
        LangGraphFlow flow = this.getFlow();
        LangGraphStreamingServer.GraphInitServlet initServlet = new LangGraphStreamingServer.GraphInitServlet(flow.stateGraph(), flow.title(), flow.inputArgs());
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)initServlet, new String[]{"/init"});
        bean.setLoadOnStartup(1);
        return bean;
    }

    @Bean
    public ServletRegistrationBean<LangGraphStreamingServer.GraphStreamServlet> streamingServletBean() {
        LangGraphFlow flow = this.getFlow();
        LangGraphStreamingServer.GraphStreamServlet initServlet = new LangGraphStreamingServer.GraphStreamServlet(flow.stateGraph(), flow.compileConfig(), flow.inputArgs());
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)initServlet, new String[]{"/stream"});
        bean.setLoadOnStartup(1);
        return bean;
    }
}

