/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PostLoad;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;

@Entity
@DiscriminatorValue(value="oauth")
public class OAuthRegisteredService
extends RegexRegisteredService {
    private static final long serialVersionUID = 5318897374067731021L;
    @Column(length=255, updatable=true, insertable=true)
    private String clientSecret;
    @Column(length=255, updatable=true, insertable=true)
    private String clientId;
    @Column(updatable=true, insertable=true)
    private Boolean bypassApprovalPrompt = Boolean.FALSE;
    @Column(updatable=true, insertable=true)
    private Boolean generateRefreshToken = Boolean.FALSE;
    @Column(updatable=true, insertable=true)
    private Boolean jsonFormat = Boolean.FALSE;
    @Lob
    @Column(name="supported_grants", length=0x7FFFFFFF)
    private HashSet<String> supportedGrantTypes = new HashSet();
    @Lob
    @Column(name="supported_responses", length=0x7FFFFFFF)
    private HashSet<String> supportedResponseTypes = new HashSet();

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Boolean isBypassApprovalPrompt() {
        return this.bypassApprovalPrompt;
    }

    public void setBypassApprovalPrompt(Boolean bypassApprovalPrompt) {
        this.bypassApprovalPrompt = bypassApprovalPrompt;
    }

    public Boolean isGenerateRefreshToken() {
        return this.generateRefreshToken;
    }

    public void setGenerateRefreshToken(Boolean generateRefreshToken) {
        this.generateRefreshToken = generateRefreshToken;
    }

    public Boolean isJsonFormat() {
        return this.jsonFormat;
    }

    public void setJsonFormat(Boolean jsonFormat) {
        this.jsonFormat = jsonFormat;
    }

    public Set<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public void setSupportedGrantTypes(Set<String> supportedGrantTypes) {
        this.supportedGrantTypes = new HashSet<String>(supportedGrantTypes);
    }

    public Set<String> getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    public void setSupportedResponseTypes(Set<String> supportedResponseTypes) {
        this.supportedResponseTypes = new HashSet<String>(supportedResponseTypes);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.appendSuper(super.toString());
        builder.append("clientId", (Object)this.getClientId());
        builder.append("approvalPrompt", (Object)this.isBypassApprovalPrompt());
        builder.append("generateRefreshToken", (Object)this.isGenerateRefreshToken());
        builder.append("jsonFormat", (Object)this.isJsonFormat());
        builder.append("supportedResponseTypes", this.getSupportedResponseTypes());
        builder.append("supportedGrantTypes", this.getSupportedGrantTypes());
        return builder.toString();
    }

    public void copyFrom(RegisteredService source) {
        super.copyFrom(source);
        OAuthRegisteredService oAuthRegisteredService = (OAuthRegisteredService)source;
        this.setClientId(oAuthRegisteredService.getClientId());
        this.setClientSecret(oAuthRegisteredService.getClientSecret());
        this.setBypassApprovalPrompt(oAuthRegisteredService.isBypassApprovalPrompt());
        this.setGenerateRefreshToken(oAuthRegisteredService.isGenerateRefreshToken());
        this.setJsonFormat(oAuthRegisteredService.isJsonFormat());
        this.setSupportedGrantTypes(oAuthRegisteredService.getSupportedGrantTypes());
        this.setSupportedResponseTypes(oAuthRegisteredService.getSupportedResponseTypes());
    }

    protected AbstractRegisteredService newInstance() {
        return new OAuthRegisteredService();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        OAuthRegisteredService rhs = (OAuthRegisteredService)((Object)obj);
        EqualsBuilder builder = new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.clientSecret, (Object)rhs.clientSecret).append((Object)this.clientId, (Object)rhs.clientId).append((Object)this.bypassApprovalPrompt, (Object)rhs.bypassApprovalPrompt).append((Object)this.generateRefreshToken, (Object)rhs.generateRefreshToken).append((Object)this.jsonFormat, (Object)rhs.jsonFormat).append(this.supportedResponseTypes, rhs.supportedResponseTypes).append(this.supportedGrantTypes, rhs.supportedGrantTypes);
        return builder.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.clientSecret).append((Object)this.clientId).append((Object)this.bypassApprovalPrompt).append((Object)this.generateRefreshToken).append((Object)this.jsonFormat).append(this.supportedResponseTypes).append(this.supportedGrantTypes).toHashCode();
    }

    @PostLoad
    public void postLoad() {
        if (this.supportedGrantTypes == null) {
            this.supportedGrantTypes = new HashSet();
        }
        if (this.supportedResponseTypes == null) {
            this.supportedResponseTypes = new HashSet();
        }
    }

    @JsonIgnore
    public String getFriendlyName() {
        return "OAuth2 Client";
    }
}

