/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.parser.core;

import java.util.Collection;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.ReadwriteSplittingDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.ReadwriteSplittingDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.segment.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.AlterReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.CreateReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.DropReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.ShowReadwriteSplittingReadResourcesStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.ShowReadwriteSplittingRulesStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.hint.ClearReadwriteSplittingHintStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.hint.SetReadwriteSplittingHintStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.hint.ShowReadwriteSplittingHintStatusStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.status.SetReadwriteSplittingStatusStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ReadwriteSplittingDistSQLStatementVisitor
extends ReadwriteSplittingDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitCreateReadwriteSplittingRule(ReadwriteSplittingDistSQLStatementParser.CreateReadwriteSplittingRuleContext ctx) {
        return new CreateReadwriteSplittingRuleStatement((Collection)ctx.readwriteSplittingRuleDefinition().stream().map(each -> (ReadwriteSplittingRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterReadwriteSplittingRule(ReadwriteSplittingDistSQLStatementParser.AlterReadwriteSplittingRuleContext ctx) {
        return new AlterReadwriteSplittingRuleStatement((Collection)ctx.readwriteSplittingRuleDefinition().stream().map(each -> (ReadwriteSplittingRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropReadwriteSplittingRule(ReadwriteSplittingDistSQLStatementParser.DropReadwriteSplittingRuleContext ctx) {
        return new DropReadwriteSplittingRuleStatement(ctx.existClause() != null, (Collection)ctx.ruleName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitEnableReadDataSource(ReadwriteSplittingDistSQLStatementParser.EnableReadDataSourceContext ctx) {
        DatabaseSegment schemaSegment = Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null;
        return new SetReadwriteSplittingStatusStatement(ctx.ENABLE().getText().toUpperCase(), this.getIdentifierValue((ParseTree)ctx.resourceName()), schemaSegment);
    }

    @Override
    public ASTNode visitDisableReadDataSource(ReadwriteSplittingDistSQLStatementParser.DisableReadDataSourceContext ctx) {
        DatabaseSegment schemaSegment = Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null;
        return new SetReadwriteSplittingStatusStatement(ctx.DISABLE().getText().toUpperCase(), this.getIdentifierValue((ParseTree)ctx.resourceName()), schemaSegment);
    }

    @Override
    public ASTNode visitShowReadwriteSplittingRules(ReadwriteSplittingDistSQLStatementParser.ShowReadwriteSplittingRulesContext ctx) {
        return new ShowReadwriteSplittingRulesStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    @Override
    public ASTNode visitReadwriteSplittingRuleDefinition(ReadwriteSplittingDistSQLStatementParser.ReadwriteSplittingRuleDefinitionContext ctx) {
        Properties props = new Properties();
        String algorithmName = null;
        if (null != ctx.algorithmDefinition()) {
            algorithmName = this.getIdentifierValue((ParseTree)ctx.algorithmDefinition().algorithmName());
        }
        if (null != ctx.algorithmDefinition() && null != ctx.algorithmDefinition().algorithmProperties()) {
            ctx.algorithmDefinition().algorithmProperties().algorithmProperty().forEach(each -> props.setProperty(each.key.getText(), each.value.getText()));
        }
        if (null == ctx.staticReadwriteSplittingRuleDefinition()) {
            return new ReadwriteSplittingRuleSegment(this.getIdentifierValue((ParseTree)ctx.ruleName()), this.getIdentifierValue((ParseTree)ctx.dynamicReadwriteSplittingRuleDefinition().resourceName()), algorithmName, props);
        }
        ReadwriteSplittingDistSQLStatementParser.StaticReadwriteSplittingRuleDefinitionContext staticRuleDefinitionCtx = ctx.staticReadwriteSplittingRuleDefinition();
        return new ReadwriteSplittingRuleSegment(this.getIdentifierValue((ParseTree)ctx.ruleName()), this.getIdentifierValue((ParseTree)staticRuleDefinitionCtx.writeResourceName()), (Collection)staticRuleDefinitionCtx.readResourceNames().resourceName().stream().map(this::getIdentifierValue).collect(Collectors.toList()), algorithmName, props);
    }

    @Override
    public ASTNode visitDatabaseName(ReadwriteSplittingDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(ReadwriteSplittingDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmName()), this.getAlgorithmProperties(ctx));
    }

    @Override
    public ASTNode visitShowReadwriteSplittingReadResources(ReadwriteSplittingDistSQLStatementParser.ShowReadwriteSplittingReadResourcesContext ctx) {
        return new ShowReadwriteSplittingReadResourcesStatement(Objects.nonNull((Object)ctx.databaseName()) ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    @Override
    public ASTNode visitSetReadwriteSplittingHintSource(ReadwriteSplittingDistSQLStatementParser.SetReadwriteSplittingHintSourceContext ctx) {
        return new SetReadwriteSplittingHintStatement(this.getIdentifierValue((ParseTree)ctx.sourceValue()));
    }

    private String getIdentifierValue(ParseTree context) {
        if (null == context) {
            return null;
        }
        return new IdentifierValue(context.getText()).getValue();
    }

    @Override
    public ASTNode visitShowReadwriteSplittingHintStatus(ReadwriteSplittingDistSQLStatementParser.ShowReadwriteSplittingHintStatusContext ctx) {
        return new ShowReadwriteSplittingHintStatusStatement();
    }

    @Override
    public ASTNode visitClearReadwriteSplittingHint(ReadwriteSplittingDistSQLStatementParser.ClearReadwriteSplittingHintContext ctx) {
        return new ClearReadwriteSplittingHintStatement();
    }

    private Properties getAlgorithmProperties(ReadwriteSplittingDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx.algorithmProperties()) {
            return result;
        }
        for (ReadwriteSplittingDistSQLStatementParser.AlgorithmPropertyContext each : ctx.algorithmProperties().algorithmProperty()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }
}

