/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.function.ResourceRequiredRuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.DropReadwriteSplittingRuleStatement;

public final class DropReadwriteSplittingRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropReadwriteSplittingRuleStatement, ReadwriteSplittingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws RuleDefinitionViolationException {
        String schemaName = shardingSphereMetaData.getName();
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && sqlStatement.isContainsExistClause()) {
            return;
        }
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkToBeDroppedRuleNames(schemaName, sqlStatement, currentRuleConfig);
        this.checkToBeDroppedInUsed(schemaName, sqlStatement, shardingSphereMetaData);
    }

    private void checkCurrentRuleConfiguration(String schemaName, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Readwrite splitting", schemaName);
        }
    }

    private void checkToBeDroppedRuleNames(String schemaName, DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        Collection currentRuleNames = currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedRuleNames = sqlStatement.getRuleNames().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        if (!notExistedRuleNames.isEmpty()) {
            throw new RequiredRuleMissedException("Readwrite splitting", schemaName, sqlStatement.getRuleNames());
        }
    }

    private void checkToBeDroppedInUsed(String schemaName, DropReadwriteSplittingRuleStatement sqlStatement, ShardingSphereMetaData shardingSphereMetaData) throws RuleInUsedException {
        Collection resourceBeUsed = shardingSphereMetaData.getRuleMetaData().findRuleConfiguration(ResourceRequiredRuleConfiguration.class).stream().map(ResourceRequiredRuleConfiguration::getRequiredResource).flatMap(Collection::stream).collect(Collectors.toSet());
        Collection ruleInUsed = sqlStatement.getRuleNames().stream().filter(resourceBeUsed::contains).collect(Collectors.toSet());
        if (!ruleInUsed.isEmpty()) {
            throw new RuleInUsedException("Readwrite splitting", schemaName, ruleInUsed);
        }
    }

    public boolean updateCurrentRuleConfiguration(DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getRuleNames()) {
            this.dropRule(currentRuleConfig, each);
        }
        return currentRuleConfig.getDataSources().isEmpty();
    }

    private void dropRule(ReadwriteSplittingRuleConfiguration currentRuleConfig, String ruleName) {
        Optional<ReadwriteSplittingDataSourceRuleConfiguration> dataSourceRuleConfig = currentRuleConfig.getDataSources().stream().filter(dataSource -> ruleName.equals(dataSource.getName())).findAny();
        dataSourceRuleConfig.ifPresent(op -> {
            currentRuleConfig.getDataSources().remove(op);
            if (this.isLoadBalancerNotInUse(currentRuleConfig, op.getLoadBalancerName())) {
                currentRuleConfig.getLoadBalancers().remove(op.getLoadBalancerName());
            }
        });
    }

    private boolean isLoadBalancerNotInUse(ReadwriteSplittingRuleConfiguration currentRuleConfig, String toBeDroppedLoadBalancerName) {
        return currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getLoadBalancerName).filter(Objects::nonNull).noneMatch(toBeDroppedLoadBalancerName::equals);
    }

    public boolean hasAnyOneToBeDropped(DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && !this.getIdenticalData(currentRuleConfig.getDataSources().stream().map(each -> each.getName()).collect(Collectors.toSet()), sqlStatement.getRuleNames()).isEmpty();
    }

    public Class<ReadwriteSplittingRuleConfiguration> getRuleConfigurationClass() {
        return ReadwriteSplittingRuleConfiguration.class;
    }

    public String getType() {
        return DropReadwriteSplittingRuleStatement.class.getName();
    }
}

