/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl;

import java.util.LinkedList;
import java.util.Optional;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.statement.SelectStatementConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SubqueryProjectionConverter
implements SQLSegmentConverter<SubqueryProjectionSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convertToSQLNode(SubqueryProjectionSegment segment) {
        if (null == segment) {
            return Optional.empty();
        }
        SqlNode sqlNode = new SelectStatementConverter().convertToSQLNode(segment.getSubquery().getSelect());
        return segment.getAlias().isPresent() ? this.convertToSQLStatement(sqlNode, (String)segment.getAlias().get()) : Optional.of(sqlNode);
    }

    private Optional<SqlNode> convertToSQLStatement(SqlNode sqlNode, String alias) {
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        sqlNodes.add(sqlNode);
        sqlNodes.add(new SqlIdentifier(alias, SqlParserPos.ZERO));
        return Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO));
    }

    @Override
    public Optional<SubqueryProjectionSegment> convertToSQLSegment(SqlNode sqlNode) {
        if (sqlNode instanceof SqlSelect || sqlNode instanceof SqlOrderBy) {
            SelectStatement selectStatement = new SelectStatementConverter().convertToSQLStatement(sqlNode);
            int startIndex = this.getStartIndex(sqlNode) - 1;
            int stopIndex = this.getStopIndex(sqlNode) + 1;
            String text = "(" + sqlNode + ")";
            String originalText = text.replace(System.lineSeparator(), " ").replace(Quoting.BACK_TICK.string, "");
            return Optional.of(new SubqueryProjectionSegment(new SubquerySegment(startIndex, stopIndex, selectStatement), originalText));
        }
        return Optional.empty();
    }
}

